/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.Reference;
import net.aeronica.mods.mxtune.managers.ClientFileManager;
import net.aeronica.mods.mxtune.managers.PlayIdSupplier;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.aeronica.mods.mxtune.managers.records.RecordType;
import net.aeronica.mods.mxtune.managers.records.Song;
import net.aeronica.mods.mxtune.managers.records.SongProxy;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.bidirectional.GetServerDataMessage;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.sound.IAudioStatusCallback;
import net.aeronica.mods.mxtune.status.ClientCSDMonitor;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.aeronica.mods.mxtune.world.caps.chunk.ModChunkPlaylistHelper;
import net.aeronica.mods.mxtune.world.caps.world.ModWorldPlaylistHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientPlayManager
implements IAudioStatusCallback {
    private static final ClientPlayManager INSTANCE = new ClientPlayManager();
    private static Minecraft mc = Minecraft.func_71410_x();
    private static WeakReference<Chunk> currentChunkRef;
    private static int currentPlayId;
    private static GUID currentPlaylistGUID;
    private static GUID previousPlaylistGUID;
    private static String lastSongLine01;
    private static String lastSongLine02;
    public static final int FADE_TIME_CHANGE_SONG = 2;
    public static final int FADE_TIME_RESET = 2;
    public static final int FADE_TIME_STOP_SONG = 1;
    private static List<SongProxy> songProxies;
    private static final Random rand;
    private static Deque<String> lastSongs;
    private static final int NUM_LAST_SONGS = 1000;
    private static int failedNewSongs;
    private static final int MAX_DELAY = 16;
    private static final int MIN_DELAY = 8;
    private static int delay;
    private static int counter;
    private static int ticks;
    private static boolean wait;
    private static boolean night;
    private static boolean lastDuskDawnTransition;

    private ClientPlayManager() {
    }

    public static void reset() {
        if (currentPlayId != -1) {
            ClientAudio.fadeOut(currentPlayId, 2);
            currentPlayId = -1;
        }
        ClientPlayManager.resetTimer(2);
        lastSongs.clear();
        ClientPlayManager.clearLastSongInfo();
        ClientPlayManager.updateDayNight();
        lastDuskDawnTransition = night;
    }

    public static GUID getCurrentPlaylistGUID() {
        return currentPlaylistGUID;
    }

    @SubscribeEvent
    public static void onEvent(TickEvent.ClientTickEvent event) {
        if (ClientCSDMonitor.canMXTunesPlay() && event.phase == TickEvent.Phase.END && (ticks++ % 10 == 0 || Keyboard.isKeyDown((int)29))) {
            ClientPlayManager.updateChunk();
            ClientPlayManager.updateBiome();
            ClientPlayManager.updateWorld();
            ClientPlayManager.updateDayNight();
            ++counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidatePlayId() {
        ClientPlayManager clientPlayManager = INSTANCE;
        synchronized (clientPlayManager) {
            currentPlayId = -1;
        }
    }

    private static void trackLastSongs(@Nonnull SongProxy proxy) {
        int size = lastSongs.size();
        boolean songInDeque = lastSongs.contains(proxy.getTitle());
        if (!songInDeque && size < 1000) {
            lastSongs.addLast(proxy.getTitle());
        } else if (!songInDeque) {
            lastSongs.removeFirst();
            lastSongs.addLast(proxy.getTitle());
        }
        Iterator<String> it = lastSongs.iterator();
        for (int i = 0; i < lastSongs.size(); ++i) {
            String title = it.next();
            ModLogger.debug(".......%02d, title: %s", i + 1, title);
        }
    }

    private static boolean heardSong(String title) {
        boolean manyFails;
        boolean hasSong = lastSongs.contains(title);
        boolean isEmpty = lastSongs.isEmpty();
        boolean bl = manyFails = failedNewSongs > 100;
        if (isEmpty || manyFails) {
            failedNewSongs = 0;
            return false;
        }
        if (hasSong) {
            ++failedNewSongs;
            return true;
        }
        return false;
    }

    @Nullable
    private static Chunk getChunk(WeakReference<Chunk> chunkRef) {
        return chunkRef != null ? (Chunk)chunkRef.get() : null;
    }

    private static void updateChunk() {
        if (ClientPlayManager.mc.field_71441_e == null || ClientPlayManager.mc.field_71439_g == null) {
            return;
        }
        Chunk chunk = ClientPlayManager.mc.field_71441_e.func_175726_f(ClientPlayManager.mc.field_71439_g.func_180425_c());
        if (ClientPlayManager.mc.field_71441_e.func_190526_b(chunk.field_76635_g, chunk.field_76647_h) && chunk.hasCapability(ModChunkPlaylistHelper.MOD_CHUNK_DATA, null)) {
            WeakReference<Chunk> prevChunkRef = currentChunkRef;
            currentChunkRef = new WeakReference<Chunk>(chunk);
            if (prevChunkRef != null && currentChunkRef.get() != prevChunkRef.get() || prevChunkRef == null && currentChunkRef.get() != null || !ModChunkPlaylistHelper.getPlaylistGuid((Chunk)currentChunkRef.get()).equals(currentPlaylistGUID)) {
                ClientPlayManager.chunkChange(currentChunkRef, prevChunkRef);
            }
        }
        ClientPlayManager.updateTimeOfDay();
        ClientPlayManager.changePlayListMusic(false, false);
    }

    private static void chunkChange(WeakReference<Chunk> current, WeakReference<Chunk> previous) {
        Chunk currentChunk = ClientPlayManager.getChunk(current);
        Chunk prevChunk = ClientPlayManager.getChunk(previous);
        if (currentChunk != null && currentChunk.hasCapability(ModChunkPlaylistHelper.MOD_CHUNK_DATA, null)) {
            currentPlaylistGUID = ModChunkPlaylistHelper.getPlaylistGuid(currentChunk);
        }
        if (prevChunk != null && prevChunk.hasCapability(ModChunkPlaylistHelper.MOD_CHUNK_DATA, null)) {
            GUID prevPlayListGUID;
            previousPlaylistGUID = prevPlayListGUID = ModChunkPlaylistHelper.getPlaylistGuid(prevChunk);
        }
        if (!currentPlaylistGUID.equals(previousPlaylistGUID)) {
            ClientPlayManager.changePlayListMusic(true, true);
        }
    }

    private static void changePlayListMusic(boolean chunkChanged, boolean showTitle) {
        if (chunkChanged && currentPlayId != -1) {
            ClientAudio.fadeOut(currentPlayId, 2);
            currentPlayId = -1;
            ClientPlayManager.resetTimer(0);
        }
        if (showTitle) {
            ClientPlayManager.postPlayListTitle(currentPlaylistGUID);
        }
        if (!ClientPlayManager.waiting(chunkChanged) && ClientFileManager.songAvailable(currentPlaylistGUID) && !Reference.NO_MUSIC_GUID.equals(currentPlaylistGUID) && currentPlayId == -1) {
            currentPlayId = PlayIdSupplier.PlayType.BACKGROUND.getAsInt();
            GUID guidSong = ClientPlayManager.randomSong(currentPlaylistGUID);
            if (!Reference.EMPTY_GUID.equals(guidSong) && !ClientFileManager.hasSongProxy(guidSong)) {
                PacketDispatcher.sendToServer(new GetServerDataMessage(guidSong, RecordType.SONG, currentPlayId));
                ModLogger.debug("ChangePlayListMusic: Get from SERVER!", new Object[0]);
            } else if (!Reference.EMPTY_GUID.equals(guidSong) && ClientFileManager.hasSongProxy(guidSong)) {
                ClientPlayManager.playMusic(guidSong, currentPlayId);
                ModLogger.debug("ChangePlayListMusic: Get from CACHE!", new Object[0]);
            } else if (!ClientFileManager.isNotBadSong(guidSong)) {
                ClientPlayManager.resetTimer(0);
                ClientPlayManager.invalidatePlayId();
            } else if (Reference.EMPTY_GUID.equals(guidSong) && Reference.NO_MUSIC_GUID.equals(currentPlaylistGUID)) {
                ClientPlayManager.resetTimer(0);
                ClientPlayManager.invalidatePlayId();
            }
        }
    }

    public static boolean playFromCacheElseServer(GUID guidSong, int playId) {
        Song song;
        if (!Reference.EMPTY_GUID.equals(guidSong) && !ClientFileManager.hasSongProxy(guidSong)) {
            PacketDispatcher.sendToServer(new GetServerDataMessage(guidSong, RecordType.SONG, playId));
            ModLogger.debug("playFromCacheElseServer: Get from SERVER!", new Object[0]);
            return true;
        }
        if (!Reference.EMPTY_GUID.equals(guidSong) && ClientFileManager.hasSongProxy(guidSong) && (song = ClientFileManager.getSongFromCache(guidSong)) != null) {
            ClientAudio.playLocal(playId, song.getMml(), INSTANCE);
            ModLogger.debug("playFromCacheElseServer: Get from CACHE!", new Object[0]);
            return true;
        }
        return false;
    }

    private static void postPlayListTitle(GUID playListGuid) {
        String title;
        PlayList playList = ClientFileManager.getPlayList(playListGuid);
        String string = title = playList != null ? playList.getTitle() : "";
        if (!title.isEmpty()) {
            ClientPlayManager.mc.field_71439_g.func_146105_b((ITextComponent)new TextComponentString(title), true);
        }
    }

    private static void updateBiome() {
    }

    private static void updateWorld() {
        WorldClient world;
        if (ClientPlayManager.mc.field_71441_e == null || ClientPlayManager.mc.field_71439_g == null) {
            return;
        }
        if (Reference.EMPTY_GUID.equals(currentPlaylistGUID) && currentPlayId == -1 && (world = ClientPlayManager.mc.field_71441_e).hasCapability(ModWorldPlaylistHelper.MOD_WORLD_DATA, null)) {
            currentPlaylistGUID = ModWorldPlaylistHelper.getPlaylistGuid((World)world);
            ClientPlayManager.changePlayListMusic(false, false);
        }
    }

    private static void updateDayNight() {
        if (ClientPlayManager.mc.field_71441_e == null || ClientPlayManager.mc.field_71439_g == null) {
            return;
        }
        if (Reference.EMPTY_GUID.equals(currentPlaylistGUID) && currentPlayId == -1 || lastDuskDawnTransition != night) {
            lastDuskDawnTransition = night;
            ClientPlayManager.changePlayListMusic(true, false);
        }
    }

    private static void updateTimeOfDay() {
        long time = ClientPlayManager.mc.field_71441_e.func_72820_D() % 24000L;
        night = time > 13200L && time < 23200L;
    }

    public static void playMusic(GUID musicId, int playId) {
        Song song;
        if (-1 != playId && (song = ClientFileManager.getSongFromCache(musicId)) != null) {
            currentPlayId = playId;
            ClientAudio.playLocal(playId, song.getMml(), INSTANCE);
            ModLogger.debug("BACKGROUND duration: %s, title: %s", SheetMusicUtil.formatDuration(song.getDuration()), song.getTitle());
        }
    }

    private static GUID randomSong(GUID guidPlayList) {
        PlayList playList = ClientFileManager.getPlayList(guidPlayList);
        if (playList != null) {
            songProxies.clear();
            if (night) {
                songProxies.addAll(playList.getPlayListNight());
            } else {
                songProxies.addAll(playList.getPlayListDay());
            }
            int size = songProxies.size();
            if (size == 0) {
                return Reference.EMPTY_GUID;
            }
            SongProxy songProxy = songProxies.get(rand.nextInt(size));
            while (ClientPlayManager.heardSong(songProxy.getTitle())) {
                songProxy = songProxies.get(rand.nextInt(size));
            }
            ClientPlayManager.trackLastSongs(songProxy);
            lastSongLine01 = I18n.func_135052_a((String)"mxtune.info.last_song_line_01", (Object[])new Object[]{playList.getName(), night ? I18n.func_135052_a((String)"mxtune.info.night", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.info.day", (Object[])new Object[0]), SheetMusicUtil.formatDuration(songProxy.getDuration())});
            lastSongLine02 = I18n.func_135052_a((String)"mxtune.info.last_song_line_02", (Object[])new Object[]{songProxy.getTitle()});
            ModLogger.debug(lastSongLine01, new Object[0]);
            ModLogger.debug(lastSongLine02, new Object[0]);
            return songProxy.getGUID();
        }
        ClientPlayManager.clearLastSongInfo();
        return Reference.EMPTY_GUID;
    }

    private static void clearLastSongInfo() {
        String i18nNull = I18n.func_135052_a((String)"mxtune.info.null", (Object[])new Object[0]);
        lastSongLine01 = I18n.func_135052_a((String)"mxtune.info.last_song_line_01", (Object[])new Object[]{i18nNull, i18nNull, i18nNull});
        lastSongLine02 = I18n.func_135052_a((String)"mxtune.info.last_song_line_02", (Object[])new Object[]{I18n.func_135052_a((String)"mxtune.info.playlist.null_playlist", (Object[])new Object[0])});
    }

    public static String getLastSongLine01() {
        return lastSongLine01;
    }

    public static String getLastSongLine02() {
        return lastSongLine02;
    }

    private static boolean waiting(boolean override) {
        Boolean canPlay = override && ClientPlayManager.allInRange(ClientAudio.getActivePlayIDs(), PlayIdSupplier.PlayType.BACKGROUND) || ClientAudio.getActivePlayIDs().isEmpty() && !Reference.EMPTY_GUID.equals(currentPlaylistGUID);
        if (override) {
            ClientPlayManager.resetTimer(0);
        }
        if (canPlay.booleanValue() && !wait) {
            ClientPlayManager.startTimer();
        }
        return canPlay == false || counter <= delay;
    }

    private static boolean allInRange(Set<Integer> playIDs, PlayIdSupplier.PlayType playType) {
        int result = 0;
        for (Integer playId : playIDs) {
            if (PlayIdSupplier.getTypeForPlayId(playId).equals(playType)) continue;
            ++result;
        }
        return result == 0;
    }

    private static void startTimer() {
        counter = 0;
        wait = true;
    }

    public static void resetTimer() {
        delay = (rand.nextInt(8) + 8) * 2;
        wait = false;
    }

    public static void resetTimer(int newDelay) {
        delay = newDelay < 0 ? 0 : newDelay * 2;
        wait = false;
    }

    public static String getDelayTimerDisplay() {
        int normalizedDelay = delay / 2;
        int normalizedCounter = Math.min(normalizedDelay, counter / 2);
        int time = ((int)ClientPlayManager.mc.field_71441_e.func_72820_D() + 30000) % 24000;
        int hour = time / 1000 % 24;
        int minute = (int)((double)time / 16.666666) % 60;
        return String.format("World Time: %02d:%02d %s, Waiting: %s, Delay: %03d, timer: %03d", hour, minute, night ? "night" : "day", ClientPlayManager.waiting(false), normalizedDelay, normalizedCounter);
    }

    public static void removeLowerPriorityPlayIds(int playId) {
        PlayIdSupplier.PlayType testType = PlayIdSupplier.getTypeForPlayId(playId);
        ClientPlayManager.removePlayTypeBelow(ClientAudio.getActivePlayIDs(), testType);
        ClientPlayManager.resetTimer(0);
    }

    private static void removePlayTypeBelow(Set<Integer> setOfPlayIDS, PlayIdSupplier.PlayType playTypeIn) {
        for (int pid : setOfPlayIDS) {
            PlayIdSupplier.PlayType playType = PlayIdSupplier.getTypeForPlayId(pid);
            if (PlayIdSupplier.compare(playTypeIn, playType) <= 0) continue;
            ClientAudio.fadeOut(pid, 1);
        }
    }

    @Override
    public void statusCallBack(ClientAudio.Status status, int playId) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (currentPlayId == playId && (status == ClientAudio.Status.ERROR || status == ClientAudio.Status.DONE)) {
                ClientPlayManager.invalidatePlayId();
                ClientPlayManager.changePlayListMusic(false, false);
                ClientPlayManager.resetTimer();
            }
        });
    }

    static {
        currentPlayId = -1;
        currentPlaylistGUID = Reference.EMPTY_GUID;
        previousPlaylistGUID = Reference.EMPTY_GUID;
        lastSongLine01 = "";
        lastSongLine02 = "";
        songProxies = new ArrayList<SongProxy>();
        rand = new Random();
        lastSongs = new ArrayDeque<String>();
        delay = 8;
        counter = 0;
        ticks = 0;
        wait = false;
    }
}

