/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.items;

import java.util.List;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.Reference;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.client.ResetClientPlayEngine;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.world.caps.chunk.ModChunkPlaylistHelper;
import net.aeronica.mods.mxtune.world.caps.world.ModWorldPlaylistHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ItemStaffOfMusic
extends Item {
    public ItemStaffOfMusic() {
        this.func_77625_d(1);
        this.func_77637_a(MXTune.TAB_MUSIC);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean hasRights = MusicOptionsUtil.isMxTuneServerUpdateAllowed(playerIn);
        if (worldIn.field_72995_K) {
            if (playerIn.func_70093_af() && !MusicOptionsUtil.isCtrlKeyDown(playerIn) && hasRights) {
                playerIn.openGui((Object)MXTune.instance, 7, worldIn, 0, 0, 0);
            } else if (!hasRights) {
                this.notifyPlayer(playerIn, SoundEvents.field_187561_bM, "commands.mxtune.mxtune_server_update_not_allowed");
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        BlockPos pos = playerIn.func_180425_c();
        Chunk chunk = worldIn.func_175726_f(pos);
        GUID playlist = MusicOptionsUtil.getSelectedPlayListGuid(playerIn);
        boolean hasChunkCap = chunk.hasCapability(ModChunkPlaylistHelper.MOD_CHUNK_DATA, null);
        boolean hasWorldCap = worldIn.hasCapability(ModWorldPlaylistHelper.MOD_WORLD_DATA, null);
        if (hasRights) {
            if (hasChunkCap && !playerIn.func_70093_af() && MusicOptionsUtil.isCtrlKeyDown(playerIn)) {
                ModChunkPlaylistHelper.setPlaylistGuid(chunk, playlist);
                ModChunkPlaylistHelper.sync(playerIn, chunk);
                this.notifyPlayer(playerIn, SoundEvents.field_189107_dL, "mxtune.gui.guiStaffOverlay.chunk_update_successful");
                PacketDispatcher.sendToAll(new ResetClientPlayEngine());
            } else if (hasWorldCap && playerIn.func_70093_af() && MusicOptionsUtil.isCtrlKeyDown(playerIn)) {
                if (!Reference.NO_MUSIC_GUID.equals(playlist)) {
                    ModWorldPlaylistHelper.setPlaylistGuid(worldIn, playlist);
                    ModWorldPlaylistHelper.sync(playerIn, worldIn);
                    this.notifyPlayer(playerIn, SoundEvents.field_189107_dL, "mxtune.gui.guiStaffOverlay.world_update_successful");
                    PacketDispatcher.sendToAll(new ResetClientPlayEngine());
                } else {
                    this.notifyPlayer(playerIn, SoundEvents.field_187561_bM, "mxtune.gui.guiStaffOverlay.world_update.cannot_apply_empty_playlist_to_worlds");
                }
            }
        } else {
            this.notifyPlayer(playerIn, SoundEvents.field_187561_bM, "commands.mxtune.mxtune_server_update_not_allowed");
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    private void notifyPlayer(EntityPlayer playerIn, SoundEvent soundEvent, String translationKey) {
        Miscellus.audiblePingPlayer(playerIn, soundEvent);
        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(translationKey, new Object[0]), true);
    }

    public boolean func_77651_p() {
        return true;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 1;
    }

    public void func_77624_a(ItemStack stackIn, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.RESET + I18n.func_135052_a((String)"item.mxtune:staff_of_music.help", (Object[])new Object[0]));
    }
}

