/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.items;

import java.util.List;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.advancements.ModCriteriaTriggers;
import net.aeronica.mods.mxtune.blocks.IPlacedInstrument;
import net.aeronica.mods.mxtune.inventory.IInstrument;
import net.aeronica.mods.mxtune.managers.PlayManager;
import net.aeronica.mods.mxtune.status.ServerCSDManager;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMultiInst
extends Item
implements IInstrument {
    public ItemMultiInst() {
        this.func_77627_a(false);
        this.func_77625_d(1);
        this.func_77637_a(MXTune.TAB_MUSIC);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + SoundFontProxyManager.getName(stack.func_77952_i());
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab) && !SoundFontProxyManager.soundFontProxyMapByIndex.isEmpty()) {
            SoundFontProxyManager.soundFontProxyMapByIndex.keySet().forEach(key -> subItems.add(key.intValue(), (Object)new ItemStack((Item)this, 1, key.intValue())));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStackIn = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (playerIn.func_70093_af() && handIn.equals((Object)EnumHand.MAIN_HAND)) {
                playerIn.openGui((Object)MXTune.instance, 10, worldIn, 0, 0, 0);
            }
            if (!playerIn.func_70093_af() && itemStackIn.func_77942_o() && handIn.equals((Object)EnumHand.MAIN_HAND)) {
                if (ServerCSDManager.canMXTunesPlay(playerIn)) {
                    if (PlayManager.playerNotPlaying(playerIn)) {
                        int playID = PlayManager.playMusic(playerIn);
                        itemStackIn.func_82841_c(playID);
                        if (playID != -1) {
                            ModCriteriaTriggers.PLAY_INSTRUMENT.trigger((EntityPlayerMP)playerIn, SoundFontProxyManager.getName(itemStackIn.func_77960_j()));
                        }
                    }
                } else {
                    ServerCSDManager.sendErrorViaChat(playerIn);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return world.func_180495_p(pos).func_177230_c() instanceof IPlacedInstrument;
    }

    public void func_77663_a(ItemStack stackIn, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            int playID = stackIn.func_82838_A();
            if (!isSelected && (PlayManager.hasPlayID(playID) || PlayManager.isActivePlayID(playID))) {
                PlayManager.stopPlayID(playID);
                stackIn.func_82841_c(-1);
            }
        }
    }

    public int getEntityLifespan(ItemStack stackIn, World worldIn) {
        int playID;
        if (!worldIn.field_72995_K && (PlayManager.hasPlayID(playID = stackIn.func_82838_A()) || PlayManager.isActivePlayID(playID))) {
            PlayManager.stopPlayID(playID);
            stackIn.func_82841_c(-1);
        }
        return super.getEntityLifespan(stackIn, worldIn);
    }

    public boolean onDroppedByPlayer(ItemStack stackIn, EntityPlayer playerIn) {
        int playID;
        if (!playerIn.func_130014_f_().field_72995_K && (PlayManager.hasPlayID(playID = stackIn.func_82838_A()) || PlayManager.isActivePlayID(playID))) {
            PlayManager.stopPlayID(playID);
            stackIn.func_82841_c(-1);
        }
        return true;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        return true;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 72000;
    }

    public void func_77624_a(ItemStack stackIn, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String musicTitle = SheetMusicUtil.getMusicTitle(stackIn);
        if (!musicTitle.isEmpty()) {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"item.mxtune:multi_inst.title", (Object[])new Object[0]) + ": " + musicTitle);
        }
        tooltip.add(TextFormatting.RESET + I18n.func_135052_a((String)"item.mxtune:multi_inst.help", (Object[])new Object[0]));
    }

    @Override
    public int getPatch(ItemStack itemStack) {
        return itemStack.func_77952_i();
    }
}

