/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.handler;

import java.util.Random;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.blocks.IMusicPlayer;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.entity.living.EntityGoldenSkeleton;
import net.aeronica.mods.mxtune.entity.living.EntityTimpani;
import net.aeronica.mods.mxtune.items.ItemSheetMusic;
import net.aeronica.mods.mxtune.managers.PlayManager;
import net.aeronica.mods.mxtune.util.SheetMusicSongs;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.aeronica.mods.mxtune.world.IModLockableContainer;
import net.aeronica.mods.mxtune.world.LockableHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class CommonEventHandler {
    private static int count = 0;

    private CommonEventHandler() {
    }

    @SubscribeEvent
    public static void onEvent(PlayerContainerEvent.Open event) {
        if (MXTune.proxy.getEffectiveSide() == Side.SERVER) {
            PlayManager.stopPlayingPlayer(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public static void onEvent(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END && count++ % 40 == 0) {
            PlayManager.testStopDistance(ModConfig.getGroupPlayAbortDistance());
        }
    }

    @SubscribeEvent
    public static void onEvent(BlockEvent.BreakEvent event) {
        TileEntity tileEntity;
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getState().func_177230_c() instanceof IMusicPlayer && (tileEntity = event.getWorld().func_175625_s(event.getPos())) instanceof IModLockableContainer) {
            boolean isCreativeMode;
            boolean bl = isCreativeMode = event.getPlayer() != null && event.getPlayer().field_71075_bZ.field_75098_d;
            if (LockableHelper.isBreakable(event.getPlayer(), tileEntity.func_145831_w(), event.getPos()) && !isCreativeMode) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEvent(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityGoldenSkeleton || event.getEntityLiving() instanceof EntityTimpani) {
            event.getDrops().forEach(drop -> {
                if (drop.func_92059_d().func_77973_b() instanceof ItemSheetMusic) {
                    Random rand = event.getEntityLiving().func_130014_f_().field_73012_v;
                    int selection = rand.nextInt(SheetMusicSongs.values().length);
                    drop.func_92058_a(SheetMusicUtil.createSheetMusic(SheetMusicSongs.getSong(selection)));
                }
            });
        }
    }
}

