/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.util;

import java.util.List;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.Reference;
import net.aeronica.mods.mxtune.gui.util.IHooverText;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;

public class ModGuiUtils {
    public static final ModGuiUtils INSTANCE = new ModGuiUtils(){};

    public static boolean isPointInRegion(int x, int y, int height, int width, int guiLeft, int guiTop, int pointX, int pointY) {
        int rectX = x - guiLeft;
        int rectY = y - guiTop;
        int rectWidth = width;
        int rectHeight = height;
        return (pointX -= guiLeft) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= guiTop) >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    public static void drawItem(RenderItem itemRenderer, ItemStack stack, int xPos, int yPos, int scale) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        itemRenderer.func_180450_b(stack, xPos, yPos);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    public <T extends GuiScreen, S> void drawHooveringHelp(T guiScreen, List<S> hooverTexts, int guiLeft, int guiTop, int mouseX, int mouseY) {
        for (S text : hooverTexts) {
            if (!(text instanceof IHooverText) || !((IHooverText)text).isMouseOverElement(guiLeft, guiTop, mouseX, mouseY) || !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) continue;
            guiScreen.func_146283_a(((IHooverText)text).getHooverTexts(), mouseX, mouseY);
        }
    }

    public static <T extends GuiTextField> void clearOnMouseLeftClicked(T guiTextField, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 1 && mouseX >= guiTextField.field_146209_f && mouseX < guiTextField.field_146209_f + guiTextField.field_146218_h && mouseY >= guiTextField.field_146210_g && mouseY < guiTextField.field_146210_g + guiTextField.field_146219_i) {
            guiTextField.func_146180_a("");
        }
    }

    public static String getPlaylistName(@Nullable PlayList playlist) {
        if (playlist != null) {
            String temp = playlist.getName().trim();
            if (Reference.EMPTY_GUID.equals(playlist.getGUID())) {
                return I18n.func_135052_a((String)"mxtune.info.playlist.null_playlist", (Object[])new Object[0]);
            }
            if (Reference.NO_MUSIC_GUID.equals(playlist.getGUID())) {
                return I18n.func_135052_a((String)"mxtune.info.playlist.empty_playlist", (Object[])new Object[0]);
            }
            return temp;
        }
        return I18n.func_135052_a((String)"mxtune.info.playlist.null_playlist", (Object[])new Object[0]);
    }

    public static String getLocalizedInstrumentName(String id) {
        return I18n.func_135052_a((String)("item.mxtune:multi_inst." + id + ".name"), (Object[])new Object[0]);
    }
}

