/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiSliderMX
extends GuiButton {
    private float sliderValue;
    private float value;
    private String name;
    private boolean dragging = false;
    private final float valueStep;
    private final float valueMin;
    private final float valueMax;

    public GuiSliderMX(int id, int posX, int posY, int width, int height, String name, float value, float valueMin, float valueMax, float valueStep) {
        super(id, posX, posY, width, height, "");
        this.field_146120_f = width;
        this.field_146121_g = height;
        this.sliderValue = 1.0f;
        this.valueMin = valueMin;
        this.valueMax = valueMax;
        this.valueStep = valueStep;
        this.value = value;
        this.sliderValue = this.normalizeValue(value);
        this.name = name;
        this.field_146126_j = this.getSliderText();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
        this.sliderValue = this.normalizeValue(value);
        this.field_146126_j = this.getSliderText();
    }

    public int getHeight() {
        return this.field_146121_g;
    }

    public int getWidth() {
        return this.field_146120_f;
    }

    private String getSliderText() {
        return String.format("%s: %06.2f", this.name, Float.valueOf(this.value));
    }

    public int func_146114_a(boolean mouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                if (this.sliderValue < 0.0f) {
                    this.sliderValue = 0.0f;
                }
                if (this.sliderValue > 1.0f) {
                    this.sliderValue = 1.0f;
                }
                this.value = this.denormalizeValue(this.sliderValue);
                this.field_146126_j = this.getSliderText();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, this.field_146121_g);
        }
    }

    public boolean func_146116_c(Minecraft mcIn, int mouseX, int mouseY) {
        if (super.func_146116_c(mcIn, mouseX, mouseY)) {
            this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            this.value = this.denormalizeValue(this.sliderValue);
            this.field_146126_j = this.getSliderText();
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.dragging = false;
    }

    private float normalizeValue(float param) {
        return MathHelper.func_76131_a((float)((this.snapToStepClamp(param) - this.valueMin) / (this.valueMax - this.valueMin)), (float)0.0f, (float)1.0f);
    }

    private float denormalizeValue(float param) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.func_76131_a((float)param, (float)0.0f, (float)1.0f));
    }

    private float snapToStepClamp(float paramIn) {
        return MathHelper.func_76131_a((float)this.snapToStep(paramIn), (float)this.valueMin, (float)this.valueMax);
    }

    private float snapToStep(float paramIn) {
        float snapped = paramIn;
        if (this.valueStep > 0.0f) {
            snapped = this.valueStep * (float)Math.round(paramIn / this.valueStep);
        }
        return snapped;
    }
}

