/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.aeronica.mods.mxtune.gui.util.GuiScrollingListOf;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.input.Keyboard;

public abstract class GuiScrollingMultiListOf<E>
extends GuiScrollingListOf<E> {
    protected SortedSet<Integer> selectedRowIndexes = new TreeSet<Integer>();

    public <T extends GuiScreen> GuiScrollingMultiListOf(T gui, int entryHeight, int width, int height, int top, int bottom, int left) {
        super(gui, entryHeight, width, height, top, bottom, left);
        this.setHighlightSelected(false);
    }

    public <T extends GuiScreen> GuiScrollingMultiListOf(T gui) {
        super(gui);
        this.gui = gui;
        this.mc = gui.field_146297_k;
        this.setHighlightSelected(false);
    }

    @Override
    public void setLayout(int entryHeight, int width, int height, int top, int bottom, int left) {
        super.setLayout(entryHeight, width, height, top, bottom, left, this.gui.field_146294_l, this.gui.field_146295_m);
        this.entryHeight = entryHeight;
        this.setHighlightSelected(false);
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        super.elementClicked(index, doubleClick);
        if (Keyboard.isKeyDown((int)29) && !this.selectedRowIndexes.contains(this.selectedIndex)) {
            this.selectedRowIndexes.add(this.selectedIndex);
        } else if (Keyboard.isKeyDown((int)29) && this.selectedRowIndexes.contains(this.selectedIndex)) {
            this.selectedRowIndexes.remove(this.selectedIndex);
        } else if (!Keyboard.isKeyDown((int)29)) {
            this.selectedRowIndexes.clear();
        }
        if (doubleClick) {
            this.selectedDoubleClickedCallback(this.selectedIndex);
        } else {
            this.selectedClickedCallback(this.selectedIndex);
        }
    }

    public void unSelectAll() {
        this.selectedRowIndexes.clear();
    }

    private void selectionToggle() {
        if (!this.selectedRowIndexes.contains(this.selectedIndex)) {
            this.selectedRowIndexes.add(this.selectedIndex);
        } else if (this.selectedRowIndexes.contains(this.selectedIndex)) {
            this.selectedRowIndexes.remove(this.selectedIndex);
        }
    }

    public Set<Integer> getSelectedRowIndexes() {
        return Collections.unmodifiableSet(this.selectedRowIndexes);
    }

    public void setSelectedRowIndexes(Set<Integer> set) {
        this.selectedRowIndexes.clear();
        this.selectedRowIndexes.addAll(set);
    }

    public int getSelectedRowsCount() {
        return this.selectedRowIndexes.size();
    }

    public List<E> getSelectedRows() {
        ArrayList selectedData = new ArrayList();
        for (Integer index : this.selectedRowIndexes) {
            selectedData.add(this.get(index));
        }
        return selectedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedRows() {
        GuiScrollingMultiListOf guiScrollingMultiListOf = this;
        synchronized (guiScrollingMultiListOf) {
            for (int i = this.getSize(); i >= 0; --i) {
                if (!this.selectedRowIndexes.contains(i)) continue;
                this.remove(i);
                this.selectedRowIndexes.remove(i);
            }
        }
    }

    @Override
    protected void selectedClickedCallback(int selectedIndex) {
    }

    @Override
    protected void selectedDoubleClickedCallback(int selectedIndex) {
    }

    @Override
    protected void deleteAction(int index) {
    }

    private float getScrollDistance() {
        return this.scrollDistance;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        block15: {
            block14: {
                if (!this.isPointInRegion() || !Keyboard.isKeyDown((int)29)) break block14;
                int pageSize = (this.bottom - this.top) / this.entryHeight;
                switch (keyCode) {
                    case 57: {
                        this.selectionToggle();
                        break;
                    }
                    case 30: {
                        for (int i = 0; i < this.getSize(); ++i) {
                            this.selectedRowIndexes.add(i);
                        }
                        break block15;
                    }
                    case 32: {
                        this.selectedRowIndexes.clear();
                        break;
                    }
                    case 208: {
                        int next = this.selectedIndex + 1;
                        this.setSelectedIndex(next < this.getSize() ? next : this.getSize());
                        if (next + 1 <= pageSize) break;
                        this.resetScroll();
                        break;
                    }
                    case 200: {
                        int prev = this.selectedIndex - 1;
                        this.setSelectedIndex(prev > 0 ? prev : 0);
                        if (prev > this.selectedIndex) break;
                        this.resetScroll();
                        break;
                    }
                    case 199: {
                        this.scrollToTop();
                        break;
                    }
                    case 207: {
                        this.scrollToEnd();
                        break;
                    }
                    case 209: {
                        int page = Math.min(this.getSize(), this.selectedIndex + pageSize);
                        for (int i = this.selectedIndex; i < page; ++i) {
                            this.selectedRowIndexes.add(i);
                        }
                        this.setSelectedIndex(this.selectedIndex + pageSize - 1);
                        break;
                    }
                    case 201: {
                        int page = Math.max(0, this.selectedIndex - pageSize);
                        for (int i = this.selectedIndex; i >= page; --i) {
                            this.selectedRowIndexes.add(i);
                        }
                        this.setSelectedIndex(this.selectedIndex - pageSize - 1);
                        break;
                    }
                }
                break block15;
            }
            super.keyTyped(typedChar, keyCode);
        }
    }

    private void junk() {
        if (this.isPointInRegion()) {
            if (Keyboard.isKeyDown((int)29)) {
                this.selectedRowIndexes.add(this.selectedIndex);
            } else if (!Keyboard.isKeyDown((int)29)) {
                this.selectedRowIndexes.remove(this.selectedIndex);
            }
        }
    }

    @Override
    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        if (this.selectedRowIndexes.contains(slotIdx) || this.isSelected(slotIdx)) {
            this.drawHighlight(slotIdx, this.getScrollDistance(), tess);
        }
        this.drawSlot(slotIdx, entryRight, slotTop, slotBuffer, this.getScrollDistance(), tess);
    }

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, float var5, Tessellator var6);

    private void drawHighlight(int slotIdx, float scrollDistance, Tessellator tess) {
        BufferBuilder box = tess.func_178180_c();
        int scrollBarWidth = 6;
        int scrollBarRight = this.left + this.listWidth;
        int scrollBarLeft = scrollBarRight - scrollBarWidth;
        int entryRight = scrollBarLeft - 1;
        int border = 4;
        int baseY = this.top + border - (int)scrollDistance;
        int slotTop = baseY + slotIdx * this.slotHeight;
        int slotBuffer = this.slotHeight - border;
        if (slotTop <= this.bottom && slotTop + slotBuffer >= this.top && this.selectedRowIndexes.contains(slotIdx) || this.selectedIndex == slotIdx) {
            int min = this.left;
            int max = entryRight;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179090_x();
            box.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            box.func_181662_b((double)min, (double)(slotTop + slotBuffer) + 2.0, 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            box.func_181662_b((double)max, (double)(slotTop + slotBuffer) + 2.0, 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            box.func_181662_b((double)max, (double)slotTop - 2.0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            box.func_181662_b((double)min, (double)slotTop - 2.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            box.func_181662_b((double)min + 1.0, (double)(slotTop + slotBuffer) + 1.0, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            box.func_181662_b((double)max - 1.0, (double)(slotTop + slotBuffer) + 1.0, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            box.func_181662_b((double)max - 1.0, (double)slotTop - 1.0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            box.func_181662_b((double)min + 1.0, (double)slotTop - 1.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179098_w();
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof List && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

