/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Locale;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.aeronica.mods.mxtune.managers.records.Song;
import net.aeronica.mods.mxtune.managers.records.SongProxy;
import net.minecraft.util.StringUtils;

public final class SortHelper {
    public static final Ordering<PlayList> PLAYLIST_ORDERING = Ordering.from((Comparator)new PlaylistComparator());
    public static final Ordering<SongProxy> SONG_PROXY_ORDERING = Ordering.from((Comparator)new SongProxyComparator());
    public static final Ordering<Song> SONG_ORDERING = Ordering.from((Comparator)new SongComparator());

    private SortHelper() {
    }

    private static String stripCase(String s) {
        return StringUtils.func_76338_a((String)s).toLowerCase(Locale.ROOT);
    }

    static class SongComparator
    implements Comparator<Song> {
        SongComparator() {
        }

        @Override
        public int compare(Song o1, Song o2) {
            return ComparisonChain.start().compare((Comparable)((Object)SortHelper.stripCase(o1.getTitle())), (Comparable)((Object)SortHelper.stripCase(o2.getTitle()))).result();
        }
    }

    static class SongProxyComparator
    implements Comparator<SongProxy> {
        SongProxyComparator() {
        }

        @Override
        public int compare(SongProxy o1, SongProxy o2) {
            return ComparisonChain.start().compare((Comparable)((Object)SortHelper.stripCase(o1.getTitle())), (Comparable)((Object)SortHelper.stripCase(o2.getTitle()))).result();
        }
    }

    static class PlaylistComparator
    implements Comparator<PlayList> {
        PlaylistComparator() {
        }

        @Override
        public int compare(PlayList o1, PlayList o2) {
            return ComparisonChain.start().compare((Comparable)((Object)SortHelper.stripCase(o1.getName())), (Comparable)((Object)SortHelper.stripCase(o2.getName()))).result();
        }
    }
}

