/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.gui.mml.FileData;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.StringUtils;

final class SortFileDataHelper {
    private SortFileDataHelper() {
    }

    static void updateSortButtons(@Nullable SortType sortType, List<GuiButton> buttonList) {
        for (GuiButton button : buttonList) {
            SortType type = SortType.getSortTypeForButton(button);
            if (type != null && type == sortType) {
                button.field_146124_l = false;
                continue;
            }
            if (type == null) continue;
            button.field_146124_l = true;
        }
    }

    public static enum SortType implements Comparator<FileData>
    {
        NATURAL(24),
        ASCENDING(25){

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        DESCENDING(26){

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        private static final int NO_SORT = 0;
        private int buttonID;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
        }

        public int getButtonID() {
            return this.buttonID;
        }

        @Nullable
        public static SortType getSortTypeForButton(GuiButton button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.field_146127_k) continue;
                return t;
            }
            return null;
        }

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(FileData o1, FileData o2) {
            String name1 = StringUtils.func_76338_a((String)o1.name).toLowerCase(Locale.ROOT);
            String name2 = StringUtils.func_76338_a((String)o2.name).toLowerCase(Locale.ROOT);
            return this.compare(name1, name2);
        }
    }
}

