/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import java.io.IOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.Reference;
import net.aeronica.mods.mxtune.gui.mml.GuiMXT;
import net.aeronica.mods.mxtune.gui.mml.SortHelper;
import net.aeronica.mods.mxtune.gui.toasts.ModToastHelper;
import net.aeronica.mods.mxtune.gui.util.GuiButtonMX;
import net.aeronica.mods.mxtune.gui.util.GuiLabelMX;
import net.aeronica.mods.mxtune.gui.util.GuiScrollingListOf;
import net.aeronica.mods.mxtune.gui.util.GuiScrollingMultiListOf;
import net.aeronica.mods.mxtune.gui.util.GuiSortButton;
import net.aeronica.mods.mxtune.gui.util.IHooverText;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.aeronica.mods.mxtune.managers.ClientFileManager;
import net.aeronica.mods.mxtune.managers.ClientPlayManager;
import net.aeronica.mods.mxtune.managers.PlayIdSupplier;
import net.aeronica.mods.mxtune.managers.records.BaseData;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.aeronica.mods.mxtune.managers.records.RecordType;
import net.aeronica.mods.mxtune.managers.records.Song;
import net.aeronica.mods.mxtune.managers.records.SongProxy;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.mxt.MXTuneFileHelper;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.bidirectional.GetBaseDataListsMessage;
import net.aeronica.mods.mxtune.network.bidirectional.SetServerSerializedDataMessage;
import net.aeronica.mods.mxtune.network.server.PlayerSelectedPlayListMessage;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.util.CallBack;
import net.aeronica.mods.mxtune.util.CallBackManager;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.Notify;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiPlaylistManager
extends GuiScreen
implements Notify {
    private static final String TITLE = I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.title", (Object[])new Object[0]);
    private static final int PADDING = 4;
    private GuiLabelMX labelSongList;
    private GuiScrollingMultiListOf<SongProxy> guiSongList;
    private GuiSortButton<SongProxy> buttonSortSongs;
    private int cachedSortMode;
    private GuiLabelMX labelSearch;
    private GuiTextField textSearch;
    private String cachedSearch = "";
    private GuiLabel labelPlayListList;
    private GuiScrollingListOf<PlayList> guiPlayList;
    private GuiLabel labelPlaylistDay;
    private GuiScrollingMultiListOf<SongProxy> guiDay;
    private GuiLabel labelPlaylistNight;
    private GuiScrollingMultiListOf<SongProxy> guiNight;
    private GuiLabelMX labelPlaylistName;
    private GuiTextField textPlayListName;
    private String cachedPlayListName = "";
    private GuiLabelMX labelPlayListTitle;
    private GuiTextField textPlayListTitle;
    private String cachedPlayListTitle;
    private GuiLabelMX labelLog;
    private GuiScrollingListOf<ITextComponent> guiLogList;
    private final DateFormat timeInstance = SimpleDateFormat.getTimeInstance(2);
    private List<IHooverText> hooverTexts = new ArrayList<IHooverText>();
    private GuiLabel labelTitle;
    private boolean cacheKeyRepeatState;
    private boolean isStateCached;
    private GuiButtonMX buttonToServer;
    private Pattern patternPlaylistName = Pattern.compile("^\\s+|\\s+$|^\\[");
    private GuiButtonMX buttonPlayStop;
    private int playId = -1;
    private boolean isPlaying = false;
    private int counter;
    private boolean uploading = false;

    public GuiPlaylistManager() {
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.cacheKeyRepeatState = Keyboard.areRepeatEventsEnabled();
        Keyboard.enableRepeatEvents((boolean)true);
        this.guiSongList = new GuiScrollingMultiListOf<SongProxy>((GuiScreen)this){

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, float scrollDistance, Tessellator tess) {
                SongProxy entry;
                SongProxy songProxy = entry = !this.isEmpty() && slotIdx < this.getSize() && slotIdx >= 0 ? (SongProxy)this.get(slotIdx) : null;
                if (entry != null) {
                    String name = entry.getTitle();
                    String trimmedName = GuiPlaylistManager.this.field_146289_q.func_78269_a(name, this.listWidth - 10);
                    int color = this.selectedRowIndexes.contains(slotIdx) ? 0xFFFF00 : (this.isSelected(slotIdx) ? 35071 : 11393254);
                    GuiPlaylistManager.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, color);
                } else {
                    String name = "---NULL---";
                    String trimmedName = GuiPlaylistManager.this.field_146289_q.func_78269_a(name, this.listWidth - 10);
                    int color = 0xFF0000;
                    GuiPlaylistManager.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, color);
                }
            }

            @Override
            protected void selectedClickedCallback(int selectedIndex) {
                super.selectedClickedCallback(selectedIndex);
                GuiPlaylistManager.this.updateSongCountStatus();
            }
        };
        this.guiPlayList = new GuiScrollingListOf<PlayList>((GuiScreen)this){

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                PlayList playList;
                PlayList playList2 = playList = !this.isEmpty() && slotIdx < this.getSize() && slotIdx >= 0 ? (PlayList)this.get(slotIdx) : null;
                if (playList != null) {
                    String playlistName = ModGuiUtils.getPlaylistName(playList);
                    String trimmedName = GuiPlaylistManager.this.field_146289_q.func_78269_a(playlistName, this.listWidth - 10);
                    int color = this.isSelected(slotIdx) ? 0xFFFF00 : 0xAADDEE;
                    GuiPlaylistManager.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, color);
                } else {
                    String name = "---GUID Conflict---";
                    String trimmedName = GuiPlaylistManager.this.field_146289_q.func_78269_a(name, this.listWidth - 10);
                    int color = 0xFF0000;
                    GuiPlaylistManager.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, color);
                }
            }

            @Override
            protected void selectedClickedCallback(int selectedIndex) {
                GuiPlaylistManager.this.showSelectedPlaylistsPlaylists((PlayList)GuiPlaylistManager.this.guiPlayList.get(selectedIndex));
            }

            @Override
            protected void selectedDoubleClickedCallback(int selectedIndex) {
                GuiPlaylistManager.this.updatePlayersSelectedPlayListGuid((PlayList)GuiPlaylistManager.this.guiPlayList.get(selectedIndex));
            }
        };
        this.guiDay = new GuiScrollingMultiListOf<SongProxy>((GuiScreen)this){

            @Override
            protected void deleteAction(int index) {
                this.deleteSelectedRows();
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, float scrollDistance, Tessellator tess) {
                GuiPlaylistManager.this.drawSlotCommon(this, slotIdx, slotTop, this.listWidth, this.left);
            }
        };
        this.guiNight = new GuiScrollingMultiListOf<SongProxy>((GuiScreen)this){

            @Override
            protected void deleteAction(int index) {
                this.deleteSelectedRows();
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, float scrollDistance, Tessellator tess) {
                GuiPlaylistManager.this.drawSlotCommon(this, slotIdx, slotTop, this.listWidth, this.left);
            }
        };
        this.guiLogList = new GuiScrollingListOf<ITextComponent>((GuiScreen)this){

            @Override
            protected void selectedClickedCallback(int selectedIndex) {
            }

            @Override
            protected void selectedDoubleClickedCallback(int selectedIndex) {
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                ITextComponent component;
                ITextComponent iTextComponent = component = !this.isEmpty() && slotIdx < this.getSize() && slotIdx >= 0 ? (ITextComponent)this.get(slotIdx) : null;
                if (component != null) {
                    String statusEntry = component.func_150254_d();
                    String trimmedName = GuiPlaylistManager.this.field_146289_q.func_78269_a(statusEntry, this.listWidth - 10);
                    GuiPlaylistManager.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, -1);
                }
            }
        };
        this.initGuiHooverHelp();
    }

    public void func_146281_b() {
        this.stop();
        Keyboard.enableRepeatEvents((boolean)this.cacheKeyRepeatState);
    }

    public void func_73866_w_() {
        int listTop;
        int singleLineHeight;
        int guiListWidth;
        this.hooverTexts.clear();
        int buttonHeight = 20;
        int guiBottom = this.field_146295_m - 4;
        int guiSongListWidth = guiListWidth = Math.min(Math.max((this.field_146294_l - 12) / 2, 720), (this.field_146294_l - 12) / 2);
        int entryPlayListHeight = singleLineHeight = this.field_146297_k.field_71466_p.field_78288_b + 2;
        int textEntryHeight = singleLineHeight + 2;
        int leftPlayLists = this.field_146294_l - guiListWidth - 4;
        int titleTop = 4;
        int left = 4;
        int titleWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.title", (Object[])new Object[0]));
        int titleX = this.field_146294_l - titleWidth - 4;
        int titleHeight = singleLineHeight + 2;
        int entryFileHeight = singleLineHeight;
        int buttonWidthMain = 80;
        int buttonTopMain = titleTop;
        int columnLabelsTop = buttonTopMain + buttonHeight + 4;
        int buttonSortSongsTop = listTop = columnLabelsTop + textEntryHeight;
        int buttonSortRight = left + guiSongListWidth;
        int logStatusHeight = singleLineHeight * 5;
        int logStatusTop = guiBottom - logStatusHeight;
        int logStatusBottom = guiBottom;
        int songListTop = listTop + buttonHeight + 4;
        int songListBottom = logStatusTop - singleLineHeight - 4;
        int songListHeight = songListBottom - songListTop;
        int playListNameTop = listTop;
        int playListTitleTop = playListNameTop + buttonHeight + 4;
        int playListTop = playListTitleTop + buttonHeight + 4;
        int thirdsHeight = (guiBottom - playListNameTop - buttonHeight * 3 - 20) / 3;
        int playListListHeight = Math.max(thirdsHeight, entryPlayListHeight);
        int playListBottom = playListTop + thirdsHeight;
        int dayLabelButtonTop = playListBottom + 4;
        int dayTop = dayLabelButtonTop + buttonHeight + 4;
        int dayBottom = dayTop + playListListHeight;
        int nightLabelButtonTop = dayBottom + 4;
        int nightTop = nightLabelButtonTop + buttonHeight + 4;
        int nightBottom = guiBottom;
        this.labelTitle = new GuiLabel(this.field_146289_q, 0, titleX, titleTop, titleWidth, singleLineHeight, 0xFFFFFF);
        this.labelTitle.func_175202_a(TITLE);
        this.buttonPlayStop = new GuiButtonMX(7, left, buttonTopMain, buttonWidthMain, buttonHeight, this.isPlaying ? I18n.func_135052_a((String)"mxtune.gui.button.stop", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.button.play", (Object[])new Object[0]));
        this.buttonPlayStop.field_146124_l = true;
        GuiButton buttonManageMusic = new GuiButton(0, this.buttonPlayStop.field_146128_h + buttonWidthMain, buttonTopMain, buttonWidthMain, buttonHeight, I18n.func_135052_a((String)"mxtune.gui.button.manageMusic", (Object[])new Object[0]));
        GuiButton buttonDone = new GuiButton(1, buttonManageMusic.field_146128_h + buttonWidthMain, buttonTopMain, buttonWidthMain, buttonHeight, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.buttonSortSongs = new GuiSortButton<SongProxy>(24, buttonSortRight - 50, buttonSortSongsTop, 50, 20){

            @Override
            public String getString(SongProxy o) {
                return o.getTitle();
            }
        };
        this.buttonSortSongs.setDisplayText(I18n.func_135052_a((String)"mxtune.gui.button.order_a-z", (Object[])new Object[0]), I18n.func_135052_a((String)"mxtune.gui.button.order_z-a", (Object[])new Object[0]), "");
        this.field_146292_n.add(this.buttonSortSongs);
        this.labelSearch = new GuiLabelMX(this.field_146289_q, 2, left, buttonSortSongsTop + 4, left, singleLineHeight, -1);
        this.labelSearch.setLabelName(I18n.func_135052_a((String)"mxtune.gui.label.search", (Object[])new Object[0]));
        int labelSearchWidth = this.field_146289_q.func_78256_a(this.labelSearch.getLabelName()) + 4;
        this.textSearch = new GuiTextField(2, this.field_146289_q, left + labelSearchWidth, buttonSortSongsTop, guiSongListWidth - labelSearchWidth - this.buttonSortSongs.field_146120_f - 4, 20);
        this.guiSongList.setLayout(entryFileHeight, guiSongListWidth, songListHeight, songListTop, songListBottom, left);
        this.labelSongList = new GuiLabelMX(this.field_146289_q, 1, left, columnLabelsTop, guiSongListWidth, singleLineHeight, -1);
        this.labelSongList.setLabelName(I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.label.music_file_selector", (Object[])new Object[]{this.guiSongList.size()}));
        this.guiPlayList.setLayout(entryPlayListHeight, guiListWidth, playListListHeight, playListTop, playListBottom, leftPlayLists);
        this.guiDay.setLayout(singleLineHeight, guiListWidth, playListListHeight, dayTop, dayBottom, leftPlayLists);
        this.guiNight.setLayout(singleLineHeight, guiListWidth, nightBottom - nightTop, nightTop, nightBottom, leftPlayLists);
        this.guiLogList.setLayout(singleLineHeight, guiListWidth, logStatusHeight, logStatusTop, logStatusBottom, left);
        this.labelLog = new GuiLabelMX(this.field_146289_q, 2, left, logStatusTop - singleLineHeight, guiListWidth, singleLineHeight, -1);
        this.labelLog.setLabelName(I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.label.status_log", (Object[])new Object[0]));
        this.labelPlayListList = new GuiLabel(this.field_146289_q, 3, this.guiPlayList.getRight() - guiListWidth, columnLabelsTop, guiListWidth, singleLineHeight, 0xFFFFFF);
        this.labelPlayListList.func_175202_a("mxtune.gui.guiPlayListManager.label.playlist_selector");
        int selectButtonLeft = this.guiSongList.getRight() + 4;
        this.labelPlaylistName = new GuiLabelMX(this.field_146289_q, 4, selectButtonLeft, listTop + 4, guiListWidth, singleLineHeight, -1);
        this.labelPlaylistName.setLabelName(I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.label.playlist_name", (Object[])new Object[0]));
        int labelPlayListNameWidth = this.field_146289_q.func_78256_a(this.labelPlaylistName.getLabelName()) + 4;
        this.textPlayListName = new GuiTextField(1, this.field_146289_q, leftPlayLists + labelPlayListNameWidth, playListNameTop, guiListWidth - labelPlayListNameWidth - 75 - 4, buttonHeight);
        this.textPlayListName.func_146203_f(25);
        this.buttonToServer = new GuiButtonMX(6, this.field_146294_l - 75 - 4, playListNameTop, 75, buttonHeight, I18n.func_135052_a((String)"mxtune.gui.button.send", (Object[])new Object[0]));
        this.labelPlayListTitle = new GuiLabelMX(this.field_146289_q, 4, selectButtonLeft, playListTitleTop + 4, guiListWidth, singleLineHeight, -1);
        this.labelPlayListTitle.setLabelName(I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.label.playlist_title", (Object[])new Object[0]));
        int labelPlayListTitleWidth = this.field_146289_q.func_78256_a(this.labelPlayListTitle.getLabelName()) + 4;
        this.textPlayListTitle = new GuiTextField(1, this.field_146289_q, leftPlayLists + labelPlayListNameWidth, playListTitleTop, guiListWidth - labelPlayListNameWidth, buttonHeight);
        this.textPlayListTitle.func_146203_f(50);
        this.labelPlaylistDay = new GuiLabel(this.field_146289_q, 5, leftPlayLists, dayLabelButtonTop + 4, guiListWidth, singleLineHeight, 0xFFFFFF);
        this.labelPlaylistDay.func_175202_a("mxtune.gui.guiPlayListManager.label.list_day");
        this.labelPlaylistNight = new GuiLabel(this.field_146289_q, 6, leftPlayLists, nightLabelButtonTop + 4, guiListWidth, singleLineHeight, 0xFFFFFF);
        this.labelPlaylistNight.func_175202_a("mxtune.gui.guiPlayListManager.label.list_night");
        GuiButton buttonToDay = new GuiButton(2, this.field_146294_l - 150 - 4, dayLabelButtonTop, 75, buttonHeight, I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.button.to_day_list", (Object[])new Object[0]));
        GuiButton buttonToNight = new GuiButton(3, this.field_146294_l - 150 - 4, nightLabelButtonTop, 75, buttonHeight, I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.button.to_night_list", (Object[])new Object[0]));
        GuiButton buttonDDeleteDay = new GuiButton(4, this.field_146294_l - 75 - 4, dayLabelButtonTop, 75, buttonHeight, I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.button.delete", (Object[])new Object[0]));
        GuiButton buttonDDeleteNight = new GuiButton(5, this.field_146294_l - 75 - 4, nightLabelButtonTop, 75, buttonHeight, I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.button.delete", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonPlayStop);
        this.field_146292_n.add(buttonManageMusic);
        this.field_146292_n.add(buttonDone);
        this.field_146292_n.add(buttonToDay);
        this.field_146292_n.add(buttonToNight);
        this.field_146292_n.add(buttonDDeleteDay);
        this.field_146292_n.add(buttonDDeleteNight);
        this.field_146292_n.add(this.buttonToServer);
        this.hooverTexts.add(this.guiSongList);
        this.hooverTexts.add(this.guiPlayList);
        this.hooverTexts.add(this.guiDay);
        this.hooverTexts.add(this.guiNight);
        this.initPlayLists();
        this.initSongList();
        this.reloadState();
    }

    private <T extends GuiScrollingMultiListOf<SongProxy>> void drawSlotCommon(T parent, int slotIdx, int slotTop, int listWidth, int left) {
        SongProxy entry = (SongProxy)parent.get(slotIdx);
        if (entry != null) {
            String name = entry.getTitle();
            String trimmedName = this.field_146289_q.func_78269_a(name, listWidth - 10);
            int color = parent.getSelectedRowIndexes().contains(slotIdx) ? 0xFFFF00 : 11393254;
            this.field_146289_q.func_175063_a(trimmedName, (float)left + 3.0f, (float)slotTop, color);
        } else {
            String name = "---GUID Conflict---";
            String trimmedName = this.field_146289_q.func_78269_a(name, listWidth - 10);
            int color = 0xFF0000;
            this.field_146289_q.func_175063_a(trimmedName, (float)left + 3.0f, (float)slotTop, color);
        }
    }

    private void reloadState() {
        if (!this.isStateCached) {
            return;
        }
        this.textSearch.func_146180_a(this.cachedSearch);
        this.textPlayListName.func_146180_a(this.cachedPlayListName);
        this.textPlayListTitle.func_146180_a(this.cachedPlayListTitle);
        this.guiLogList.scrollToEnd();
        this.updateSongCountStatus();
        this.guiPlayList.resetScroll();
        this.buttonSortSongs.setSortMode(this.cachedSortMode);
        this.guiSongList.resetScroll();
    }

    private void updateState() {
        this.cachedPlayListName = this.textPlayListName.func_146179_b();
        this.cachedPlayListTitle = this.textPlayListTitle.func_146179_b();
        this.buttonToServer.field_146124_l = !this.textPlayListName.func_146179_b().equals("") && this.globalMatcher(this.patternPlaylistName, this.textPlayListName.func_146179_b()) && (!this.guiDay.isEmpty() || !this.guiNight.isEmpty()) && !this.uploading;
        this.textPlayListTitle.func_146184_c(this.buttonToServer.field_146124_l);
        this.textPlayListTitle.func_146189_e(this.buttonToServer.field_146124_l);
        this.labelPlayListTitle.setVisible(this.buttonToServer.field_146124_l);
        this.cachedSortMode = this.buttonSortSongs.getSortMode();
        this.buttonPlayStop.field_146126_j = this.isPlaying ? I18n.func_135052_a((String)"mxtune.gui.button.stop", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.button.play", (Object[])new Object[0]);
        this.searchAndSort();
        this.updateSongCountStatus();
        this.isStateCached = true;
    }

    private void searchAndSort() {
        if (!this.textSearch.func_146179_b().equals(this.cachedSearch)) {
            ArrayList<SongProxy> songProxies = new ArrayList<SongProxy>();
            for (SongProxy songProxy : ClientFileManager.getCachedServerSongList()) {
                if (!songProxy.getTitle().toLowerCase(Locale.ROOT).contains(this.textSearch.func_146179_b().toLowerCase(Locale.ROOT))) continue;
                songProxies.add(songProxy);
            }
            this.guiSongList.unSelectAll();
            this.guiSongList.clear();
            this.guiSongList.addAll(songProxies);
            this.guiSongList.sort(this.buttonSortSongs);
            this.cachedSearch = this.textSearch.func_146179_b();
        }
    }

    private boolean globalMatcher(Pattern pattern, String string) {
        int result = 0;
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            ++result;
        }
        return result == 0;
    }

    private void updateSongCountStatus() {
        this.labelSongList.setLabelName(I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.label.music_file_selector", (Object[])new Object[]{this.guiSongList.getSelectedRowsCount()}));
    }

    private void updateStatus(String message) {
        Date dateNow = new Date();
        String now = this.timeInstance.format(dateNow);
        this.guiLogList.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + now + ": " + TextFormatting.RESET + message));
        this.guiLogList.scrollToEnd();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.labelTitle.func_146159_a(this.field_146297_k, mouseX, mouseY);
        this.labelSongList.drawLabel(this.field_146297_k, mouseX, mouseY);
        this.labelSearch.drawLabel(this.field_146297_k, mouseX, mouseY);
        this.labelPlaylistName.drawLabel(this.field_146297_k, mouseX, mouseY);
        this.labelPlayListTitle.drawLabel(this.field_146297_k, mouseX, mouseY);
        this.labelPlayListList.func_146159_a(this.field_146297_k, mouseX, mouseY);
        this.labelPlaylistDay.func_146159_a(this.field_146297_k, mouseX, mouseY);
        this.labelPlaylistNight.func_146159_a(this.field_146297_k, mouseX, mouseY);
        this.labelLog.drawLabel(this.field_146297_k, mouseX, mouseY);
        this.textPlayListName.func_146194_f();
        this.textPlayListTitle.func_146194_f();
        this.textSearch.func_146194_f();
        this.guiSongList.drawScreen(mouseX, mouseY, partialTicks);
        this.guiPlayList.drawScreen(mouseX, mouseY, partialTicks);
        this.guiDay.drawScreen(mouseX, mouseY, partialTicks);
        this.guiNight.drawScreen(mouseX, mouseY, partialTicks);
        this.guiLogList.drawScreen(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ModGuiUtils.INSTANCE.drawHooveringHelp(this, this.hooverTexts, 0, 0, mouseX, mouseY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73876_c() {
        if (this.counter++ % 10 == 0) {
            ClientAudio clientAudio = ClientAudio.INSTANCE;
            synchronized (clientAudio) {
                this.isPlaying = ClientAudio.getActivePlayIDs().contains(this.playId);
                this.buttonPlayStop.field_146126_j = this.isPlaying ? I18n.func_135052_a((String)"mxtune.gui.button.stop", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.button.play", (Object[])new Object[0]);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (!button.field_146124_l) {
            return;
        }
        switch (button.field_146127_k) {
            case 0: {
                this.stop();
                this.textSearch.func_146180_a("");
                this.cachedSearch = "";
                this.guiSongList.unSelectAll();
                this.field_146297_k.func_147108_a((GuiScreen)new GuiMXT(this, GuiMXT.Mode.SERVER));
                break;
            }
            case 1: {
                this.stop();
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 2: {
                this.guiDay.addAll(this.addSelectedSongsToSpecifiedPlayList(this.guiSongList.getSelectedRows(), this.guiDay.getList()));
                break;
            }
            case 3: {
                this.guiNight.addAll(this.addSelectedSongsToSpecifiedPlayList(this.guiSongList.getSelectedRows(), this.guiNight.getList()));
                break;
            }
            case 4: {
                this.guiDay.deleteSelectedRows();
                break;
            }
            case 5: {
                this.guiNight.deleteSelectedRows();
                break;
            }
            case 6: {
                this.shipIt();
                break;
            }
            case 7: {
                this.play();
                break;
            }
            case 24: {
                this.guiSongList.sort(this.buttonSortSongs);
                this.guiSongList.unSelectAll();
                break;
            }
        }
        this.updateState();
        super.func_146284_a(button);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode != 15) {
            this.textPlayListName.func_146201_a(typedChar, keyCode);
            this.textPlayListTitle.func_146201_a(typedChar, keyCode);
            this.textSearch.func_146201_a(typedChar, keyCode);
        }
        this.guiSongList.keyTyped(typedChar, keyCode);
        this.guiPlayList.keyTyped(typedChar, keyCode);
        this.guiDay.keyTyped(typedChar, keyCode);
        this.guiNight.keyTyped(typedChar, keyCode);
        this.guiLogList.keyTyped(typedChar, keyCode);
        this.updateState();
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_175273_b(@Nonnull Minecraft mcIn, int w, int h) {
        this.updateState();
        super.func_175273_b(mcIn, w, h);
        this.updateState();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.textPlayListName.func_146192_a(mouseX, mouseY, mouseButton);
        this.textPlayListTitle.func_146192_a(mouseX, mouseY, mouseButton);
        this.textSearch.func_146192_a(mouseX, mouseY, mouseButton);
        ModGuiUtils.clearOnMouseLeftClicked(this.textSearch, mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.updateState();
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.guiPlayList.handleMouseInput(mouseX, mouseY);
        this.guiSongList.handleMouseInput(mouseX, mouseY);
        this.guiLogList.handleMouseInput(mouseX, mouseY);
        this.guiDay.handleMouseInput(mouseX, mouseY);
        this.guiNight.handleMouseInput(mouseX, mouseY);
        super.func_146274_d();
    }

    @Nullable
    private SongProxy pathToSongProxy(Path path) {
        MXTuneFile mxTuneFile = MXTuneFileHelper.getMXTuneFile(path);
        if (mxTuneFile != null) {
            return MXTuneFileHelper.getSongProxy(mxTuneFile);
        }
        ModLogger.warn("mxt file is missing or corrupt", new Object[0]);
        return null;
    }

    @Nullable
    private Song pathToSong(Path path) {
        MXTuneFile mxTuneFile = MXTuneFileHelper.getMXTuneFile(path);
        if (mxTuneFile != null) {
            return MXTuneFileHelper.getSong(mxTuneFile);
        }
        ModLogger.warn("mxt file is missing or corrupt", new Object[0]);
        return null;
    }

    private List<SongProxy> addSelectedSongsToSpecifiedPlayList(List<SongProxy> serverSongs, List<SongProxy> current) {
        ArrayList<SongProxy> songList = new ArrayList<SongProxy>(current);
        for (SongProxy songProxyServer : serverSongs) {
            if (songList.contains(songProxyServer)) continue;
            songList.add(songProxyServer);
        }
        current.clear();
        return SortHelper.SONG_PROXY_ORDERING.sortedCopy(songList);
    }

    private void shipIt() {
        String playListNameText = StringUtils.func_76338_a((String)this.textPlayListName.func_146179_b()).trim();
        String playListTitleText = StringUtils.func_76338_a((String)this.textPlayListTitle.func_146179_b()).trim();
        if (playListNameText.isEmpty()) {
            return;
        }
        this.uploading = true;
        this.textPlayListName.func_146180_a(playListNameText);
        PlayList playList = new PlayList(this.textPlayListName.func_146179_b(), this.guiDay.getList(), this.guiNight.getList());
        playList.setTitle(playListTitleText);
        this.updateStatus(TextFormatting.GOLD + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.log.upload_playlist", (Object[])new Object[]{TextFormatting.RESET + this.textPlayListName.func_146179_b().trim()}));
        PacketDispatcher.sendToServer(new SetServerSerializedDataMessage(playList.getGUID(), RecordType.PLAY_LIST, playList));
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ModToastHelper.postPlayListManagerToast();
            this.uploading = false;
            this.initPlayLists();
            this.updateState();
        }).start();
    }

    private void initSongList() {
        PacketDispatcher.sendToServer(new GetBaseDataListsMessage(CallBackManager.register((CallBack)ClientFileManager.INSTANCE, this), RecordType.SONG_PROXY));
    }

    private void initPlayLists() {
        PacketDispatcher.sendToServer(new GetBaseDataListsMessage(CallBackManager.register((CallBack)ClientFileManager.INSTANCE, this), RecordType.PLAY_LIST));
    }

    @Override
    public void onNotify(RecordType recordType) {
        switch (recordType) {
            case SONG_PROXY: {
                this.guiSongList.clear();
                this.guiSongList.addAll(ClientFileManager.getCachedServerSongList());
                this.guiSongList.sort(this.buttonSortSongs);
                break;
            }
            case PLAY_LIST: {
                this.guiPlayList.clear();
                this.guiPlayList.addAll(SortHelper.PLAYLIST_ORDERING.sortedCopy(ClientFileManager.getPlayLists()));
                break;
            }
        }
        this.updateState();
    }

    private void showSelectedPlaylistsPlaylists(PlayList selectedPlayList) {
        if (selectedPlayList != null) {
            if (!Reference.NO_MUSIC_GUID.equals(selectedPlayList.getGUID()) && !Reference.EMPTY_GUID.equals(selectedPlayList.getGUID())) {
                this.textPlayListName.func_146180_a(ModGuiUtils.getPlaylistName(selectedPlayList));
            } else {
                this.textPlayListName.func_146180_a("");
            }
            this.guiDay.clear();
            this.guiNight.clear();
            this.guiDay.addAll(SortHelper.SONG_PROXY_ORDERING.sortedCopy(selectedPlayList.getPlayListDay()));
            this.guiNight.addAll(SortHelper.SONG_PROXY_ORDERING.sortedCopy(selectedPlayList.getPlayListNight()));
            this.textPlayListTitle.func_146180_a(selectedPlayList.getTitle());
            this.updateState();
        }
    }

    private void updatePlayersSelectedPlayListGuid(PlayList selectedPlayList) {
        if (selectedPlayList != null) {
            PacketDispatcher.sendToServer(new PlayerSelectedPlayListMessage(selectedPlayList.getGUID()));
            String playListNameOrUndefined = ModGuiUtils.getPlaylistName(selectedPlayList);
            this.updateStatus(TextFormatting.GOLD + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.log.set_staff_of_music_playlist", (Object[])new Object[]{TextFormatting.RESET + playListNameOrUndefined}));
        } else {
            this.updateStatus(TextFormatting.DARK_RED + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.log.failed_set_staff_of_music_playlist", (Object[])new Object[0]));
        }
    }

    private boolean mmlPlay(GUID guidSong) {
        if (guidSong != null && !guidSong.equals(Reference.EMPTY_GUID) && !guidSong.equals(Reference.NO_MUSIC_GUID)) {
            this.playId = PlayIdSupplier.PlayType.PERSONAL.getAsInt();
            return ClientPlayManager.playFromCacheElseServer(guidSong, this.playId);
        }
        return false;
    }

    private void play() {
        if (this.isPlaying) {
            this.stop();
        } else {
            BaseData song;
            BaseData baseData = song = !this.guiSongList.isEmpty() && this.guiSongList.isSelected(this.guiSongList.getSelectedIndex()) ? (SongProxy)this.guiSongList.get(this.guiSongList.getSelectedIndex()) : null;
            if (song != null && !this.isPlaying) {
                this.isPlaying = this.mmlPlay(song.getGUID());
                this.updateStatus(TextFormatting.GOLD + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.log.play", (Object[])new Object[]{SheetMusicUtil.formatDuration(((SongProxy)song).getDuration()), TextFormatting.RESET + ((SongProxy)song).getTitle()}));
            } else {
                this.isPlaying = false;
            }
        }
    }

    private void stop() {
        ClientAudio.fadeOut(this.playId, 1);
        this.isPlaying = false;
        this.playId = -1;
    }

    private void initGuiHooverHelp() {
        this.guiSongList.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.label.music_file_selector", (Object[])new Object[]{"n"}));
        this.guiSongList.addHooverTexts(TextFormatting.RESET + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.multi_selector_01", new Object[]{TextFormatting.GOLD + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.ctrl_plus_mouse_left_click", new Object[0]).func_150254_d()}).func_150254_d());
        this.guiSongList.addHooverTexts(TextFormatting.RESET + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.multi_selector_01", new Object[]{TextFormatting.GOLD + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.ctrl_plus_spacebar_up_down_arrow_keys", new Object[0]).func_150254_d()}).func_150254_d());
        this.guiPlayList.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.label.playlist_selector", (Object[])new Object[0]));
        this.guiPlayList.addHooverTexts(TextFormatting.RESET + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.help.playlist_selector_01", (Object[])new Object[0]));
        this.guiPlayList.addHooverTexts(TextFormatting.RESET + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.help.playlist_selector_02", (Object[])new Object[0]));
        this.guiPlayList.addHooverTexts(TextFormatting.RESET + "");
        this.guiPlayList.addHooverTexts(TextFormatting.AQUA + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.playlist_selector_03", new Object[0]).func_150254_d());
        this.guiPlayList.addHooverTexts(TextFormatting.RESET + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.playlist_selector_04", new Object[]{TextFormatting.GOLD + new TextComponentTranslation("mxtune.info.playlist.null_playlist", new Object[0]).func_150254_d()}).func_150254_d());
        this.guiPlayList.addHooverTexts(TextFormatting.RESET + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.playlist_selector_05", new Object[]{TextFormatting.GOLD + new TextComponentTranslation("mxtune.info.playlist.empty_playlist", new Object[0]).func_150254_d()}).func_150254_d());
        this.guiDay.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.label.list_day", (Object[])new Object[0]));
        this.guiDay.addHooverTexts(TextFormatting.RESET + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.multi_selector_01", new Object[]{TextFormatting.GOLD + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.ctrl_plus_mouse_left_click", new Object[0]).func_150254_d()}).func_150254_d());
        this.guiDay.addHooverTexts(TextFormatting.RESET + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.multi_selector_01", new Object[]{TextFormatting.GOLD + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.ctrl_plus_spacebar_up_down_arrow_keys", new Object[0]).func_150254_d()}).func_150254_d());
        this.guiNight.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.guiPlayListManager.label.list_night", (Object[])new Object[0]));
        this.guiNight.addHooverTexts(TextFormatting.RESET + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.multi_selector_01", new Object[]{TextFormatting.GOLD + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.ctrl_plus_mouse_left_click", new Object[0]).func_150254_d()}).func_150254_d());
        this.guiNight.addHooverTexts(TextFormatting.RESET + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.multi_selector_01", new Object[]{TextFormatting.GOLD + new TextComponentTranslation("mxtune.gui.guiPlayListManager.help.ctrl_plus_spacebar_up_down_arrow_keys", new Object[0]).func_150254_d()}).func_150254_d());
    }
}

