/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.aeronica.mods.mxtune.gui.mml.GuiMXT;
import net.aeronica.mods.mxtune.gui.util.GuiLabelMX;
import net.aeronica.mods.mxtune.gui.util.GuiScrollingListOf;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.aeronica.mods.mxtune.managers.PlayIdSupplier;
import net.aeronica.mods.mxtune.mxt.MXTunePart;
import net.aeronica.mods.mxtune.mxt.MXTuneStaff;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.sound.IAudioStatusCallback;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.aeronica.mods.mxtune.util.SoundFontProxy;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import net.aeronica.mods.mxtune.util.ValidDuration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiMXTPartTab
extends GuiScreen
implements IAudioStatusCallback {
    private static final String LABEL_INSTRUMENTS = I18n.func_135052_a((String)"mxtune.gui.musicPaperParse.labelInstruments", (Object[])new Object[0]);
    private static final String LABEL_STATUS = I18n.func_135052_a((String)"mxtune.gui.guiMXT.labelStatus", (Object[])new Object[0]);
    private final GuiMXT guiMXT;
    private int top;
    private int bottom;
    private int entryHeight;
    private static final int PADDING = 4;
    private MXTunePart mxTunePart = new MXTunePart();
    private GuiTextField labelStatus;
    private GuiButtonExt buttonPlay;
    private final GuiScrollingListOf<SoundFontProxy> listBoxInstruments;
    private static final int MAX_MML_LINES = 10;
    private static final int MIN_MML_LINES = 1;
    private static final int MML_LINE_IDX = 200;
    private final GuiTextField[] mmlTextLines = new GuiTextField[10];
    private final GuiLabelMX[] mmlLabelLines = new GuiLabelMX[10];
    private final String[] cachedTextLines = new String[10];
    private final int[] cachedCursorPos = new int[10];
    private GuiButtonExt buttonAddLine;
    private GuiButtonExt buttonMinusLine;
    private GuiButtonExt buttonPasteFromClipBoard;
    private GuiButtonExt buttonCopyToClipBoard;
    private static final String[] lineNames = new String[10];
    private int viewableLineCount = 1;
    private int cachedViewableLineCount = 1;
    private int totalCharacters;
    private boolean firstParse = false;
    private int duration;
    private int playId = -1;
    private int instListWidth;
    private boolean isPlaying = false;
    private boolean isStateCached = false;
    private boolean cachedIsPlaying;
    private int cachedSelectedInst;

    public GuiMXTPartTab(GuiMXT guiMXT) {
        this.guiMXT = guiMXT;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.entryHeight = this.field_146289_q.field_78288_b + 2;
        Keyboard.enableRepeatEvents((boolean)true);
        Arrays.fill(this.cachedTextLines, "");
        GuiMXTPartTab.initPartNames();
        this.listBoxInstruments = new GuiScrollingListOf<SoundFontProxy>((GuiScreen)this){

            @Override
            protected void selectedClickedCallback(int selectedIndex) {
                GuiMXTPartTab.this.selectInstrument();
                GuiMXTPartTab.this.updateState();
            }

            @Override
            protected void selectedDoubleClickedCallback(int selectedIndex) {
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                SoundFontProxy soundFontProxy;
                SoundFontProxy soundFontProxy2 = soundFontProxy = !this.isEmpty() && slotIdx < this.getSize() && slotIdx >= 0 ? (SoundFontProxy)this.get(slotIdx) : null;
                if (soundFontProxy != null) {
                    String s = GuiMXTPartTab.this.field_146289_q.func_78269_a(ModGuiUtils.getLocalizedInstrumentName(soundFontProxy.id), this.listWidth - 10);
                    int color = this.isSelected(slotIdx) ? 0xFFFF00 : 0xAADDEE;
                    GuiMXTPartTab.this.field_146289_q.func_78276_b(s, this.left + 3, slotTop, color);
                }
            }
        };
        this.listBoxInstruments.addAll((Collection<SoundFontProxy>)SoundFontProxyManager.soundFontProxyMapByIndex.values());
    }

    void setLayout(int top, int bottom) {
        this.field_146294_l = this.guiMXT.field_146294_l;
        this.field_146295_m = this.guiMXT.field_146295_m;
        this.top = top;
        this.bottom = bottom;
    }

    void setPart(MXTunePart mxTunePart) {
        this.clearPart();
        NBTTagCompound compound = new NBTTagCompound();
        mxTunePart.writeToNBT(compound);
        this.mxTunePart = new MXTunePart(compound);
        this.listBoxInstruments.setSelectedIndex(SoundFontProxyManager.getIndexById(mxTunePart.getInstrumentName()));
        this.listBoxInstruments.resetScroll();
        Iterator<MXTuneStaff> iterator = mxTunePart.getStaves().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            this.mmlTextLines[i].func_146180_a(iterator.next().getMml());
            this.mmlTextLines[i++].func_146196_d();
            if (!iterator.hasNext()) continue;
            this.addLine();
        }
        this.updateState();
        this.func_73866_w_();
    }

    MXTunePart getPart() {
        return this.mxTunePart;
    }

    int getDuration() {
        return this.duration;
    }

    void updatePart() {
        ArrayList<MXTuneStaff> staves = new ArrayList<MXTuneStaff>();
        for (int i = 0; i < this.viewableLineCount; ++i) {
            staves.add(new MXTuneStaff(i, this.mmlTextLines[i].func_146179_b()));
        }
        this.mxTunePart.setStaves(staves);
        this.selectInstrument();
    }

    public void clearPart() {
        this.mxTunePart = new MXTunePart();
        this.listBoxInstruments.setSelectedIndex(-1);
        this.listBoxInstruments.resetScroll();
        IntStream.range(0, 10).forEach(i -> this.mmlTextLines[i].func_146180_a(""));
        this.viewableLineCount = 1;
        this.updateState();
        this.func_73866_w_();
    }

    public void func_73876_c() {
        for (int i = 0; i < this.viewableLineCount; ++i) {
            this.mmlTextLines[i].func_146178_a();
        }
    }

    private static void initPartNames() {
        GuiMXTPartTab.lineNames[0] = I18n.func_135052_a((String)"mxtune.gui.label.melody", (Object[])new Object[0]);
        IntStream.range(1, 10).forEach(i -> {
            GuiMXTPartTab.lineNames[i] = I18n.func_135052_a((String)"mxtune.gui.label.chord", (Object[])new Object[]{String.format("%02d", i)});
        });
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        for (SoundFontProxy in : this.listBoxInstruments) {
            int stringWidth = this.field_146289_q.func_78256_a(ModGuiUtils.getLocalizedInstrumentName(in.id));
            this.instListWidth = Math.max(this.instListWidth, stringWidth + 10);
        }
        this.instListWidth = Math.min(this.instListWidth, 150);
        this.buttonPlay = new GuiButtonExt(0, 4, this.bottom - 20, this.instListWidth, 20, this.isPlaying ? I18n.func_135052_a((String)"mxtune.gui.button.stop", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.button.play_part", (Object[])new Object[0]));
        this.buttonPlay.field_146124_l = false;
        this.field_146292_n.add(this.buttonPlay);
        int posY = this.top + 15;
        int statusHeight = this.entryHeight;
        this.listBoxInstruments.setLayout(this.entryHeight, this.instListWidth, Math.max(this.buttonPlay.field_146129_i - 4 - posY, this.entryHeight), posY, this.buttonPlay.field_146129_i - 4, 4);
        int posX = this.listBoxInstruments.getRight() + 4;
        int rightSideWidth = Math.max(this.field_146294_l - posX - 4, 100);
        this.labelStatus = new GuiTextField(2, this.field_146289_q, posX, posY, rightSideWidth, statusHeight);
        this.labelStatus.func_146195_b(false);
        this.labelStatus.func_146205_d(true);
        this.labelStatus.func_146184_c(true);
        this.labelStatus.func_146203_f(150);
        posY = this.labelStatus.field_146210_g + this.labelStatus.field_146219_i + 4;
        this.buttonAddLine = new GuiButtonExt(1, posX, posY, 40, 20, I18n.func_135052_a((String)"mxtune.gui.button.plus", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonAddLine);
        this.buttonMinusLine = new GuiButtonExt(2, this.buttonAddLine.field_146128_h + this.buttonAddLine.field_146120_f, posY, 40, 20, I18n.func_135052_a((String)"mxtune.gui.button.minus", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonMinusLine);
        this.buttonPasteFromClipBoard = new GuiButtonExt(3, posX, this.buttonMinusLine.field_146129_i + this.buttonMinusLine.field_146121_g + 4, 120, 20, I18n.func_135052_a((String)"mxtune.gui.button.pasteFromClipboard", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonPasteFromClipBoard);
        this.buttonCopyToClipBoard = new GuiButtonExt(4, posX, this.buttonPasteFromClipBoard.field_146129_i + this.buttonPasteFromClipBoard.field_146121_g, 120, 20, I18n.func_135052_a((String)"mxtune.gui.button.copyToClipboard", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonCopyToClipBoard);
        int labelWidth = Math.max(this.field_146289_q.func_78256_a(lineNames[0]), this.field_146289_q.func_78256_a(lineNames[1])) + 4;
        posX = this.buttonCopyToClipBoard.field_146128_h + this.buttonCopyToClipBoard.field_146120_f + 4;
        posY = this.labelStatus.field_146210_g + this.labelStatus.field_146219_i + 4;
        rightSideWidth = Math.max(this.field_146294_l - posX - 4, 100);
        int textX = posX + labelWidth + 4;
        int linesRightSideWidth = rightSideWidth - labelWidth - 4;
        for (int i = 0; i < 10; ++i) {
            this.mmlLabelLines[i] = new GuiLabelMX(this.field_146289_q, i, posX, posY, labelWidth, this.entryHeight, 0xFFFFFF);
            this.mmlLabelLines[i].setLabelText(lineNames[i]);
            this.mmlTextLines[i] = new GuiTextField(i + 200, this.field_146289_q, textX, posY, linesRightSideWidth, this.field_146289_q.field_78288_b + 2);
            this.mmlTextLines[i].func_146195_b(false);
            this.mmlTextLines[i].func_146205_d(true);
            this.mmlTextLines[i].func_146203_f(12000);
            posY += this.entryHeight + 4;
        }
        this.setLinesLayout(this.cachedViewableLineCount);
        this.reloadState();
        this.parseTest(!this.firstParse);
    }

    private void setLinesLayout(int viewableLines) {
        int posX = this.buttonCopyToClipBoard.field_146128_h + this.buttonCopyToClipBoard.field_146120_f + 4;
        int rightSideWidth = Math.max(this.field_146294_l - posX - 4, 100);
        GuiTextField mmlTextField = this.mmlTextLines[viewableLines - 1];
    }

    private void reloadState() {
        if (!this.isStateCached) {
            return;
        }
        this.listBoxInstruments.setSelectedIndex(this.cachedSelectedInst);
        this.isPlaying = this.cachedIsPlaying;
        this.updateStatusText();
        IntStream.range(0, 10).forEach(i -> this.mmlTextLines[i].func_146180_a(this.cachedTextLines[i]));
        IntStream.range(0, 10).forEach(i -> this.mmlTextLines[i].func_146190_e(this.cachedCursorPos[i]));
        this.viewableLineCount = this.cachedViewableLineCount;
        this.updateButtonState();
        this.listBoxInstruments.resetScroll();
    }

    private void updateState() {
        IntStream.range(0, 10).forEach(i -> {
            this.cachedTextLines[i] = this.mmlTextLines[i].func_146179_b();
        });
        IntStream.range(0, 10).forEach(i -> {
            this.cachedCursorPos[i] = this.mmlTextLines[i].func_146198_h();
        });
        this.cachedViewableLineCount = this.viewableLineCount;
        this.cachedSelectedInst = this.listBoxInstruments.getSelectedIndex();
        this.cachedIsPlaying = this.isPlaying;
        this.updateStatusText();
        this.updateButtonState();
        this.isStateCached = true;
    }

    private void updateStatusText() {
        this.labelStatus.func_146180_a(I18n.func_135052_a((String)"mxtune.gui.guiMXT.textStatus", (Object[])new Object[]{String.format("%06d", this.totalCharacters), SheetMusicUtil.formatDuration(this.duration), this.mxTunePart != null ? this.mxTunePart.getMeta() : ""}));
    }

    private void updateButtonState() {
        this.buttonPlay.field_146124_l = this.isPlaying || this.duration > 4 || this.totalCharacters > 0;
        this.buttonPlay.field_146126_j = this.isPlaying ? I18n.func_135052_a((String)"mxtune.gui.button.stop", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.button.play_part", (Object[])new Object[0]);
        this.buttonAddLine.field_146124_l = this.viewableLineCount < 10;
        this.buttonMinusLine.field_146124_l = this.viewableLineCount > 1;
        this.parseTest(false);
        this.setLinesLayout(this.viewableLineCount);
    }

    boolean canPlay() {
        return this.buttonPlay.field_146124_l;
    }

    public void func_146281_b() {
        this.stop();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int posX = this.listBoxInstruments.getRight() + 4;
        int posY = this.top + 2;
        this.field_146289_q.func_175063_a(LABEL_STATUS, (float)posX, (float)posY, 0xD3D3D3);
        posX = 5;
        this.field_146289_q.func_175063_a(LABEL_INSTRUMENTS, (float)posX, (float)posY, 0xD3D3D3);
        this.listBoxInstruments.drawScreen(mouseX, mouseY, partialTicks);
        this.labelStatus.func_146194_f();
        IntStream.range(0, this.viewableLineCount).forEach(i -> {
            this.mmlLabelLines[i].drawLabel(this.field_146297_k, mouseX, mouseY);
            this.mmlTextLines[i].func_146194_f();
        });
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        switch (guibutton.field_146127_k) {
            case 0: {
                this.play();
                break;
            }
            case 1: {
                this.addLine();
                this.parseTest(true);
                break;
            }
            case 2: {
                this.minusLine();
                this.parseTest(true);
                break;
            }
            case 3: {
                this.pasteFromClipboard();
                this.parseTest(true);
                break;
            }
            case 4: {
                this.copyToClipboard();
                break;
            }
        }
        this.updateState();
    }

    private void addLine() {
        this.viewableLineCount = this.viewableLineCount + 1 > 10 ? this.viewableLineCount : this.viewableLineCount + 1;
    }

    private void minusLine() {
        this.viewableLineCount = this.viewableLineCount - 1 >= 1 ? this.viewableLineCount - 1 : this.viewableLineCount;
    }

    private void pasteFromClipboard() {
        this.clearPart();
        int i = 0;
        ModLogger.debug("%s", GuiScreen.func_146277_j());
        String clip = GuiScreen.func_146277_j();
        if (clip.isEmpty()) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(clip.replaceAll("MML@|;", "").split(",")));
        Iterator iterator = lines.iterator();
        while (iterator.hasNext() && this.viewableLineCount < 10) {
            this.mmlTextLines[i].func_146180_a((String)iterator.next());
            this.mmlTextLines[i++].func_146196_d();
            if (!iterator.hasNext()) continue;
            this.addLine();
        }
    }

    private void copyToClipboard() {
        String mml = this.getMMLClipBoardFormat();
        GuiScreen.func_146275_d((String)(mml.isEmpty() ? "MML@;" : mml));
    }

    public String getMMLClipBoardFormat() {
        StringBuilder lines = new StringBuilder();
        for (int i = 0; i < this.viewableLineCount; ++i) {
            lines.append(this.mmlTextLines[i].func_146179_b().replaceAll(",", ""));
            if (i >= this.viewableLineCount - 1) continue;
            lines.append(",");
        }
        return this.getTextToParse(lines.toString());
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            return;
        }
        IntStream.range(0, this.viewableLineCount).forEach(i -> this.mmlTextLines[i].func_146201_a(typedChar, keyCode));
        this.parseTest(false);
        this.listBoxInstruments.keyTyped(typedChar, keyCode);
        this.updateState();
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int partialTicks) throws IOException {
        for (int i = 0; i < this.viewableLineCount; ++i) {
            this.mmlTextLines[i].func_146192_a(mouseX, mouseY, partialTicks);
        }
        super.func_73864_a(mouseX, mouseY, partialTicks);
        this.updateState();
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        this.listBoxInstruments.handleMouseInput(mouseX, mouseY);
        this.updateState();
    }

    private void parseMML(int index, String mml) {
        ValidDuration validDuration = SheetMusicUtil.validateMML(this.getTextToParse(mml));
        if (validDuration.getDuration() > this.duration) {
            this.duration = validDuration.getDuration();
        }
    }

    private void parseTest(boolean force) {
        this.firstParse = true;
        int count = 0;
        for (int i2 = 0; i2 < this.viewableLineCount; ++i2) {
            count += this.mmlTextLines[i2].func_146179_b().length();
        }
        if (this.totalCharacters != count || force) {
            this.duration = 0;
            this.totalCharacters = count;
            IntStream.range(0, this.viewableLineCount).forEach(i -> this.parseMML(i, this.mmlTextLines[i].func_146179_b()));
        }
    }

    private void selectInstrument() {
        int index = Math.max(this.listBoxInstruments.getSelectedIndex(), 0);
        this.mxTunePart.setPackedPatch(this.listBoxInstruments.get((int)index).packed_preset);
        this.mxTunePart.setInstrumentName(this.listBoxInstruments.get((int)index).id);
    }

    private boolean mmlPlay(String mmlIn) {
        String mml = mmlIn;
        SoundFontProxy soundFontProxy = this.listBoxInstruments.get();
        if (soundFontProxy == null) {
            return false;
        }
        int soundFontProxyIndex = soundFontProxy.index;
        mml = mml.replace("MML@", "MML@i" + soundFontProxyIndex);
        ModLogger.debug("GuiMusicPaperParse.mmlPlay() name: %s, packed %08d", soundFontProxy.id, soundFontProxy.packed_preset);
        ModLogger.debug("GuiMusicPaperParse.mmlPlay(): %s", mml.substring(0, Math.min(mml.length(), 25)));
        this.playId = PlayIdSupplier.PlayType.PERSONAL.getAsInt();
        ClientAudio.playLocal(this.playId, mml, this);
        return true;
    }

    private void play() {
        if (this.isPlaying) {
            this.stop();
        } else {
            if (this.listBoxInstruments.getSelectedIndex() < 0) {
                this.listBoxInstruments.setSelectedIndex(0);
            }
            StringBuilder lines = new StringBuilder();
            for (int i = 0; i < this.viewableLineCount; ++i) {
                lines.append(this.mmlTextLines[i].func_146179_b().replaceAll(",", ""));
                if (i >= this.viewableLineCount - 1) continue;
                lines.append(",");
            }
            String mml = this.getTextToParse(lines.toString());
            this.isPlaying = this.mmlPlay(mml);
        }
    }

    private String getTextToParse(String text) {
        String copy = text;
        copy = copy.replaceAll("(MML\\@)|;", "");
        StringBuilder sb = new StringBuilder(copy);
        if (!copy.regionMatches(true, 0, "MML@", 0, 4) && copy.length() > 0) {
            sb.insert(0, "MML@");
        }
        if (!copy.endsWith(";") && copy.length() > 0) {
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public void statusCallBack(ClientAudio.Status status, int playId) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (this.playId == playId && (status == ClientAudio.Status.ERROR || status == ClientAudio.Status.DONE)) {
                ModLogger.debug("AudioStatus event received: %s, playId: %s", new Object[]{status, playId});
                this.stop();
            }
        });
    }

    private void stop() {
        ClientAudio.queueAudioDataRemoval(this.playId);
        this.isPlaying = false;
        this.playId = -1;
        this.updateState();
    }
}

