/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.gui.mml.ActionGet;
import net.aeronica.mods.mxtune.gui.mml.GuiFileSelector;
import net.aeronica.mods.mxtune.gui.mml.GuiMXTPartTab;
import net.aeronica.mods.mxtune.gui.mml.GuiMusicLibrary;
import net.aeronica.mods.mxtune.gui.util.GuiLabelMX;
import net.aeronica.mods.mxtune.gui.util.GuiLink;
import net.aeronica.mods.mxtune.gui.util.IHooverText;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.aeronica.mods.mxtune.managers.PlayIdSupplier;
import net.aeronica.mods.mxtune.managers.records.RecordType;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.mxt.MXTuneFileHelper;
import net.aeronica.mods.mxtune.mxt.MXTunePart;
import net.aeronica.mods.mxtune.mxt.MXTuneStaff;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.bidirectional.SetServerSerializedDataMessage;
import net.aeronica.mods.mxtune.network.server.MusicTextMessage;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.sound.IAudioStatusCallback;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import net.aeronica.mods.mxtune.util.ValidDuration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;

public class GuiMXT
extends GuiScreen
implements IAudioStatusCallback {
    private final List<IHooverText> hooverTexts = new ArrayList<IHooverText>();
    private final GuiScreen guiScreenParent;
    private boolean isStateCached;
    private GuiLabelMX labelMXTFileName;
    private String cachedMXTFilename;
    private GuiLabelMX labelTitle;
    private GuiLabelMX labelAuthor;
    private GuiLabelMX labelSource;
    private GuiLabelMX labelDuration;
    private GuiTextField textTitle;
    private String cachedTitle = "";
    private GuiTextField textAuthor;
    private String cachedAuthor = "";
    private GuiTextField textSource;
    private String cachedSource = "";
    private GuiButtonExt buttonPlayStop;
    private GuiButtonExt buttonDoneMode;
    private int durationTotal;
    private int ticks;
    private GuiLink sourcesLink;
    private GuiLink mmlLink;
    private MXTuneFile mxTuneFile;
    private boolean isPlaying = false;
    private boolean cachedIsPlaying;
    private GuiButtonExt buttonSave;
    private static final int PADDING = 4;
    private final Mode mode;
    private int playId = -1;
    private static final int MAX_TABS = 10;
    private static final int MIN_TABS = 1;
    private static final int TAB_BTN_IDX = 200;
    private final GuiMXTPartTab[] childTabs = new GuiMXTPartTab[10];
    private int activeChildIndex;
    private int cachedActiveChildIndex;
    private GuiButtonExt buttonAddTab;
    private GuiButtonExt buttonMinusTab;
    private final GuiButtonExt[] buttonNames = new GuiButtonExt[10];
    private int viewableTabCount = 1;
    private int cachedViewableTabCount;

    public GuiMXT(GuiScreen guiScreenParent, Mode mode) {
        this.guiScreenParent = guiScreenParent;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.mode = mode;
        for (int i = 0; i < 10; ++i) {
            this.childTabs[i] = new GuiMXTPartTab(this);
        }
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73866_w_() {
        this.hooverTexts.clear();
        int singleLineHeight = this.field_146297_k.field_71466_p.field_78288_b + 2;
        int titleWidth = this.field_146294_l - 8;
        this.labelMXTFileName = new GuiLabelMX(this.field_146289_q, 0, 4, 4, titleWidth, singleLineHeight, -1);
        this.setDisplayedFilename(this.cachedMXTFilename, TextFormatting.AQUA);
        int buttonWidth = Math.max((this.field_146294_l * 2 / 3 - 8) / 6, 65);
        int buttonY = this.labelMXTFileName.getY() + this.labelMXTFileName.getHeight();
        GuiButtonExt buttonNew = new GuiButtonExt(0, 4, buttonY, buttonWidth, 20, I18n.func_135052_a((String)"mxtune.gui.button.new", (Object[])new Object[0]));
        GuiButtonExt buttonImport = new GuiButtonExt(1, buttonNew.field_146128_h + buttonNew.field_146120_f, buttonY, buttonWidth, 20, I18n.func_135052_a((String)"mxtune.gui.button.import", (Object[])new Object[0]));
        GuiButtonExt buttonOpen = new GuiButtonExt(2, buttonImport.field_146128_h + buttonImport.field_146120_f, buttonY, buttonWidth, 20, I18n.func_135052_a((String)"mxtune.gui.button.open", (Object[])new Object[0]));
        this.buttonSave = new GuiButtonExt(3, buttonOpen.field_146128_h + buttonOpen.field_146120_f, buttonY, buttonWidth, 20, I18n.func_135052_a((String)"mxtune.gui.button.save", (Object[])new Object[0]));
        this.buttonDoneMode = new GuiButtonExt(4, this.buttonSave.field_146128_h + this.buttonSave.field_146120_f, buttonY, buttonWidth, 20, this.getDoneButtonNameByMode());
        GuiButtonExt buttonCancel = new GuiButtonExt(5, this.buttonDoneMode.field_146128_h + this.buttonDoneMode.field_146120_f, buttonY, buttonWidth, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        if (this.mode == Mode.CLIENT) {
            buttonCancel.field_146125_m = false;
        }
        this.field_146292_n.add(buttonNew);
        this.field_146292_n.add(buttonImport);
        this.field_146292_n.add(buttonOpen);
        this.field_146292_n.add(this.buttonSave);
        this.field_146292_n.add(this.buttonDoneMode);
        this.field_146292_n.add(buttonCancel);
        int textY = this.buttonDoneMode.field_146129_i + this.buttonDoneMode.field_146121_g + 4;
        int urlWidth = this.field_146294_l / 2 - 4;
        this.sourcesLink = new GuiLink(10, 4, textY, this.cachedSource, GuiLink.AlignText.LEFT);
        this.sourcesLink.field_146120_f = urlWidth;
        this.sourcesLink.field_146121_g = singleLineHeight;
        this.mmlLink = new GuiLink(11, this.field_146294_l - 4, textY, ModConfig.getMmlLink(), GuiLink.AlignText.RIGHT);
        this.mmlLink.field_146120_f = urlWidth;
        this.mmlLink.field_146121_g = singleLineHeight;
        this.field_146292_n.add(this.sourcesLink);
        this.field_146292_n.add(this.mmlLink);
        textY = this.sourcesLink.field_146129_i + this.sourcesLink.field_146121_g + 4;
        String labelTitleText = I18n.func_135052_a((String)"mxtune.gui.label.title", (Object[])new Object[0]);
        int labelTitleWidth = this.field_146289_q.func_78256_a(labelTitleText);
        String labelAuthorText = I18n.func_135052_a((String)"mxtune.gui.label.author", (Object[])new Object[0]);
        int labelAuthorWidth = this.field_146289_q.func_78256_a(labelAuthorText);
        this.labelTitle = new GuiLabelMX(this.field_146289_q, 1, 4, textY, labelTitleWidth, this.field_146289_q.field_78288_b + 2, -1);
        this.labelTitle.setLabelName(labelTitleText);
        this.textTitle = new GuiTextField(1, this.field_146289_q, this.labelTitle.getX() + labelTitleWidth + 4, textY, this.field_146294_l / 2 - this.labelTitle.getWidth() - 4, this.field_146289_q.field_78288_b + 2);
        this.textTitle.func_146203_f(80);
        this.textTitle.func_146205_d(true);
        this.labelAuthor = new GuiLabelMX(this.field_146289_q, 2, this.textTitle.field_146209_f + this.textTitle.field_146218_h + 4, textY, labelAuthorWidth, this.field_146289_q.field_78288_b + 2, -1);
        this.labelAuthor.setLabelName(labelAuthorText);
        this.textAuthor = new GuiTextField(2, this.field_146289_q, this.labelAuthor.getX() + labelAuthorWidth + 4, textY, this.field_146294_l - this.labelAuthor.getX() - this.labelAuthor.getWidth() - 8, this.field_146289_q.field_78288_b + 2);
        this.textAuthor.func_146203_f(80);
        this.textAuthor.func_146205_d(true);
        textY = this.textTitle.field_146210_g + this.textTitle.field_146219_i + 4;
        String labelSourceText = I18n.func_135052_a((String)"mxtune.gui.label.source", (Object[])new Object[0]);
        int labelSourceWidth = this.field_146289_q.func_78256_a(labelSourceText);
        this.labelSource = new GuiLabelMX(this.field_146289_q, 3, 4, textY, labelSourceWidth, this.field_146289_q.field_78288_b + 2, -1);
        this.labelSource.setLabelName(labelSourceText);
        this.textSource = new GuiTextField(3, this.field_146289_q, this.labelSource.getX() + this.labelSource.getWidth() + 4, textY, this.field_146294_l - this.labelSource.getX() - this.labelSource.getWidth() - 8, this.field_146289_q.field_78288_b + 2);
        this.textSource.func_146203_f(320);
        this.textSource.func_146205_d(true);
        int tabButtonTop = this.textSource.field_146210_g + this.textSource.field_146219_i + 8;
        this.buttonAddTab = new GuiButtonExt(250, 4, tabButtonTop, 40, 20, I18n.func_135052_a((String)"mxtune.gui.button.plus", (Object[])new Object[0]));
        this.buttonMinusTab = new GuiButtonExt(251, this.buttonAddTab.field_146128_h + this.buttonAddTab.field_146120_f, tabButtonTop, 40, 20, I18n.func_135052_a((String)"mxtune.gui.button.minus", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonAddTab);
        this.field_146292_n.add(this.buttonMinusTab);
        String durationLabelName = I18n.func_135052_a((String)"mxtune.gui.label.total_duration", (Object[])new Object[0]);
        int durationWidth = this.field_146289_q.func_78256_a(durationLabelName);
        durationWidth += this.field_146289_q.func_78256_a(SheetMusicUtil.formatDuration(0));
        this.labelDuration = new GuiLabelMX(this.field_146289_q, 5, this.field_146294_l - (durationWidth += this.field_146289_q.func_78256_a(" ")) - 4, tabButtonTop + 20 + 4 + 2, durationWidth, singleLineHeight, -1);
        this.labelDuration.setLabelName(I18n.func_135052_a((String)durationLabelName, (Object[])new Object[0]));
        this.labelDuration.setLabelText(SheetMusicUtil.formatDuration(this.durationTotal));
        int tabbedAreaTop = tabButtonTop + 20 + 4;
        for (int i = 0; i < 10; ++i) {
            this.buttonNames[i] = new GuiButtonExt(200 + i, this.buttonMinusTab.field_146128_h + this.buttonMinusTab.field_146120_f + 4 + 20 * i, tabButtonTop, 20, 20, String.format("%d", i + 1));
            this.field_146292_n.add(this.buttonNames[i]);
            this.childTabs[i].setLayout(tabbedAreaTop, this.field_146295_m - 4);
            this.childTabs[i].func_73866_w_();
        }
        this.buttonPlayStop = new GuiButtonExt(6, this.field_146294_l - 4 - 100, tabbedAreaTop - 24, 100, 20, this.isPlaying ? I18n.func_135052_a((String)"mxtune.gui.button.stop", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.button.play_all", (Object[])new Object[0]));
        this.buttonPlayStop.field_146124_l = false;
        this.field_146292_n.add(this.buttonPlayStop);
        this.reloadState();
        this.getSelection();
    }

    private void reloadState() {
        this.updateButtons();
        if (!this.isStateCached) {
            return;
        }
        this.labelMXTFileName.setLabelText(this.cachedMXTFilename);
        this.activeChildIndex = this.cachedActiveChildIndex;
        this.viewableTabCount = this.cachedViewableTabCount;
        this.textTitle.func_146180_a(this.cachedTitle);
        this.textAuthor.func_146180_a(this.cachedAuthor);
        this.textSource.func_146180_a(this.cachedSource);
        this.isPlaying = this.cachedIsPlaying;
    }

    private void updateState() {
        this.cachedMXTFilename = this.labelMXTFileName.getLabelText();
        this.cachedActiveChildIndex = this.activeChildIndex;
        this.cachedViewableTabCount = this.viewableTabCount;
        this.cachedTitle = this.textTitle.func_146179_b();
        this.cachedAuthor = this.textAuthor.func_146179_b();
        this.cachedSource = this.textSource.func_146179_b();
        this.cachedIsPlaying = this.isPlaying;
        this.sourcesLink.field_146126_j = this.cachedSource;
        this.isStateCached = true;
    }

    private void updateButtons() {
        for (GuiButton button : this.field_146292_n) {
            if (button.field_146127_k < 200 || button.field_146127_k >= 210) continue;
            button.field_146124_l = this.activeChildIndex + 200 != button.field_146127_k;
            boolean bl = button.field_146125_m = button.field_146127_k < this.viewableTabCount + 200;
            if (this.activeChildIndex < this.viewableTabCount) continue;
            this.activeChildIndex = this.viewableTabCount - 1;
        }
        this.buttonAddTab.field_146124_l = this.viewableTabCount < 10;
        this.buttonMinusTab.field_146124_l = this.viewableTabCount > 1;
        int countOK = 0;
        int duration = 0;
        for (int i = 0; i < this.viewableTabCount; ++i) {
            countOK = this.childTabs[i].canPlay() ? countOK + 1 : countOK;
            int partDuration = this.childTabs[i].getDuration();
            duration = partDuration > duration ? partDuration : duration;
        }
        this.durationTotal = duration;
        this.labelDuration.setLabelText(SheetMusicUtil.formatDuration(this.durationTotal));
        boolean isOK = countOK == this.viewableTabCount;
        this.buttonPlayStop.field_146124_l = this.isPlaying || isOK;
        this.buttonDoneMode.field_146124_l = Mode.CLIENT == this.mode || !this.textTitle.func_146179_b().isEmpty() && isOK;
        this.buttonPlayStop.field_146126_j = this.isPlaying ? I18n.func_135052_a((String)"mxtune.gui.button.stop", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.button.play_all", (Object[])new Object[0]);
        this.buttonSave.field_146124_l = !this.textTitle.func_146179_b().isEmpty() && isOK;
        this.sourcesLink.field_146125_m = this.sourcesLink.field_146126_j.matches("^(http(s)?:\\/\\/[a-zA-Z0-9\\-_]+\\.[a-zA-Z]+(.)+)+");
    }

    private void updateTabbedButtonNames() {
        int prevWidth = this.buttonMinusTab.field_146128_h + this.buttonMinusTab.field_146120_f;
        int staticButtonWidth = this.buttonMinusTab.field_146120_f + this.buttonAddTab.field_146120_f + this.buttonPlayStop.field_146120_f + 12;
        for (int i = 0; i < this.viewableTabCount; ++i) {
            int limitedWidth;
            GuiButtonExt gb = this.buttonNames[i];
            String name = this.getButtonName(i);
            int nameWidth = this.field_146289_q.func_78256_a(name) + 16;
            gb.field_146128_h = prevWidth + 4;
            gb.field_146126_j = name;
            gb.field_146120_f = limitedWidth = Math.min((this.field_146294_l - staticButtonWidth) / this.viewableTabCount, Math.max(20, nameWidth));
            prevWidth += limitedWidth;
        }
    }

    private String getButtonName(int index) {
        String number = String.format("%d", index + 1);
        MXTunePart part = this.childTabs[index].getPart();
        String localizedInstrumentName = ModGuiUtils.getLocalizedInstrumentName(this.childTabs[index].getPart().getInstrumentName());
        return part != null && !part.getInstrumentName().equals("") ? number + ": " + localizedInstrumentName : number;
    }

    private void drawMarkers() {
        for (int i = 0; i < this.viewableTabCount; ++i) {
            GuiButtonExt gb = this.buttonNames[i];
            if (!gb.field_146124_l) {
                this.drawBox(gb, -1);
            }
            if (this.childTabs[i].canPlay()) continue;
            this.drawLine(gb, -56798);
        }
    }

    private void drawBox(GuiButtonExt gb, int color) {
        this.func_73730_a(gb.field_146128_h, gb.field_146128_h + gb.field_146120_f - 1, gb.field_146129_i, color);
        this.func_73730_a(gb.field_146128_h, gb.field_146128_h + gb.field_146120_f - 1, gb.field_146129_i + gb.field_146121_g - 1, color);
        this.func_73728_b(gb.field_146128_h, gb.field_146129_i, gb.field_146129_i + gb.field_146121_g - 1, color);
        this.func_73728_b(gb.field_146128_h + gb.field_146120_f - 1, gb.field_146129_i, gb.field_146129_i + gb.field_146121_g - 1, color);
    }

    private void drawLine(GuiButtonExt gb, int color) {
        GuiMXT.func_73734_a((int)(gb.field_146128_h + 1), (int)(gb.field_146129_i + gb.field_146121_g + 1), (int)(gb.field_146128_h + 1 + gb.field_146120_f - 2), (int)(gb.field_146129_i + gb.field_146121_g + 3), (int)color);
    }

    public void func_73876_c() {
        this.textTitle.func_146178_a();
        this.textAuthor.func_146178_a();
        this.textSource.func_146178_a();
        this.childTabs[this.activeChildIndex].func_73876_c();
        if (this.ticks++ % 5 == 0) {
            this.updateButtons();
        }
    }

    private String getDoneButtonNameByMode() {
        switch (this.mode) {
            case CLIENT: {
                return I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]);
            }
            case SERVER: {
                return I18n.func_135052_a((String)"mxtune.gui.button.upload", (Object[])new Object[0]);
            }
            case SHEET_MUSIC: {
                return I18n.func_135052_a((String)"mxtune.gui.button.create", (Object[])new Object[0]);
            }
        }
        return I18n.func_135052_a((String)"gui.none", (Object[])new Object[0]);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k >= 200 && button.field_146127_k < 210) {
            this.activeChildIndex = button.field_146127_k - 200;
            this.childTabs[this.activeChildIndex].func_175273_b(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
        switch (button.field_146127_k) {
            case 0: {
                this.newAction();
                break;
            }
            case 1: {
                this.importAction();
                break;
            }
            case 2: {
                this.openAction();
                break;
            }
            case 3: {
                this.saveAction();
                break;
            }
            case 4: {
                this.doneAction();
                break;
            }
            case 5: {
                this.cancelAction();
                break;
            }
            case 6: {
                this.play();
                break;
            }
            case 10: {
                this.func_175276_a(this.sourcesLink.getLinkComponent());
                break;
            }
            case 11: {
                this.func_175276_a(this.mmlLink.getLinkComponent());
                break;
            }
            case 250: {
                this.addTab();
                break;
            }
            case 251: {
                this.minusTab();
                break;
            }
        }
        this.updateButtons();
        this.updateState();
    }

    private void addTab() {
        this.viewableTabCount = this.viewableTabCount + 1 > 10 ? this.viewableTabCount : this.viewableTabCount + 1;
        this.activeChildIndex = this.viewableTabCount - 1;
    }

    private void minusTab() {
        this.viewableTabCount = this.viewableTabCount - 1 >= 1 ? this.viewableTabCount - 1 : this.viewableTabCount;
    }

    private void firstTab() {
        this.activeChildIndex = 0;
        this.childTabs[this.activeChildIndex].func_73876_c();
        this.updateState();
    }

    private void newAction() {
        this.stop();
        this.updateState();
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, "New File! This will clear all fields and parts!", "Confirm?", 0));
    }

    private void importAction() {
        this.stop();
        ActionGet.INSTANCE.clear();
        ActionGet.INSTANCE.setFileImport();
        this.viewableTabCount = 1;
        this.field_146297_k.func_147108_a((GuiScreen)new GuiFileSelector(this));
    }

    private void openAction() {
        this.stop();
        ActionGet.INSTANCE.clear();
        ActionGet.INSTANCE.setFileOpen();
        this.viewableTabCount = 1;
        this.field_146297_k.func_147108_a((GuiScreen)new GuiMusicLibrary(this));
    }

    private void saveAction() {
        String fileName = FileHelper.removeExtension(this.labelMXTFileName.getLabelText());
        if (fileName.length() < 1) {
            fileName = FileHelper.normalizeFilename(this.textTitle.func_146179_b().trim());
            this.labelMXTFileName.setLabelText(fileName);
        }
        if (!fileName.equals("") && !this.textTitle.func_146179_b().trim().equals("")) {
            this.createMxt();
            NBTTagCompound compound = new NBTTagCompound();
            this.mxTuneFile.writeToNBT(compound);
            try {
                FileHelper.sendCompoundToFile(FileHelper.getCacheFile("mxtune/library", fileName + ".mxt", Side.CLIENT), compound);
            }
            catch (IOException e) {
                ModLogger.error(e);
            }
        }
        this.updateState();
    }

    private boolean uploadMxt() {
        if (!this.textTitle.func_146179_b().trim().equals("") && this.buttonPlayStop.field_146124_l) {
            this.createMxt();
            PacketDispatcher.sendToServer(new SetServerSerializedDataMessage(this.mxTuneFile.getGUID(), RecordType.MXT, this.mxTuneFile));
            return true;
        }
        Miscellus.audiblePingPlayer((EntityPlayer)this.field_146297_k.field_71439_g, SoundEvents.field_187692_g);
        return false;
    }

    private void createMxt() {
        if (this.mxTuneFile == null) {
            this.mxTuneFile = new MXTuneFile();
        }
        ValidDuration validDuration = SheetMusicUtil.validateMML(this.getMML());
        this.mxTuneFile.setDuration(validDuration.getDuration());
        this.mxTuneFile.setTitle(this.textTitle.func_146179_b().trim());
        this.mxTuneFile.setAuthor(this.textAuthor.func_146179_b().trim());
        this.mxTuneFile.setSource(this.textSource.func_146179_b().trim());
        ArrayList<MXTunePart> parts = new ArrayList<MXTunePart>();
        for (int i = 0; i < this.viewableTabCount; ++i) {
            this.childTabs[i].updatePart();
            MXTunePart part = this.childTabs[i].getPart();
            if (part.getStaves().isEmpty()) continue;
            parts.add(part);
        }
        this.mxTuneFile.setParts(parts);
    }

    private boolean makeSheetMusic() {
        if (!this.textTitle.func_146179_b().trim().equals("") && this.buttonPlayStop.field_146124_l) {
            String title = this.textTitle.func_146179_b();
            for (int i = 0; i < this.viewableTabCount; ++i) {
                this.childTabs[i].updatePart();
                String instrumentName = I18n.func_135052_a((String)("item.mxtune:multi_inst." + this.childTabs[i].getPart().getInstrumentName() + ".name"), (Object[])new Object[0]);
                String titleAndInstrument = this.formatTitle(title, i, this.viewableTabCount, instrumentName);
                String mml = this.childTabs[i].getMMLClipBoardFormat();
                PacketDispatcher.sendToServer(new MusicTextMessage(titleAndInstrument, mml));
            }
            return true;
        }
        Miscellus.audiblePingPlayer((EntityPlayer)this.field_146297_k.field_71439_g, SoundEvents.field_187692_g);
        return false;
    }

    private void doneAction() {
        this.stop();
        this.updateState();
        switch (this.mode) {
            case CLIENT: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, "Have you saved changes?", "Do you still want to exit?", 4));
                break;
            }
            case SERVER: {
                if (!this.uploadMxt()) break;
                this.field_146297_k.func_147108_a(this.guiScreenParent);
                break;
            }
            case SHEET_MUSIC: {
                if (!this.makeSheetMusic()) break;
                this.field_146297_k.func_147108_a(this.guiScreenParent);
                break;
            }
        }
    }

    private void cancelAction() {
        this.stop();
        this.field_146297_k.func_147108_a(this.guiScreenParent);
    }

    private void getSelection() {
        switch (ActionGet.INSTANCE.getSelector()) {
            case DONE: {
                break;
            }
            case FILE_NEW: {
                this.fileNew();
                break;
            }
            case FILE_IMPORT: {
                this.fileImport();
                break;
            }
            case FILE_OPEN: {
                this.fileOpen();
                break;
            }
            case FILE_SAVE: {
                break;
            }
        }
        ActionGet.INSTANCE.setCancel();
    }

    private void fileNew() {
        this.mxTuneFile = null;
        this.setDisplayedFilename("", TextFormatting.AQUA);
        this.textTitle.func_146180_a("");
        this.textAuthor.func_146180_a("");
        this.textSource.func_146180_a("");
        IntStream.range(0, 10).forEach(i -> this.childTabs[i].clearPart());
        this.viewableTabCount = 1;
        this.firstTab();
    }

    private void fileImport() {
        this.mxTuneFile = ActionGet.INSTANCE.getMxTuneFile();
        this.getMXTFileData();
        this.firstTab();
    }

    private void fileOpen() {
        this.mxTuneFile = MXTuneFileHelper.getMXTuneFile(ActionGet.INSTANCE.getPath());
        this.getMXTFileData();
        this.firstTab();
    }

    private void getMXTFileData() {
        if (this.mxTuneFile != null) {
            IntStream.range(0, 10).forEach(i -> this.childTabs[i].clearPart());
            this.viewableTabCount = 1;
            this.activeChildIndex = 0;
            this.textTitle.func_146180_a(this.mxTuneFile.getTitle());
            this.textAuthor.func_146180_a(this.mxTuneFile.getAuthor());
            this.textSource.func_146180_a(this.mxTuneFile.getSource());
            int tab = 0;
            this.setDisplayedFilename(ActionGet.INSTANCE.getFileNameString(), TextFormatting.AQUA);
            Iterator<MXTunePart> iterator = this.mxTuneFile.getParts().iterator();
            while (iterator.hasNext() && tab < 10) {
                this.childTabs[tab++].setPart(iterator.next());
                if (!iterator.hasNext()) continue;
                this.addTab();
            }
        } else {
            Miscellus.audiblePingPlayer((EntityPlayer)this.field_146297_k.field_71439_g, SoundEvents.field_187561_bM);
        }
    }

    public void func_73878_a(boolean result, int id) {
        switch (id) {
            case 0: {
                if (result) {
                    this.fileNew();
                }
                this.field_146297_k.func_147108_a((GuiScreen)this);
                break;
            }
            case 4: {
                if (result) {
                    this.field_146297_k.func_147108_a(this.guiScreenParent);
                    break;
                }
                this.field_146297_k.func_147108_a((GuiScreen)this);
                break;
            }
        }
        super.func_73878_a(result, id);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            return;
        }
        this.childTabs[this.activeChildIndex].func_73869_a(typedChar, keyCode);
        this.textTitle.func_146201_a(typedChar, keyCode);
        this.textAuthor.func_146201_a(typedChar, keyCode);
        this.textSource.func_146201_a(typedChar, keyCode);
        this.updateState();
        super.func_73869_a(typedChar, keyCode);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.updateTabbedButtonNames();
        this.labelMXTFileName.drawLabel(this.field_146297_k, mouseX, mouseY);
        this.labelTitle.drawLabel(this.field_146297_k, mouseX, mouseY);
        this.textTitle.func_146194_f();
        this.labelAuthor.drawLabel(this.field_146297_k, mouseX, mouseY);
        this.textAuthor.func_146194_f();
        this.labelSource.drawLabel(this.field_146297_k, mouseX, mouseY);
        this.textSource.func_146194_f();
        this.labelDuration.drawLabel(this.field_146297_k, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawMarkers();
        this.childTabs[this.activeChildIndex].func_73863_a(mouseX, mouseY, partialTicks);
        ModGuiUtils.INSTANCE.drawHooveringHelp(this, this.hooverTexts, 0, 0, mouseX, mouseY);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.updateState();
        this.childTabs[this.activeChildIndex].func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.textTitle.func_146192_a(mouseX, mouseY, mouseButton);
        this.textAuthor.func_146192_a(mouseX, mouseY, mouseButton);
        this.textSource.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_175273_b(@Nonnull Minecraft mcIn, int w, int h) {
        super.func_175273_b(mcIn, w, h);
        this.childTabs[this.activeChildIndex].func_175273_b(mcIn, w, h);
    }

    private void setDisplayedFilename(@Nullable String name, TextFormatting textFormatting) {
        if (name == null) {
            name = "";
        }
        this.labelMXTFileName.setLabelName(I18n.func_135052_a((String)"mxtune.gui.guiMXT.displayedFilename", (Object[])new Object[0]));
        this.labelMXTFileName.setLabelText(name);
        this.labelMXTFileName.setTextFormatting(textFormatting);
    }

    private boolean mmlPlay(String mmlIn) {
        this.playId = PlayIdSupplier.PlayType.PERSONAL.getAsInt();
        ClientAudio.playLocal(this.playId, mmlIn, this);
        return true;
    }

    private void play() {
        if (this.isPlaying) {
            this.stop();
        } else {
            this.isPlaying = this.mmlPlay(this.getMML());
        }
    }

    public String getMML() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.viewableTabCount; ++i) {
            this.childTabs[i].updatePart();
            MXTunePart part = this.childTabs[i].getPart();
            builder.append("MML@I=").append(SoundFontProxyManager.getIndexById(part.getInstrumentName()));
            Iterator<MXTuneStaff> iterator = part.getStaves().iterator();
            while (iterator.hasNext()) {
                builder.append(iterator.next().getMml());
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append(";");
        }
        return builder.toString();
    }

    @Override
    public void statusCallBack(ClientAudio.Status status, int playId) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (this.playId == playId && (status == ClientAudio.Status.ERROR || status == ClientAudio.Status.DONE)) {
                ModLogger.debug("AudioStatus event received: %s, playId: %s", new Object[]{status, playId});
                this.stop();
            }
        });
    }

    private void stop() {
        ClientAudio.fadeOut(this.playId, 1);
        this.isPlaying = false;
        this.playId = -1;
        Arrays.stream(this.childTabs).forEach(GuiMXTPartTab::func_146281_b);
        this.updateState();
    }

    private String formatTitle(String title, int part, int parts, String instrumentName) {
        if (parts == 1) {
            return String.format("%s (%s)", title, instrumentName);
        }
        return String.format("%s (%d-%d : %s)", title, part + 1, parts, instrumentName);
    }

    public static enum Mode {
        CLIENT,
        SERVER,
        SHEET_MUSIC;

    }
}

