/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.gui.util.GuiButtonMX;
import net.aeronica.mods.mxtune.gui.util.GuiScrollingListOf;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.server.SetMultiInstMessage;
import net.aeronica.mods.mxtune.util.SoundFontProxy;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiGuiMultiInstChooser
extends GuiScreen {
    private static final ResourceLocation guiTexture = new ResourceLocation("mxtune", "textures/gui/multi_inst_chooser.png");
    private final int xSize = 256;
    private final int ySize = 164;
    private int guiLeft;
    private int guiTop;
    private final GuiScreen guiScreenOld;
    private final GuiScrollingListOf<SoundFontProxy> guiInstruments;

    public GuiGuiMultiInstChooser(@Nullable GuiScreen guiScreenIn) {
        this.guiScreenOld = guiScreenIn;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.guiInstruments = new GuiScrollingListOf<SoundFontProxy>((GuiScreen)this){

            @Override
            protected void selectedClickedCallback(int selectedIndex) {
                SoundFontProxy soundFontProxy = (SoundFontProxy)this.get();
                if (soundFontProxy != null) {
                    PacketDispatcher.sendToServer(new SetMultiInstMessage(soundFontProxy.index));
                }
            }

            @Override
            protected void selectedDoubleClickedCallback(int selectedIndex) {
                SoundFontProxy soundFontProxy = (SoundFontProxy)this.get();
                if (soundFontProxy != null) {
                    PacketDispatcher.sendToServer(new SetMultiInstMessage(soundFontProxy.index));
                }
                this.mc.func_147108_a(null);
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                SoundFontProxy soundFontProxy;
                SoundFontProxy soundFontProxy2 = soundFontProxy = !this.isEmpty() && slotIdx < this.getSize() && slotIdx >= 0 ? (SoundFontProxy)this.get(slotIdx) : null;
                if (soundFontProxy != null) {
                    String playlistName = ModGuiUtils.getLocalizedInstrumentName(soundFontProxy.id);
                    String trimmedName = GuiGuiMultiInstChooser.this.field_146289_q.func_78269_a(playlistName, this.listWidth - 10);
                    int color = this.isSelected(slotIdx) ? 0xFFFF00 : 0xAADDEE;
                    GuiGuiMultiInstChooser.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, color);
                } else {
                    String name = "---ERROR---";
                    String trimmedName = GuiGuiMultiInstChooser.this.field_146289_q.func_78269_a(name, this.listWidth - 10);
                    int color = 0xFF0000;
                    GuiGuiMultiInstChooser.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, color);
                }
            }
        };
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        int instListWidth = 95;
        for (SoundFontProxy in : SoundFontProxyManager.soundFontProxyMapByIndex.values()) {
            int stringWidth = this.field_146289_q.func_78256_a(ModGuiUtils.getLocalizedInstrumentName(in.id));
            instListWidth = Math.max(instListWidth, stringWidth + 10);
        }
        instListWidth = Math.min(instListWidth, 128);
        this.guiInstruments.setLayout(this.field_146289_q.field_78288_b + 2, instListWidth, 145, this.guiTop + 10, this.guiTop + 12 + 141, this.guiLeft + 10);
        int widthButtons = 50;
        int posX = this.guiLeft + 256 - widthButtons - 10;
        int posY = this.guiTop + 164 - 20 - 10;
        GuiButtonMX buttonDone = new GuiButtonMX(0, posX, posY, widthButtons, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(buttonDone);
        this.guiInstruments.addAll((Collection<SoundFontProxy>)SoundFontProxyManager.soundFontProxyMapByIndex.values());
        this.reloadState();
    }

    private void reloadState() {
        this.guiInstruments.setSelectedIndex(this.field_146297_k.field_71439_g.func_184614_ca().func_77952_i());
        this.guiInstruments.resetScroll();
        this.updateButtons();
    }

    private void updateState() {
        this.updateSelected();
        this.updateButtons();
    }

    private void updateButtons() {
    }

    private void updateSelected() {
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.guiScreenOld);
            return;
        }
        this.updateState();
        super.func_73869_a(typedChar, keyCode);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawGuiBackground();
        String title = I18n.func_135052_a((String)"mxtune.gui.GuiGuiMultiInstChooser.title", (Object[])new Object[0]);
        int posX = (this.guiInstruments.getRight() + (this.guiLeft + 256)) / 2 - this.field_146289_q.func_78256_a(title) / 2;
        int posY = this.guiTop + 10;
        this.field_146289_q.func_78256_a(title);
        this.field_146289_q.func_78276_b(title, posX, posY, 0);
        this.guiInstruments.drawScreen(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int scale = 2;
        posX = (this.guiInstruments.getRight() + (this.guiLeft + 256)) / 2 - 16 * scale / 2;
        ModGuiUtils.drawItem(this.field_146296_j, this.field_146297_k.field_71439_g.func_184614_ca(), posX / scale, (posY += 12) / scale, scale);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        switch (guibutton.field_146127_k) {
            case 0: {
                break;
            }
        }
        this.field_146297_k.func_147108_a(this.guiScreenOld);
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.guiInstruments.handleMouseInput(mouseX, mouseY);
        super.func_146274_d();
    }

    private void drawGuiBackground() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(guiTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 164);
    }
}

