/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.caches.DirectoryWatcher;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.gui.mml.ActionGet;
import net.aeronica.mods.mxtune.gui.mml.ImportHelper;
import net.aeronica.mods.mxtune.gui.mml.SortPathHelper;
import net.aeronica.mods.mxtune.gui.util.GuiButtonMX;
import net.aeronica.mods.mxtune.gui.util.GuiScrollingListOf;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

public class GuiFileSelector
extends GuiScreen {
    private static final String TITLE = I18n.func_135052_a((String)"mxtune.gui.guiFileSelector.title", (Object[])new Object[0]);
    private static final String MIDI_NOT_AVAILABLE = I18n.func_135052_a((String)"mxtune.chat.msu.midiNotAvailable", (Object[])new Object[0]);
    private int guiLeft;
    private int guiTop;
    private final GuiScreen guiScreenParent;
    private boolean isStateCached;
    private int cachedSelectedIndex;
    private boolean midiUnavailable;
    private GuiScrollingListOf<Path> guiFileList;
    private Path selectedFile;
    private GuiLabel searchLabel;
    private GuiTextField search;
    private boolean sorted = false;
    private SortPathHelper.SortType sortType = SortPathHelper.SortType.NORMAL;
    private String lastSearch = "";
    private SortPathHelper.SortType cachedSortType;
    private GuiButton buttonCancel;
    private List<GuiButton> safeButtonList;
    private List<Path> fileList = new ArrayList<Path>();
    private boolean watcherStarted = false;
    private DirectoryWatcher watcher;

    public GuiFileSelector(@Nullable GuiScreen guiScreenParent) {
        this.guiScreenParent = guiScreenParent;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.midiUnavailable = MIDISystemUtil.midiUnavailable();
        DirectoryStream.Filter<Path> filter = entry -> entry.toString().endsWith(".zip") || entry.toString().endsWith(".mml") || entry.toString().endsWith(".ms2mml");
        this.watcher = new DirectoryWatcher.Builder().addDirectories(FileHelper.getDirectory("mxtune/import_folder", Side.CLIENT)).setPreExistingAsCreated(true).setFilter(filter::accept).build((event, path) -> {
            switch (event) {
                case ENTRY_CREATE: 
                case ENTRY_MODIFY: 
                case ENTRY_DELETE: {
                    this.func_73866_w_();
                }
            }
        });
    }

    public void func_146281_b() {
        this.stopWatcher();
    }

    private void startWatcher() {
        if (!this.watcherStarted) {
            try {
                this.watcherStarted = true;
                this.watcher.start();
            }
            catch (Exception e) {
                this.watcherStarted = false;
                ModLogger.error(e);
            }
        }
    }

    private void stopWatcher() {
        if (this.watcherStarted) {
            this.watcher.stop();
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.guiLeft = 0;
        this.guiTop = 0;
        int guiListWidth = this.field_146294_l - 10;
        int entryHeight = this.field_146297_k.field_71466_p.field_78288_b + 2;
        int left = 5;
        int titleTop = 20;
        int listTop = titleTop + 25;
        int listHeight = this.field_146295_m - titleTop - entryHeight - 2 - 10 - 25 - 25;
        int listBottom = listTop + listHeight;
        int statusTop = listBottom + 4;
        this.guiFileList = new GuiScrollingListOf<Path>((GuiScreen)this, entryHeight, guiListWidth, listHeight, listTop, listBottom, left){

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                String name = ((Path)this.get(slotIdx)).getFileName().toString();
                String trimmedName = GuiFileSelector.this.field_146289_q.func_78269_a(name, this.listWidth - 10);
                GuiFileSelector.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, 11393254);
            }

            @Override
            protected void selectedClickedCallback(int selectedIndex) {
                GuiFileSelector.this.selectedFile = (Path)this.get(selectedIndex);
            }

            @Override
            protected void selectedDoubleClickedCallback(int selectedIndex) {
                GuiFileSelector.this.selectDone();
            }
        };
        String searchLabelText = I18n.func_135052_a((String)"mxtune.gui.label.search", (Object[])new Object[0]);
        int searchLabelWidth = this.field_146289_q.func_78256_a(searchLabelText) + 4;
        this.searchLabel = new GuiLabel(this.field_146289_q, 0, left, statusTop, searchLabelWidth, entryHeight + 2, 0xFFFFFF);
        this.searchLabel.func_175202_a(searchLabelText);
        this.searchLabel.field_146172_j = true;
        this.search = new GuiTextField(0, this.field_146289_q, left + searchLabelWidth, statusTop, guiListWidth - searchLabelWidth, entryHeight + 2);
        this.search.func_146195_b(true);
        this.search.func_146205_d(true);
        int buttonMargin = 1;
        int buttonWidth = 75;
        int x = left;
        GuiButton normalSort = new GuiButton(SortPathHelper.SortType.NORMAL.getButtonID(), x, titleTop, buttonWidth - buttonMargin, 20, I18n.func_135052_a((String)"fml.menu.mods.normal", (Object[])new Object[0]));
        normalSort.field_146124_l = false;
        this.field_146292_n.add(normalSort);
        this.field_146292_n.add(new GuiButton(SortPathHelper.SortType.A_TO_Z.getButtonID(), x += buttonWidth + buttonMargin, titleTop, buttonWidth - buttonMargin, 20, "A-Z"));
        this.field_146292_n.add(new GuiButton(SortPathHelper.SortType.Z_TO_A.getButtonID(), x += buttonWidth + buttonMargin, titleTop, buttonWidth - buttonMargin, 20, "Z-A"));
        int buttonTop = this.field_146295_m - 25;
        int xOpen = this.field_146294_l / 2 - 150;
        int xRefresh = xOpen + 75;
        int xDone = xRefresh + 75;
        int xCancel = xDone + 75;
        GuiButtonMX buttonOpen = new GuiButtonMX(2, xOpen, buttonTop, 75, 20, I18n.func_135052_a((String)"mxtune.gui.button.openFolder", (Object[])new Object[0]));
        buttonOpen.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.guiFileSelector.openFolder.help", (Object[])new Object[0]));
        GuiButtonMX buttonRefresh = new GuiButtonMX(3, xRefresh, buttonTop, 75, 20, I18n.func_135052_a((String)"mxtune.gui.button.refresh", (Object[])new Object[0]));
        buttonRefresh.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.guiFileSelector.refresh.help", (Object[])new Object[0]));
        GuiButton buttonDone = new GuiButton(0, xDone, buttonTop, 75, 20, I18n.func_135052_a((String)"mxtune.gui.button.select", (Object[])new Object[0]));
        this.buttonCancel = new GuiButton(1, xCancel, buttonTop, 75, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(buttonDone);
        this.field_146292_n.add(this.buttonCancel);
        this.field_146292_n.add(buttonOpen);
        this.field_146292_n.add(buttonRefresh);
        this.safeButtonList = new CopyOnWriteArrayList<GuiButton>(this.field_146292_n);
        this.sorted = false;
        this.startWatcher();
        this.initFileList();
        this.reloadState();
        SortPathHelper.updateSortButtons(this.sortType, this.safeButtonList);
    }

    private void reloadState() {
        if (!this.isStateCached) {
            return;
        }
        this.sortType = this.cachedSortType;
        this.guiFileList.elementClicked(this.cachedSelectedIndex);
        this.guiFileList.resetScroll();
        this.cachedSelectedIndex = this.guiFileList.getSelectedIndex();
        this.search.func_146180_a(this.lastSearch);
    }

    private void updateState() {
        this.cachedSelectedIndex = this.guiFileList.getSelectedIndex();
        this.cachedSortType = this.sortType;
        this.searchAndSort();
        this.isStateCached = true;
    }

    public void func_73876_c() {
        this.cachedSelectedIndex = this.guiFileList.getSelectedIndex();
        this.guiFileList.elementClicked(this.cachedSelectedIndex);
        this.search.func_146178_a();
        super.func_73876_c();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        String title = this.midiUnavailable ? TITLE + " - " + TextFormatting.RED + MIDI_NOT_AVAILABLE : TITLE;
        int posX = (this.field_146294_l - this.field_146297_k.field_71466_p.func_78256_a(title)) / 2;
        int posY = 5;
        this.field_146297_k.field_71466_p.func_175063_a(title, (float)posX, (float)posY, 0xD3D3D3);
        this.guiFileList.drawScreen(mouseX, mouseY, partialTicks);
        this.searchLabel.func_146159_a(this.field_146297_k, mouseX, mouseY);
        this.search.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ModGuiUtils.INSTANCE.drawHooveringHelp(this, this.safeButtonList, this.guiLeft, this.guiTop, mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            SortPathHelper.SortType type = SortPathHelper.SortType.getTypeForButton(button);
            if (type != null) {
                SortPathHelper.updateSortButtons(type, this.field_146292_n);
                this.sorted = false;
                this.sortType = type;
                this.initFileList();
            } else {
                switch (button.field_146127_k) {
                    case 0: {
                        this.selectDone();
                        break;
                    }
                    case 1: {
                        if (this.guiScreenParent != null) {
                            ActionGet.INSTANCE.setCancel();
                        }
                        this.field_146297_k.func_147108_a(this.guiScreenParent);
                        break;
                    }
                    case 2: {
                        this.openFolder();
                        break;
                    }
                    case 3: {
                        this.refresh();
                        break;
                    }
                }
            }
        }
        this.updateState();
        super.func_146284_a(button);
    }

    private void selectDone() {
        ActionGet.INSTANCE.select(ImportHelper.importToMXTFile(this.guiFileList.get()));
        this.field_146297_k.func_147108_a(this.guiScreenParent);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.search.func_146201_a(typedChar, keyCode);
        if (keyCode == 1) {
            this.func_146284_a(this.buttonCancel);
            return;
        }
        this.updateState();
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.guiFileList.handleMouseInput(mouseX, mouseY);
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.search.func_146192_a(mouseX, mouseY, mouseButton);
        ModGuiUtils.clearOnMouseLeftClicked(this.search, mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.updateState();
    }

    private void initFileList() {
        Path path = FileHelper.getDirectory("mxtune/import_folder", Side.CLIENT);
        PathMatcher filter = FileHelper.getMmlMatcher(path);
        try {
            Stream<Path> paths = Files.list(path);
            Object object = null;
            try {
                this.fileList = paths.filter(filter::matches).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (paths != null) {
                    if (object != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        paths.close();
                    }
                }
            }
        }
        catch (IOException | NullPointerException e) {
            ModLogger.error(e);
        }
        ArrayList<Path> files = new ArrayList<Path>();
        for (Path file : this.fileList) {
            if (!file.getFileName().toString().toLowerCase(Locale.ROOT).contains(this.search.func_146179_b().toLowerCase(Locale.ROOT))) continue;
            files.add(file);
        }
        this.fileList = files;
        this.guiFileList.clear();
        this.guiFileList.addAll(files);
        this.lastSearch = this.search.func_146179_b();
    }

    private void openFolder() {
        FileHelper.openFolder("mxtune/import_folder");
    }

    private void refresh() {
        this.func_73866_w_();
    }

    private void searchAndSort() {
        if (!this.search.func_146179_b().equals(this.lastSearch)) {
            this.initFileList();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.initFileList();
            this.guiFileList.sort(this.sortType);
            this.guiFileList.setSelectedIndex(this.fileList.indexOf(this.selectedFile));
            this.cachedSelectedIndex = this.guiFileList.getSelectedIndex();
            this.sorted = true;
        }
    }
}

