/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.hud;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.gui.hud.GuiHudAdjust;
import net.aeronica.mods.mxtune.gui.hud.HudData;
import net.aeronica.mods.mxtune.gui.hud.HudDataFactory;
import net.aeronica.mods.mxtune.inventory.IInstrument;
import net.aeronica.mods.mxtune.managers.GroupHelper;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.status.ClientCSDMonitor;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.PlacedInstrumentUtil;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class GuiJamOverlay
extends Gui {
    private static final String INSTRUMENT_INVENTORY_EMPTY = "[" + I18n.func_135052_a((String)"mxtune.instrumentInventory.empty", (Object[])new Object[0]) + "]";
    private static final ResourceLocation TEXTURE_STATUS = new ResourceLocation("mxtune", "textures/gui/status_widgets.png");
    public static final int HOT_BAR_CLEARANCE = 40;
    private static final int WIDGET_WIDTH = 256;
    private static final int WIDGET_HEIGHT = 104;
    private static final int PLACARD_ICON_SIZE = 24;
    private static final int PLACARD_ICON_BASE_U_OFFSET = 54;
    private static final int PLACARD_ICON_BASE_V_OFFSET = 200;
    private static final int PLACARD_ICONS_PER_ROW = 8;
    private Minecraft mc = Minecraft.func_71410_x();
    private FontRenderer fontRenderer;
    private static int hudTimer = 0;
    private static int count = 0;
    private static final int HUD_TIME = 5;
    private static boolean riding;
    private static ItemStack lastItemStack;
    private static ItemStack itemStack;
    private static float partialTicks;
    private static final int TITLE_DISPLAY_WIDTH = 30;
    private static int marqueePos;
    private static Integer[][] notePosMembers;

    public static GuiJamOverlay getInstance() {
        return GuiJamOverlayHolder.INSTANCE;
    }

    public GuiJamOverlay() {
        this.fontRenderer = this.mc.field_71466_p;
    }

    public static void hudTimerReset() {
        hudTimer = 5;
    }

    @SubscribeEvent
    public void onEvent(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            if (count++ % 20 == 0 && hudTimer > 0) {
                --hudTimer;
            }
            if (count % 5 == 0) {
                ++marqueePos;
            }
            if (count % 10 == 0) {
                ClientCSDMonitor.detectAndSend();
            }
            count = (int)((float)count + partialTicks);
        }
    }

    private boolean canRenderHud(EntityPlayer playerIn) {
        if (this.inGuiHudAdjust()) {
            return true;
        }
        return !MusicOptionsUtil.isHudDisabled(playerIn) && hudTimer > 0;
    }

    private boolean inGuiHudAdjust() {
        return this.mc.field_71462_r instanceof GuiHudAdjust;
    }

    private static boolean isRidingFlag() {
        return riding;
    }

    private static void setRidingFlag(boolean flag) {
        riding = flag;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        block14: {
            block11: {
                ItemStack sheetMusic;
                HudData hudData;
                EntityPlayerSP player;
                RenderGameOverlayEvent.ElementType elementType;
                block13: {
                    block12: {
                        if (this.mc.field_71474_y.field_74330_P) {
                            return;
                        }
                        elementType = event.getType();
                        if (event.isCancelable() || elementType != RenderGameOverlayEvent.ElementType.EXPERIENCE && elementType != RenderGameOverlayEvent.ElementType.TEXT) {
                            return;
                        }
                        player = this.mc.field_71439_g;
                        int width = event.getResolution().func_78326_a();
                        int height = event.getResolution().func_78328_b() - 40;
                        partialTicks = event.getPartialTicks();
                        hudData = HudDataFactory.calcHudPositions(this.inGuiHudAdjust() ? MusicOptionsUtil.getAdjustPositionHud() : MusicOptionsUtil.getPositionHUD((EntityPlayer)player), width, height);
                        if (PlacedInstrumentUtil.isRiding((EntityPlayer)player)) {
                            BlockPos pos = PlacedInstrumentUtil.getRiddenBlock((EntityPlayer)player);
                            sheetMusic = SheetMusicUtil.getSheetMusic(pos, (EntityPlayer)player, true);
                            if (!GuiJamOverlay.isRidingFlag()) {
                                GuiJamOverlay.hudTimerReset();
                            }
                            GuiJamOverlay.setRidingFlag(true);
                        } else {
                            itemStack = player.func_184614_ca();
                            sheetMusic = SheetMusicUtil.getSheetMusic(itemStack);
                            GuiJamOverlay.setRidingFlag(false);
                        }
                        if (!this.inGuiHudAdjust() && (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof IInstrument)) && !GuiJamOverlay.isRidingFlag()) break block11;
                        if (lastItemStack.func_190926_b()) break block12;
                        if (itemStack.func_190926_b()) break block13;
                        if (itemStack.equals(lastItemStack)) break block13;
                    }
                    if (!GuiJamOverlay.isRidingFlag()) {
                        GuiJamOverlay.hudTimerReset();
                        lastItemStack = itemStack;
                    }
                }
                if (this.canRenderHud((EntityPlayer)player)) {
                    this.renderHud(hudData, (EntityPlayer)player, sheetMusic, elementType);
                } else {
                    this.renderMini(hudData, (EntityPlayer)player, elementType);
                }
                break block14;
            }
            lastItemStack = itemStack;
        }
    }

    private List<GroupData> processGroup(EntityPlayer playerIn) {
        ArrayList<GroupData> groupData = new ArrayList<GroupData>();
        int index = 0;
        Integer groupID = GroupHelper.getMembersGroupID(playerIn.func_145782_y());
        if (groupID != -1) {
            Integer leaderID = GroupHelper.getLeaderOfGroup(groupID);
            EntityPlayer entityLeader = MXTune.proxy.getPlayerByEntityID(leaderID);
            String memberName = entityLeader != null ? entityLeader.func_70005_c_() : "***Error***";
            Integer memberNameWidth = this.fontRenderer.func_78256_a(memberName);
            Integer playStatus = GroupHelper.getIndex(leaderID);
            Tuple notePos = new Tuple((Object)notePosMembers[index][0], (Object)notePosMembers[index][1]);
            GroupData memberData = new GroupData(leaderID, memberName, memberNameWidth, (Tuple<Integer, Integer>)notePos, playStatus);
            groupData.add(memberData);
            ++index;
            Set<Integer> set = GroupHelper.getClientMembers().keySet();
            for (Integer memberID : set) {
                EntityPlayer entityMember = MXTune.proxy.getPlayerByEntityID(memberID);
                if (!groupID.equals(GroupHelper.getMembersGroupID(memberID)) || memberID.equals(GroupHelper.getLeaderOfGroup(groupID)) || entityMember == null) continue;
                memberName = entityMember.func_70005_c_();
                memberNameWidth = this.fontRenderer.func_78256_a(memberName);
                playStatus = GroupHelper.getIndex(memberID);
                notePos = new Tuple((Object)notePosMembers[index][0], (Object)notePosMembers[index][1]);
                memberData = new GroupData(memberID, memberName, memberNameWidth, (Tuple<Integer, Integer>)notePos, playStatus);
                groupData.add(memberData);
                ++index;
            }
        }
        return groupData;
    }

    private void drawDebug(HudData hd, int maxWidth, int maxHeight) {
        int qY;
        int qX;
        int statusWidth;
        String status;
        if (!Miscellus.inDev()) {
            return;
        }
        int y = 50;
        if (GroupHelper.getClientPlayStatuses() != null && !GroupHelper.getClientPlayStatuses().isEmpty()) {
            status = "Play Status:    " + GroupHelper.getClientPlayStatuses().toString();
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (GroupHelper.getPlayIDMembers() != null && !GroupHelper.getPlayIDMembers().isEmpty()) {
            status = "PlayID Members: " + GroupHelper.getPlayIDMembers().toString();
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (!GroupHelper.getAllPlayIDs().isEmpty()) {
            status = "All Play IDs:  " + GroupHelper.getAllPlayIDs().toString();
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (GroupHelper.getServerManagedPlayIDs() != null && !GroupHelper.getServerManagedPlayIDs().isEmpty()) {
            status = "Server Managed PlayIDs:  " + GroupHelper.getServerManagedPlayIDs().toString();
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (!ClientAudio.getActivePlayIDs().isEmpty()) {
            status = "Client Active PlayIDs:  " + ClientAudio.getActivePlayIDs().toString();
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (!GroupHelper.getAllPlayIDs().isEmpty()) {
            status = "GroupHelper.index:   " + GroupHelper.getIndex(this.mc.field_71439_g.func_145782_y());
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (GroupHelper.getGroupsMembers() != null && !GroupHelper.getGroupsMembers().isEmpty()) {
            status = "GroupsMembers:  " + GroupHelper.getGroupsMembers();
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (GroupHelper.getGroupsMembers() != null && !GroupHelper.getGroupsMembers().isEmpty()) {
            status = String.format("Group Distance: %-1.2f", GroupHelper.getGroupMembersScaledDistance((EntityPlayer)this.mc.field_71439_g));
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (this.mc.field_71441_e != null && this.mc.func_147114_u() != null) {
            status = String.format("Remote Address: %s", this.mc.func_147114_u().func_147298_b().func_74430_c().toString());
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (this.mc.field_71441_e != null && this.mc.func_147114_u() != null) {
            status = String.format("GameProfile Name: %s", this.mc.func_147114_u().func_175105_e().getName());
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
        if (this.mc.field_71441_e != null && this.mc.func_147114_u() != null) {
            status = String.format("GameProfile UUID: %s", this.mc.func_147114_u().func_175105_e().getId());
            statusWidth = this.fontRenderer.func_78256_a(status);
            qX = hd.quadX(maxWidth, 0, 4, statusWidth);
            qY = hd.quadY(maxHeight, y += 10, 4, 10);
            this.fontRenderer.func_175063_a(status, (float)qX, (float)qY, 0xFFFFFF);
        }
    }

    private String getMusicTitle(ItemStack stackIn) {
        String sheetMusicTitle = GuiJamOverlay.getMusicTitleRaw(stackIn);
        if (sheetMusicTitle.isEmpty()) {
            return INSTRUMENT_INVENTORY_EMPTY;
        }
        return sheetMusicTitle;
    }

    private static String getMusicTitleRaw(ItemStack sheetMusic) {
        if (!sheetMusic.func_190926_b() && sheetMusic.func_77978_p() != null) {
            return sheetMusic.func_82833_r();
        }
        return "";
    }

    private static int getMarqueePos() {
        return marqueePos;
    }

    private String marquee(String text, int window) {
        int tail;
        int marqueePos = GuiJamOverlay.getMarqueePos();
        if (text.length() <= window) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text).append("   ");
        int head = marqueePos % sb.length();
        if (head < (tail = (head + window) % sb.length())) {
            return sb.substring(head, tail);
        }
        return sb.toString().substring(head, sb.length()) + sb.substring(0, tail);
    }

    private String spaces(int length) {
        StringBuilder outputBuffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            outputBuffer.append(" ");
        }
        return outputBuffer.toString();
    }

    private void renderHud(HudData hd, EntityPlayer playerIn, ItemStack sheetMusic, RenderGameOverlayEvent.ElementType elementType) {
        int maxWidth = 256;
        int maxHeight = 128;
        float hudScale = this.inGuiHudAdjust() ? MusicOptionsUtil.getAdjustSizeHud() : MusicOptionsUtil.getSizeHud(playerIn);
        String musicTitle = this.getMusicTitle(sheetMusic);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)hd.getPosX(), (float)hd.getPosY(), (float)0.0f);
        if (elementType == RenderGameOverlayEvent.ElementType.TEXT) {
            this.drawDebug(hd, maxWidth, maxHeight);
        }
        GL11.glScalef((float)hudScale, (float)hudScale, (float)hudScale);
        int iconX = hd.quadX(maxWidth, 0, 2, 256);
        int iconY = hd.quadY(maxHeight, 0, 2, 104);
        this.setTexture(TEXTURE_STATUS);
        if (elementType == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            this.drawWidget(playerIn, iconX, iconY, musicTitle);
        }
        GL11.glPopMatrix();
    }

    private void renderMini(HudData hd, EntityPlayer playerIn, RenderGameOverlayEvent.ElementType elementType) {
        GL11.glPushMatrix();
        int maxWidth = 256;
        int maxHeight = 128;
        GL11.glTranslatef((float)hd.getPosX(), (float)hd.getPosY(), (float)0.0f);
        if (elementType == RenderGameOverlayEvent.ElementType.TEXT) {
            this.drawDebug(hd, maxWidth, maxHeight);
        }
        if (elementType == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            int iconX = hd.quadX(24, 0, 2, 24);
            int iconY = hd.quadY(24, 0, 2, 24);
            int index = GroupHelper.getIndex(playerIn.func_145782_y());
            this.setTexture(TEXTURE_STATUS);
            this.func_73729_b(iconX, iconY, 54 + index % 8 * 24, 200 + index / 8 * 24, 24, 24);
            double dist = GroupHelper.getGroupMembersScaledDistance(playerIn);
            if (dist > 0.0) {
                Color color = new Color(127, 255, 0);
                int colorRGB = Color.HSBtoRGB((float)((1.0 - dist) * 0.5), 1.0f, 1.0f);
                GuiJamOverlay.drawRect(iconX + 4, iconY + 20, iconX + 4 + (int)(15.0 * dist), iconY + 22, colorRGB + -805306368);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawWidget(EntityPlayer playerIn, int posX, int posY, String musicTitle) {
        int y;
        int x;
        this.func_73729_b(posX, posY, 0, 0, 256, 104);
        this.func_73729_b(posX + 14 + 4, posY + 23, 0, 136, 28, 64);
        List<GroupData> groupData = this.processGroup(playerIn);
        if (GroupHelper.getClientGroups() != null || GroupHelper.getClientMembers() != null) {
            NOTATION eNOTATION;
            if (GroupHelper.getMembersGroupID(playerIn.func_145782_y()) != -1) {
                for (GroupData gd : groupData) {
                    int status = GroupHelper.getIndex(gd.memberID);
                    eNOTATION = NOTATION.byMetadata(status);
                    int nX = eNOTATION.getX();
                    int nY = eNOTATION.getY();
                    int x2 = posX + (Integer)gd.notePos.func_76341_a();
                    int y2 = posY + (Integer)gd.notePos.func_76340_b();
                    this.func_73729_b(x2, y2, nX, nY, 24, 16);
                }
            } else {
                int status = GroupHelper.getIndex(playerIn.func_145782_y());
                eNOTATION = NOTATION.byMetadata(status);
                int nX = eNOTATION.getX();
                int nY = eNOTATION.getY();
                x = posX + notePosMembers[0][0];
                y = posY + notePosMembers[0][1];
                this.func_73729_b(x, y, nX, nY, 24, 16);
            }
        }
        if (GroupHelper.getClientGroups() != null || GroupHelper.getClientMembers() != null) {
            if (GroupHelper.getMembersGroupID(playerIn.func_145782_y()) != -1) {
                int oddEven = 1;
                for (GroupData gd : groupData) {
                    x = posX + (Integer)gd.notePos.func_76341_a() + 28;
                    y = posY + (Integer)gd.notePos.func_76340_b() + 4;
                    int textWidth = this.fontRenderer.func_78256_a(TextFormatting.BOLD + this.marquee(gd.getMemberName(), 10));
                    if (oddEven++ % 2 == 0) {
                        GuiJamOverlay.drawRect(x - 2, y - 2, x + textWidth + 2, y + 10, -792160936);
                    }
                    this.fontRenderer.func_78276_b(TextFormatting.BOLD + this.marquee(gd.getMemberName(), 10), x, y, 5519138);
                }
            } else {
                GroupHelper.getIndex(playerIn.func_145782_y());
                int x3 = posX + notePosMembers[0][0] + 28;
                int y3 = posY + notePosMembers[0][1] + 4;
                String name = playerIn.func_145748_c_().func_150260_c();
                this.fontRenderer.func_78276_b(TextFormatting.BOLD + this.marquee(name, 10), x3, y3, 5519138);
            }
        }
        int musicTitleWidth = this.fontRenderer.func_78256_a(TextFormatting.BOLD + this.marquee(musicTitle, 30));
        int musicTitlePosX = posX + (128 - musicTitleWidth / 2);
        int musicTitlePosY = posY + 10;
        this.fontRenderer.func_78276_b(TextFormatting.BOLD + this.marquee(musicTitle, 30), musicTitlePosX, musicTitlePosY, 5519138);
        double dist = GroupHelper.getGroupMembersScaledDistance(playerIn);
        if (dist > 0.0) {
            Color color = new Color(127, 255, 0);
            int colorRGB = Color.HSBtoRGB((float)((1.0 - dist) * 0.5), 1.0f, 1.0f);
            GuiJamOverlay.drawRect(posX + 237, posY + 24 + 62 - (int)(62.0 * dist), posX + 240, posY + 87, colorRGB + -1879048192);
        }
    }

    public void setTexture(ResourceLocation texture) {
        this.mc.field_71446_o.func_110577_a(texture);
    }

    public static void drawRect(int leftIn, int topIn, int rightIn, int bottomIn, int color) {
        int left = leftIn;
        int top = topIn;
        int right = rightIn;
        int bottom = bottomIn;
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    static {
        lastItemStack = ItemStack.field_190927_a;
        marqueePos = 0;
        notePosMembers = new Integer[][]{{45, 23}, {140, 31}, {45, 39}, {140, 47}, {45, 55}, {140, 63}, {45, 71}, {140, 79}};
    }

    public static enum NOTATION {
        MEMBER_REST(0, 96, 104),
        MEMBER_QUEUED(1, 144, 104),
        MEMBER_PLAY(2, 0, 104),
        E3(3, 0, 104),
        E4(4, 0, 104),
        E5(5, 0, 104),
        E6(6, 0, 104),
        E7(7, 0, 104),
        LEADER_REST(8, 96, 104),
        LEADER_QUEUED(9, 144, 104),
        LEADER_PLAY(10, 0, 104);

        private final int meta;
        private final int x;
        private final int y;
        private static final NOTATION[] META_LOOKUP;

        public int getMetadata() {
            return this.meta;
        }

        public static NOTATION byMetadata(int metaIn) {
            int metaLocal = metaIn;
            if (metaLocal < 0 || metaLocal >= META_LOOKUP.length) {
                metaLocal = 0;
            }
            return META_LOOKUP[metaLocal];
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        private NOTATION(int metaIn, int xIn, int yIn) {
            this.meta = metaIn;
            this.x = xIn;
            this.y = yIn;
        }

        static {
            META_LOOKUP = new NOTATION[NOTATION.values().length];
            NOTATION[] nOTATIONArray = NOTATION.values();
            int n = nOTATIONArray.length;
            for (int i = 0; i < n; ++i) {
                NOTATION value;
                NOTATION.META_LOOKUP[value.getMetadata()] = value = nOTATIONArray[i];
            }
        }
    }

    private class GroupData {
        Integer memberID;
        String memberName;
        Integer memberNameWidth;
        Tuple<Integer, Integer> notePos;
        Integer playStatus;

        GroupData(Integer memberID, String memberName, Integer memberNameWidth, Tuple<Integer, Integer> notePos, Integer playStatus) {
            this.memberID = memberID;
            this.memberName = memberName;
            this.memberNameWidth = memberNameWidth;
            this.notePos = notePos;
            this.playStatus = playStatus;
        }

        public Integer getPlayStatus() {
            return this.playStatus;
        }

        public void setPlayStatus(Integer playStatus) {
            this.playStatus = playStatus;
        }

        public Tuple<Integer, Integer> getNotePos() {
            return this.notePos;
        }

        public void setNotePos(Tuple<Integer, Integer> notePos) {
            this.notePos = notePos;
        }

        String getMemberName() {
            return this.memberName;
        }

        public void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        public Integer getMemberNameWidth() {
            return this.memberNameWidth;
        }

        public void setMemberNameWidth(Integer memberNameWidth) {
            this.memberNameWidth = memberNameWidth;
        }
    }

    private static class GuiJamOverlayHolder {
        private static final GuiJamOverlay INSTANCE = new GuiJamOverlay();

        private GuiJamOverlayHolder() {
        }
    }
}

