/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.config;

import com.google.common.collect.Maps;
import java.util.Map;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig {
    private ModConfig() {
    }

    public static boolean isJAMPartyRightClickDisabled() {
        return ConfigGeneral.general.disableJAMPartyRightClick;
    }

    public static float getListenerRange() {
        return ConfigGeneral.general.listenerRange;
    }

    public static float getGroupPlayAbortDistance() {
        return ConfigGeneral.general.groupPlayAbortDistance;
    }

    public static boolean showWelcomeStatusMessage() {
        return ConfigGeneral.general.showWelcomeStatusMessage;
    }

    public static boolean moreDebugMessages() {
        return ConfigGeneral.general.moreDebugMessages;
    }

    public static boolean getAutoConfigureChannels() {
        return ConfigClient.sound.autoConfigureChannels;
    }

    public static boolean isCreativeMusicDisabled() {
        return ConfigClient.vanillaMusic.disableCreativeMusic;
    }

    public static boolean isCreditsMusicDisabled() {
        return ConfigClient.vanillaMusic.disableCreditsMusic;
    }

    public static boolean isDragonMusicDisabled() {
        return ConfigClient.vanillaMusic.disableEndDragonMusic;
    }

    public static boolean isEndMusicDisabled() {
        return ConfigClient.vanillaMusic.disableEndMusic;
    }

    public static boolean isGameMusicDisabled() {
        return ConfigClient.vanillaMusic.disableGameMusic;
    }

    public static boolean isMenuMusicDisabled() {
        return ConfigClient.vanillaMusic.disableMenuMusic;
    }

    public static boolean isNetherMusicDisabled() {
        return ConfigClient.vanillaMusic.disableNetherMusic;
    }

    public static String getMmlLink() {
        return ConfigClient.links.site;
    }

    public static boolean isBandAmpFullBrightEffectEnabled() {
        return ConfigGeneral.instrumentOptions.enableBandAmpFullBrightEffect;
    }

    public static boolean isRecipeEnabled(ItemStack stackIn) {
        String itemName = stackIn.func_77977_a().replaceFirst("(item.|tile.)mxtune:", "");
        boolean enableState = !ConfigRecipes.recipeToggles.containsKey(itemName = itemName.replaceFirst("multi_inst.", "")) || ConfigRecipes.recipeToggles.get(itemName) != false && !itemName.contains(":");
        ModLogger.debug("Recipe Enabled? %s %s", itemName, enableState);
        return enableState;
    }

    public static boolean isRecipeHidden(ItemStack stackIn) {
        return !ModConfig.isRecipeEnabled(stackIn);
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        private RegistrationHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            ModLogger.debug("On ConfigChanged: %s", event.getModID());
            if (event.getModID().equals("mxtune")) {
                RegistrationHandler.sync();
            }
        }

        public static void sync() {
            ConfigManager.sync((String)"mxtune", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @Config(modid="mxtune", name="mxtune/mxtune_recipes", type=Config.Type.INSTANCE, category="recipe")
    @Config.LangKey(value="config.mxtune.category.recipes")
    public static class ConfigRecipes {
        @Config.LangKey(value="config.mxtune.enabledRecipes")
        @Config.Name(value="Toggles")
        @Config.Comment(value={"mxTune Recipes", "Requires a Server Restart if Changed!", "B:<name>=(true|false)"})
        @Config.RequiresMcRestart
        public static Map<String, Boolean> recipeToggles;
        private static final String[] modItemRecipeNames;

        private ConfigRecipes() {
        }

        static {
            modItemRecipeNames = new String[]{"band_amp", "spinet_piano", "flute_pan"};
            recipeToggles = Maps.newHashMap();
            for (String modItemRecipeName : modItemRecipeNames) {
                recipeToggles.put(modItemRecipeName, true);
            }
        }
    }

    @Config(modid="mxtune", name="mxtune/mxtune_general", category="general")
    @Config.LangKey(value="config.mxtune.category.general")
    public static class ConfigGeneral {
        @Config.Comment(value={"General Configuration"})
        @Config.LangKey(value="config.mxtune.generalConfig")
        public static final General general = new General();
        @Config.Comment(value={"Instrument Options"})
        @Config.LangKey(value="config.mxtune.generalConfig.instrumentOptions")
        public static final InstrumentOptions instrumentOptions = new InstrumentOptions();

        private ConfigGeneral() {
        }

        public static class InstrumentOptions {
            @Config.Name(value="Enable Band Amp Full-Bright effect when playing")
            @Config.LangKey(value="config.mxtune.enableBandAmpFullBrightEffect")
            public boolean enableBandAmpFullBrightEffect = true;
        }

        public static class General {
            @Config.Name(value="Show Welcome Status Message")
            @Config.LangKey(value="config.mxtune.showWelcomeStatusMessage")
            public boolean showWelcomeStatusMessage = false;
            @Config.Name(value="Listener Range")
            @Config.LangKey(value="config.mxtune.listenerRange")
            @Config.RangeInt(min=10, max=64)
            public int listenerRange = 24;
            @Config.Name(value="Group Play Abort Distance")
            @Config.LangKey(value="config.mxtune.groupPlayAbortDistance")
            @Config.RangeInt(min=10, max=24)
            public int groupPlayAbortDistance = 16;
            @Config.Name(value="More Debug Messages")
            @Config.LangKey(value="config.mxtune.moreDebugMessages")
            public boolean moreDebugMessages = false;
            @Config.Name(value="Disable JAM Party Right Click")
            @Config.LangKey(value="config.mxtune.disableJAMPartyRightClick")
            public boolean disableJAMPartyRightClick = false;
        }
    }

    @Config(modid="mxtune", name="mxtune/mxtune_client", category="client")
    @Config.LangKey(value="config.mxtune.category.client")
    public static class ConfigClient {
        @Config.LangKey(value="config.mxtune.vm.vanillaMusic")
        @Config.Comment(value={"Vanilla Background Music"})
        public static final VanillaMusic vanillaMusic = new VanillaMusic();
        @Config.LangKey(value="config.mxtune.autoConfigureChannels")
        @Config.Comment(value={"Sound Channel Configuration"})
        public static final Sound sound = new Sound();
        @Config.LangKey(value="config.mxtune.mmlLink")
        @Config.Comment(value={"Internet Resources"})
        public static final Links links = new Links();
        @Config.LangKey(value="config.mxtune.playerNameInWindowTitle")
        @Config.Comment(value={"Show player name in window title. Updates on logon and/or changing dimension."})
        public static final WindowTitle windowTitle = new WindowTitle();

        private ConfigClient() {
        }

        public static class VanillaMusic {
            @Config.Name(value="Disable Creative Music")
            @Config.LangKey(value="config.mxtune.vm.disableCreativeMusic")
            public boolean disableCreativeMusic = false;
            @Config.Name(value="Disable Credits Music")
            @Config.LangKey(value="config.mxtune.vm.disableCreditsMusic")
            public boolean disableCreditsMusic = false;
            @Config.Name(value="Disable End Dragon Music")
            @Config.LangKey(value="config.mxtune.vm.disableEndDragonMusic")
            public boolean disableEndDragonMusic = false;
            @Config.Name(value="Disable End Music")
            @Config.LangKey(value="config.mxtune.vm.disableEndMusic")
            public boolean disableEndMusic = false;
            @Config.Name(value="Disable Game Music")
            @Config.LangKey(value="config.mxtune.vm.disableGameMusic")
            public boolean disableGameMusic = false;
            @Config.Name(value="Disable Menu Music")
            @Config.LangKey(value="config.mxtune.vm.disableMenuMusic")
            public boolean disableMenuMusic = false;
            @Config.Name(value="Disable Nether Music")
            @Config.LangKey(value="config.mxtune.vm.disableNetherMusic")
            public boolean disableNetherMusic = false;
        }

        public static class WindowTitle {
            @Config.Name(value="Show player name in window title")
            @Config.LangKey(value="config.mxtune.playerNameInWindowTitle")
            public boolean showPlayerName = false;
        }

        public static class Links {
            @Config.Name(value="Site Links")
            @Config.LangKey(value="config.mxtune.mmlLink")
            public String site = "https://musicalnexus.net/";
        }

        public static class Sound {
            @Config.Name(value="Automatically configure sound channels")
            @Config.LangKey(value="config.mxtune.autoConfigureChannels")
            public boolean autoConfigureChannels = true;
        }
    }
}

