/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.caches;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.aeronica.mods.mxtune.util.MXTuneRuntimeException;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FileHelper {
    private static final String MOD_FOLDER = "mxtune";
    private static final String CLIENT_FOLDER = "mxtune";
    public static final String CLIENT_MML_FOLDER = "mxtune/import_folder";
    public static final String CLIENT_LIB_FOLDER = "mxtune/library";
    public static final String CLIENT_SERVER_CACHE_FOLDER = "mxtune/server_cache";
    public static final String SERVER_FOLDER = "mxtune";
    public static final String SERVER_PLAY_LISTS_FOLDER = "mxtune/playlists";
    public static final String SERVER_MUSIC_FOLDER = "mxtune/music";
    public static final String EXTENSION_DAT = ".dat";
    public static final String EXTENSION_MXT = ".mxt";
    private static Path serverWorldFolder;

    public static void initialize() {
        WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        File chunkDir = worldServer.getChunkSaveLocation();
        serverWorldFolder = Paths.get(chunkDir.getPath(), new String[0]);
    }

    private FileHelper() {
    }

    public static PathMatcher getMmlMatcher(Path path) {
        return path.getFileSystem().getPathMatcher("glob:**.{mml,ms2mml,zip}");
    }

    public static PathMatcher getDatMatcher(Path path) {
        return path.getFileSystem().getPathMatcher("glob:**.{dat}");
    }

    public static PathMatcher getMxtMatcher(Path path) {
        return path.getFileSystem().getPathMatcher("glob:**.{mxt}");
    }

    public static String removeExtension(String s) {
        return s.replaceAll("(\\.\\w+$)", "");
    }

    public static String normalizeFilename(String s) {
        return s.replaceAll("([\\x00-\\x1F!\"\\$'\\.\\(\\)\\*,\\/:;<>\\?\\[\\\\\\]\\{\\|\\}\\x7F]+)", "");
    }

    private static void fixDirectory(Path dir) {
        if (dir.toFile().exists() && !dir.toFile().isDirectory()) {
            try {
                Files.delete(dir);
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                ModLogger.error(e);
                ModLogger.warn("Unable to recreate folder, it exists but is not a directory: %s", dir);
            }
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                ModLogger.error(e);
                ModLogger.warn("Unable to create folder: %s", dir);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void openFolder(String folder) {
        OpenGlHelper.func_188786_a((File)FileHelper.getDirectory(folder, Side.CLIENT).toFile());
    }

    public static Path getDirectory(String folder, Side side) {
        return FileHelper.getDirectory(folder, side, true);
    }

    public static Path getDirectory(String folder, Side side, boolean fixDirectory) {
        String sidedPath = side == Side.SERVER ? serverWorldFolder.toString() : ".";
        Path loc = Paths.get(sidedPath, folder);
        if (fixDirectory) {
            FileHelper.fixDirectory(loc);
        }
        return loc;
    }

    public static Path getCacheFile(String folder, String filename, Side sideIn) throws IOException {
        Path dir = FileHelper.getDirectory(folder, sideIn);
        Path cacheFile = dir.resolve(filename);
        if (!cacheFile.toFile().exists()) {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.createFile(cacheFile, new FileAttribute[0]);
        }
        return cacheFile;
    }

    public static boolean fileExists(String folder, String filename, Side sideIn) {
        Path dir = FileHelper.getDirectory(folder, sideIn);
        Path resolve = dir.resolve(filename);
        return resolve.toFile().exists();
    }

    public static NBTTagCompound getCompoundFromFile(Path path) {
        if (path == null) {
            throw new MXTuneRuntimeException("Missing cache file!");
        }
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(path.toFile()));
        }
        catch (IOException e0) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbtTagCompound, (OutputStream)new FileOutputStream(path.toFile()));
                return FileHelper.getCompoundFromFile(path);
            }
            catch (IOException e1) {
                ModLogger.error(e1);
                return null;
            }
        }
    }

    public static void sendCompoundToFile(Path path, NBTTagCompound tagCompound) {
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)tagCompound, (OutputStream)new FileOutputStream(path.toFile()));
        }
        catch (IOException e) {
            ModLogger.error(e);
        }
    }
}

