/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.blocks;

import com.google.common.base.Function;
import java.util.Objects;
import net.aeronica.mods.mxtune.blocks.TileInstrument;
import net.aeronica.mods.mxtune.blocks.TilePiano;
import net.aeronica.mods.mxtune.init.IReBakeModel;
import net.aeronica.mods.mxtune.util.MXTuneRuntimeException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RendererPiano
extends TileEntitySpecialRenderer<TilePiano>
implements IReBakeModel {
    private double xMusicOffset = 0.0;
    private double zMusicOffset = 0.0;
    private EnumFacing facing = EnumFacing.NORTH;
    private double xRackOffset = 0.0;
    private double zRackOffset = 0.0;
    private double xBenchOffset = 0.0;
    private double zBenchOffset = 0.0;
    private float[] face = new float[]{0.0f, 0.0f, 90.0f, 270.0f, 180.0f, 0.0f, 0.0f, 0.0f};
    private IBakedModel bakedRackModel;
    private IBakedModel bakedBenchModel;

    @Override
    public void reBakeModel() {
        this.bakedRackModel = null;
        this.bakedBenchModel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBakedModel getRackBakedModel() {
        IModel rackModel;
        if (this.bakedRackModel != null) return this.bakedRackModel;
        try {
            Class<ModelLoaderRegistry> clazz = ModelLoaderRegistry.class;
            synchronized (ModelLoaderRegistry.class) {
                rackModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("mxtune", "block/piano_rack"));
                // ** MonitorExit[var2_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            throw new MXTuneRuntimeException(e);
        }
        {
            this.bakedRackModel = rackModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176600_a, (java.util.function.Function)((Function)location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(Objects.requireNonNull(location).toString())));
            return this.bakedRackModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBakedModel getBenchBakedModel() {
        IModel benchModel;
        if (this.bakedBenchModel != null) return this.bakedBenchModel;
        try {
            Class<ModelLoaderRegistry> clazz = ModelLoaderRegistry.class;
            synchronized (ModelLoaderRegistry.class) {
                benchModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("mxtune", "block/piano_bench"));
                // ** MonitorExit[var2_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            throw new MXTuneRuntimeException(e);
        }
        {
            this.bakedBenchModel = benchModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176600_a, (java.util.function.Function)((Function)location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(Objects.requireNonNull(location).toString())));
            return this.bakedBenchModel;
        }
    }

    public void render(TilePiano te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.facing = te.getFacing();
        if (this.facing.equals((Object)EnumFacing.NORTH)) {
            this.xMusicOffset = 0.0;
            this.zMusicOffset = -0.5;
            this.xRackOffset = 0.5;
            this.zRackOffset = 0.0;
            this.xBenchOffset = 1.375;
            this.zBenchOffset = 0.0;
        } else if (this.facing.equals((Object)EnumFacing.SOUTH)) {
            this.xMusicOffset = 0.0;
            this.zMusicOffset = 0.5;
            this.xRackOffset = 0.5;
            this.zRackOffset = 1.0;
            this.xBenchOffset = -0.375;
            this.zBenchOffset = 1.0;
        } else if (this.facing.equals((Object)EnumFacing.EAST)) {
            this.xMusicOffset = 0.5;
            this.zMusicOffset = 0.0;
            this.xRackOffset = 1.0;
            this.zRackOffset = 0.5;
            this.xBenchOffset = 1.0;
            this.zBenchOffset = 1.375;
        }
        if (this.facing.equals((Object)EnumFacing.WEST)) {
            this.xMusicOffset = -0.5;
            this.zMusicOffset = 0.0;
            this.xRackOffset = 0.0;
            this.zRackOffset = 0.5;
            this.xBenchOffset = 0.0;
            this.zBenchOffset = -0.375;
        }
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179101_C();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + this.xBenchOffset), (double)y, (double)(z + this.zBenchOffset));
        this.renderBench(te);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + this.xRackOffset), (double)(y + 1.0), (double)(z + this.zRackOffset));
        this.renderRack(te);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)(x + this.xMusicOffset), (double)(y + 1.25), (double)(z + this.zMusicOffset));
        this.renderSheetMusic(te);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private void renderRack(TileInstrument te) {
        GlStateManager.func_179094_E();
        this.renderCommon(te);
        World world = te.func_145831_w();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, this.getRackBakedModel(), world.func_180495_p(te.func_174877_v()), te.func_174877_v(), Tessellator.func_178181_a().func_178180_c(), true);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void renderBench(TileInstrument te) {
        GlStateManager.func_179094_E();
        this.renderCommon(te);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        World world = te.func_145831_w();
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, this.getBenchBakedModel(), world.func_180495_p(te.func_174877_v()), te.func_174877_v(), Tessellator.func_178181_a().func_178180_c(), true);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void renderCommon(TileInstrument te) {
        GlStateManager.func_179114_b((float)(this.face[this.facing.func_176745_a()] - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179137_b((double)((double)(-te.func_174877_v().func_177958_n()) - 0.5), (double)(-te.func_174877_v().func_177956_o()), (double)((double)(-te.func_174877_v().func_177952_p()) - 0.5));
    }

    private void renderSheetMusic(TileInstrument te) {
        ItemStack stack = te.getInventory().getStackInSlot(0);
        if (!stack.func_190926_b()) {
            RenderHelper.func_74519_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
            GlStateManager.func_179114_b((float)this.face[this.facing.func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
    }
}

