/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.readers.mml3mle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import javax.annotation.Nullable;
import net.aeronica.libs.mml.readers.mml3mle.Extension3mleTrack;
import net.aeronica.libs.mml.readers.mml3mle.MMLParseException;
import net.aeronica.libs.mml.readers.mml3mle.Map3MLEInstruments;
import net.aeronica.libs.mml.readers.mml3mle.SectionContents;
import net.aeronica.libs.mml.readers.mml3mle.TextParser;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.mxt.MXTunePart;
import net.aeronica.mods.mxtune.mxt.MXTuneStaff;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MMLFile {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MXTuneFile mxTuneFile = new MXTuneFile();
    private String encoding = "Shift_JIS";
    private LinkedList<String> mmlParts = new LinkedList();
    private List<Extension3mleTrack> trackList = null;

    public static MXTuneFile parse(Path path) {
        try {
            return new MMLFile().parse(MMLFile.getFile(path));
        }
        catch (MMLParseException e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public MXTuneFile parse(InputStream istream) throws MMLParseException {
        List<SectionContents> contentsList = SectionContents.makeSectionContentsByInputStream(istream, this.encoding);
        if (contentsList.isEmpty()) {
            throw new MMLParseException("no contents");
        }
        this.parseSection(contentsList);
        if (this.trackList == null || this.trackList.isEmpty()) {
            throw new MMLParseException("no track");
        }
        this.createTrack();
        return this.mxTuneFile;
    }

    private static FileInputStream getFile(@Nullable Path path) {
        FileInputStream is = null;
        if (path != null) {
            try {
                is = new FileInputStream(path.toFile());
            }
            catch (FileNotFoundException e) {
                LOGGER.error(e.getLocalizedMessage());
            }
            return is;
        }
        LOGGER.error("Path is null in AbstractMmlFileReader#getFile");
        return null;
    }

    private static byte[] decode(String dSection, long c) throws MMLParseException {
        CRC32 crc = new CRC32();
        crc.update(dSection.getBytes());
        if (c != crc.getValue()) {
            throw new MMLParseException("invalid c=" + c + " <> " + crc.getValue());
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] b = decoder.decode(dSection);
        int dataLength = ByteBuffer.wrap(b, 0, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        byte[] data = new byte[dataLength];
        int readLength = 0;
        try {
            BZip2CompressorInputStream bz2istream = new BZip2CompressorInputStream((InputStream)new ByteArrayInputStream(b, 12, b.length - 12));
            readLength = bz2istream.read(data);
            bz2istream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        LOGGER.debug("byte[] decode: dataLength {}, readLength {}", (Object)dataLength, (Object)readLength);
        int i = 0;
        while (i < dataLength) {
            StringBuilder out = new StringBuilder();
            for (int k = 0; k < 25 && i < dataLength; ++k) {
                out.append(String.format("%02x ", data[i++]));
            }
            String line = out.toString();
            LOGGER.debug(line);
        }
        return data;
    }

    private void parseSection(List<SectionContents> contentsList) throws MMLParseException {
        for (SectionContents contents : contentsList) {
            if (contents.getName().equals("[3MLE EXTENSION]")) {
                this.trackList = this.parse3mleExtension(contents.getContents());
                continue;
            }
            if (contents.getName().matches("\\[Channel[0-9]*\\]")) {
                this.mmlParts.add(contents.getContents().replaceAll("//.*\n", "\n").replaceAll("/\\*/?([^/]|[^*]/)*\\*/", "").replaceAll("[ \t\n]", ""));
                continue;
            }
            if (!contents.getName().equals("[Settings]")) continue;
            this.parseSettings(contents.getContents());
        }
    }

    private void createTrack() {
        for (Extension3mleTrack track : this.trackList) {
            int program = track.getInstrument() - 1;
            LOGGER.debug("Program: {}", (Object)program);
            String[] text = new String[160];
            ArrayList<MXTuneStaff> staves = new ArrayList<MXTuneStaff>();
            for (int i = 0; i < track.getTrackCount(); ++i) {
                text[i] = this.mmlParts.pop();
                staves.add(new MXTuneStaff(i, text[i]));
                LOGGER.debug("text[{}]= {}", (Object)i, (Object)text[i]);
            }
            String meta = String.format("%s, program %d", track.getTrackName(), program);
            String soundProxyID = Map3MLEInstruments.getSoundFontProxyName(program);
            int packedPreset = SoundFontProxyManager.getPackedPreset(soundProxyID);
            MXTunePart mxTunePart = new MXTunePart(soundProxyID, meta, packedPreset, staves);
            this.mxTuneFile.getParts().add(mxTunePart);
        }
    }

    private void parseSettings(String contents) {
        TextParser.text(contents).pattern("Title=", this.mxTuneFile::setTitle).pattern("Source=", this.mxTuneFile::setSource).pattern("Encoding=", t -> {
            this.encoding = t;
        }).parse();
    }

    private List<Extension3mleTrack> parse3mleExtension(String str) throws MMLParseException {
        StringBuilder sb = new StringBuilder();
        long c = 0L;
        for (String s : str.split("\n")) {
            if (s.startsWith("d=")) {
                sb.append(s.substring(2));
                continue;
            }
            if (!s.startsWith("c=")) continue;
            c = Long.parseLong(s.substring(2));
        }
        byte[] data = MMLFile.decode(sb.toString(), c);
        return this.parseData(data);
    }

    private List<Extension3mleTrack> parseData(byte[] data) {
        LinkedList<Extension3mleTrack> extension3mleTracks = new LinkedList<Extension3mleTrack>();
        extension3mleTracks.add(new Extension3mleTrack(-1, -1, -1, null, 0));
        ByteArrayInputStream istream = new ByteArrayInputStream(data);
        int b = 0;
        int hb = 0;
        while ((b = istream.read()) != -1) {
            if (hb == 18 && b == 16) {
                this.parseHeader(istream);
            } else if (hb == 2 && b == 28) {
                this.parseTrack(extension3mleTracks, istream);
            } else if (hb == 9 && b > 0 && b < 32) {
                this.parseMarker(istream);
            }
            hb = b;
        }
        extension3mleTracks.removeFirst();
        return extension3mleTracks;
    }

    private void parseHeader(ByteArrayInputStream istream) {
        long skipped = istream.skip(37L);
        int len = this.readLEIntValue(istream);
        long lenSkipped = istream.skip(len);
        LOGGER.debug("parseHeader: skipping 37 bytes. Actual={}, OK={}. Skipping {} bytes to track data.", (Object)skipped, (Object)(37L == skipped ? 1 : 0), (Object)len);
        LOGGER.debug("parseHeader: skipping {} bytes. Actual={}, OK={}", (Object)len, (Object)lenSkipped, (Object)((long)len == lenSkipped ? 1 : 0));
    }

    private void parseTrack(LinkedList<Extension3mleTrack> trackList, ByteArrayInputStream istream) {
        long skips = istream.skip(3L);
        int trackNo = istream.read();
        skips += istream.skip(1L);
        int panpot = istream.read();
        skips += istream.skip(5L);
        int startMarker = istream.read();
        skips += istream.skip(7L);
        int instrument = istream.read();
        skips += istream.skip(3L);
        int group = istream.read();
        String trackName = this.readString(istream);
        LOGGER.debug("parseTrack: skips expected 32, skips actual {}, OK={}", (Object)(skips += istream.skip(13L)), (Object)(32L == skips ? 1 : 0));
        LOGGER.debug("{} {} {}", (Object)trackNo, (Object)instrument, (Object)trackName);
        Extension3mleTrack lastTrack = trackList.getLast();
        if (lastTrack.getGroup() != group || lastTrack.getInstrument() != instrument || lastTrack.getPanpot() != panpot || lastTrack.isLimit()) {
            trackList.add(new Extension3mleTrack(instrument, group, panpot, trackName, startMarker));
        } else {
            lastTrack.addTrack();
        }
    }

    private int readLEIntValue(InputStream istream) {
        byte[] b = new byte[4];
        try {
            istream.read(b);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        return ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private void parseMarker(ByteArrayInputStream istream) {
        long skips = istream.skip(7L);
        int tickOffset = this.readLEIntValue(istream);
        String name = this.readString(istream);
        LOGGER.debug("parseMarker: skips expected 11, skips actual {}, OK={}", (Object)(skips += istream.skip(4L)), (Object)(11L == skips ? 1 : 0));
        LOGGER.debug("Marker {}={}", (Object)name, (Object)tickOffset);
    }

    private String readString(InputStream istream) {
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        try {
            int b;
            while ((b = istream.read()) != 0) {
                ostream.write(b);
            }
            return new String(ostream.toByteArray(), this.encoding);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return "";
        }
    }

    public static void main(String[] args) {
        try {
            String str = "c=3902331007\nd=4wAAAJvYl0oBAAAAQlpoOTFBWSZTWReDTXYAAEH/i/7U0AQCAHgAQAAEAGwIEABAAECAAAoABKAAcivUCaZGmRiAyNqDEgnqRpkPTUZGh5S6QfOGHRg+AfSJE3ebNDxInstECT3owI1yYiuIY5IwTCLAQz1oZyAogJFOhVYmv39cWsLxsbh0MkELhClECHm5wCBjLYz8XckU4UJAXg012A==";
            MMLFile mmlFile = new MMLFile();
            List<Extension3mleTrack> trackList = mmlFile.parse3mleExtension(str);
            for (Extension3mleTrack track : trackList) {
                LOGGER.debug((Object)track);
            }
        }
        catch (MMLParseException e) {
            LOGGER.error((Object)e);
        }
    }
}

