/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.parser;

import net.aeronica.libs.mml.parser.MMLUtil;

public class InstState {
    private int tempo;
    private int instrument;
    private long longestPart;
    private int minVolume = 127;
    private int maxVolume = 0;
    private boolean volumeArcheAge = false;
    private int perform = 0;
    private int sustain = 0;

    InstState() {
        this.init();
        this.longestPart = 0L;
    }

    public void init() {
        this.tempo = 120;
        this.instrument = 0;
    }

    public int getTempo() {
        return this.tempo;
    }

    public void setTempo(int tempo) {
        this.tempo = tempo < 32 || tempo > 255 ? 120 : tempo;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setInstrument(int preset) {
        this.instrument = MMLUtil.clamp(0, 99999, preset);
    }

    public int getPerform() {
        return this.perform;
    }

    public void setPerform(int perform) {
        this.perform = perform;
    }

    public int getSustain() {
        return this.sustain;
    }

    public void setSustain(int sustain) {
        this.sustain = sustain;
    }

    void collectDurationTicks(long durationTicks) {
        if (durationTicks > this.longestPart) {
            this.longestPart = durationTicks;
        }
    }

    long getLongestDurationTicks() {
        return this.longestPart;
    }

    public String toString() {
        return "@InstState: tempo=" + this.tempo + ", instrument=" + this.instrument + ", LongestDurationTicks= " + this.longestPart;
    }

    void collectVolume(int volumeIn) {
        int volume = MMLUtil.clamp(0, 127, volumeIn);
        if (volume > 15) {
            this.volumeArcheAge = true;
        }
        this.minVolume = Math.min(this.minVolume, volume);
        this.maxVolume = Math.max(this.maxVolume, volume);
    }

    int getMinVolume() {
        return this.volumeArcheAge ? this.minVolume : this.minVolume * 127 / 15;
    }

    int getMaxVolume() {
        return this.volumeArcheAge ? this.maxVolume : this.maxVolume * 127 / 15;
    }
}

