/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.network;

import com.westeroscraft.westerosblocks.network.WBPacket;
import com.westeroscraft.westerosblocks.network.WesterosBlocksChannelHandler;
import com.westeroscraft.westerosblocks.network.WesterosBlocksMessageDest;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class BlockMsgPacket
extends WBPacket {
    public short blockID;
    public byte[] msgdata;

    public BlockMsgPacket() {
    }

    public BlockMsgPacket(int blkid, byte[] dat) {
        this.blockID = (short)blkid;
        this.msgdata = dat;
    }

    @Override
    public void readData(ByteBuf data) {
        this.blockID = data.readShort();
        int cnt = data.readableBytes();
        this.msgdata = new byte[cnt];
        data.readBytes(this.msgdata);
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeShort((int)this.blockID);
        data.writeBytes(this.msgdata);
    }

    @Override
    public void processPacket(INetHandler handler, EntityPlayer player) {
        Block blk = Block.func_149729_e((int)this.blockID);
        if (blk != null && blk instanceof WesterosBlocksMessageDest) {
            ((WesterosBlocksMessageDest)blk).deliverMessage(handler, player, this.msgdata);
        }
    }

    public static void sendBlockMessage(Block blk, EntityPlayerMP player, byte msgid, byte[] data) {
        byte[] blkmsg = new byte[1 + data.length];
        blkmsg[0] = msgid;
        System.arraycopy(data, 0, blkmsg, 1, data.length);
        int blkid = Block.func_149682_b((Block)blk);
        BlockMsgPacket pkt = new BlockMsgPacket(blkid, blkmsg);
        WesterosBlocksChannelHandler.sendToPlayer(pkt, player);
    }
}

