/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.FireBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;

public class VinesBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public VinesBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        WesterosBlockDef.Subblock sb = def.subBlocks.get(0);
        VinesBlockModelExport.addNLSString("tile." + def.blockName + ".name", sb.label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        String m = "westerosblocks:" + this.def.blockName;
        Conditions cond = new Conditions();
        cond.when.south = "true";
        cond.apply.model = m + "_1";
        so.multipart.add(cond);
        cond = new Conditions();
        cond.when.west = "true";
        cond.apply.model = m + "_1";
        cond.apply.y = 90;
        so.multipart.add(cond);
        cond = new Conditions();
        cond.when.north = "true";
        cond.apply.model = m + "_1";
        cond.apply.y = 180;
        so.multipart.add(cond);
        cond = new Conditions();
        cond.when.east = "true";
        cond.apply.model = m + "_1";
        cond.apply.y = 270;
        so.multipart.add(cond);
        cond = new Conditions();
        cond.when.up = "true";
        cond.apply.model = m + "_u";
        so.multipart.add(cond);
        cond = new Conditions();
        cond.when.down = "true";
        cond.apply.model = m + "_u";
        cond.apply.x = 180;
        so.multipart.add(cond);
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        WesterosBlockDef.Subblock sb = this.def.subBlocks.get(0);
        String txt = VinesBlockModelExport.getTextureID(sb.getTextureByIndex(0));
        String txt2 = VinesBlockModelExport.getTextureID(sb.getTextureByIndex(1));
        if (!sb.isCustomModel()) {
            ModelObject mo1 = new ModelObject("1", txt);
            this.writeBlockModelFile(this.def.blockName + "_1", mo1);
            ModelObject mou = new ModelObject("u", txt2);
            this.writeBlockModelFile(this.def.blockName + "_u", mou);
        }
        ItemModelObject mo = new ItemModelObject();
        mo.textures.layer0 = txt;
        this.writeItemModelFile(this.def.blockName, mo);
    }

    public static class ItemModelObject {
        public String parent = "item/generated";
        public FireBlockModelExport.TextureLayer0 textures = new FireBlockModelExport.TextureLayer0();
    }

    public static class Texture {
        public String vines;
    }

    public static class ModelObject {
        public String parent;
        public Texture textures = new Texture();

        ModelObject(String ext, String txt) {
            this.parent = "westerosblocks:block/vines/vine_" + ext;
            this.textures.vines = txt;
        }
    }

    public static class Variant {
        public String model;
        public Integer y;

        Variant(String m, int y) {
            this.model = m;
            if (y != 0) {
                this.y = y;
            }
        }
    }

    public static class Conditions {
        public CondVal when = new CondVal();
        public CondModel apply = new CondModel();
    }

    public static class CondModel {
        public String model;
        public Integer x;
        public Integer y;
    }

    public static class CondVal {
        public String north;
        public String south;
        public String east;
        public String west;
        public String up;
        public String down;
    }

    public static class StateObject {
        public ArrayList<Conditions> multipart = new ArrayList();
    }
}

