/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class TrapDoorBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public TrapDoorBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        TrapDoorBlockModelExport.addNLSString("tile." + def.blockName + ".name", def.subBlocks.get((int)0).label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        String bn = this.def.blockName;
        so.variants.put("facing=north,half=bottom,open=false", new Variant(bn, "bottom", 0));
        so.variants.put("facing=south,half=bottom,open=false", new Variant(bn, "bottom", 0));
        so.variants.put("facing=east,half=bottom,open=false", new Variant(bn, "bottom", 0));
        so.variants.put("facing=west,half=bottom,open=false", new Variant(bn, "bottom", 0));
        so.variants.put("facing=north,half=top,open=false", new Variant(bn, "top", 0));
        so.variants.put("facing=south,half=top,open=false", new Variant(bn, "top", 0));
        so.variants.put("facing=east,half=top,open=false", new Variant(bn, "top", 0));
        so.variants.put("facing=west,half=top,open=false", new Variant(bn, "top", 0));
        so.variants.put("facing=north,half=bottom,open=true", new Variant(bn, "open", 0));
        so.variants.put("facing=south,half=bottom,open=true", new Variant(bn, "open", 180));
        so.variants.put("facing=east,half=bottom,open=true", new Variant(bn, "open", 90));
        so.variants.put("facing=west,half=bottom,open=true", new Variant(bn, "open", 270));
        so.variants.put("facing=north,half=top,open=true", new Variant(bn, "open", 0));
        so.variants.put("facing=south,half=top,open=true", new Variant(bn, "open", 180));
        so.variants.put("facing=east,half=top,open=true", new Variant(bn, "open", 90));
        so.variants.put("facing=west,half=top,open=true", new Variant(bn, "open", 270));
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        WesterosBlockDef.Subblock sb = this.def.subBlocks.get(0);
        String txt = TrapDoorBlockModelExport.getTextureID(sb.getTextureByIndex(0));
        ModelObjectTrapdoorBottom modb = new ModelObjectTrapdoorBottom();
        modb.textures.texture = txt;
        this.writeBlockModelFile(this.def.blockName + "_bottom", modb);
        ModelObjectTrapdoorTop modt = new ModelObjectTrapdoorTop();
        modt.textures.texture = txt;
        this.writeBlockModelFile(this.def.blockName + "_top", modt);
        ModelObjectTrapdoorOpen modo = new ModelObjectTrapdoorOpen();
        modo.textures.texture = txt;
        this.writeBlockModelFile(this.def.blockName + "_open", modo);
        ModelObject mo = new ModelObject();
        mo.parent = "westerosblocks:block/" + this.def.blockName + "_bottom";
        this.writeItemModelFile(this.def.blockName, mo);
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Texture {
        public String texture;
    }

    public static class ModelObjectTrapdoorOpen {
        public String parent = "block/trapdoor_open";
        public Texture textures = new Texture();
    }

    public static class ModelObjectTrapdoorTop {
        public String parent = "block/trapdoor_top";
        public Texture textures = new Texture();
    }

    public static class ModelObjectTrapdoorBottom {
        public String parent = "block/trapdoor_bottom";
        public Texture textures = new Texture();
    }

    public static class Variant {
        public String model;
        public Integer y;

        public Variant(String blkname, String ext, int yrot) {
            this.model = "westerosblocks:" + blkname + "_" + ext;
            if (yrot != 0) {
                this.y = yrot;
            }
        }
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

