/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.BedBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.CakeBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.CropBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.CrossBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.CuboidBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.CuboidNEBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.CuboidNEStackBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.CuboidNSEWBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.CuboidNSEWStackBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.CuboidNSEWUDBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.DoorBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.FenceBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.FireBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.FurnaceBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.HalfDoorBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.LadderBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.LayerBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.LeavesBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.LogBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import com.westeroscraft.westerosblocks.modelexport.PaneBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.RailBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.SlabBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.SolidBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.StairsBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.TorchBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.TrapDoorBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.VinesBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.WallBlockModelExport;
import java.io.File;
import net.minecraft.block.Block;

public class ModelExportFactory {
    public static ModelExport forBlock(Block blk, WesterosBlockDef def, File dest) {
        ModelExport me = null;
        switch (def.blockType) {
            case "solid": 
            case "soulsand": 
            case "sound": 
            case "sand": {
                me = new SolidBlockModelExport(blk, def, dest);
                break;
            }
            case "stair": {
                me = new StairsBlockModelExport(blk, def, dest);
                break;
            }
            case "leaves": {
                me = new LeavesBlockModelExport(blk, def, dest);
                break;
            }
            case "log": {
                me = new LogBlockModelExport(blk, def, dest);
                break;
            }
            case "plant": 
            case "web": {
                me = new CrossBlockModelExport(blk, def, dest);
                break;
            }
            case "pane": {
                me = new PaneBlockModelExport(blk, def, dest);
                break;
            }
            case "crop": {
                me = new CropBlockModelExport(blk, def, dest);
                break;
            }
            case "door": {
                me = new DoorBlockModelExport(blk, def, dest);
                break;
            }
            case "slab": {
                me = new SlabBlockModelExport(blk, def, dest);
                break;
            }
            case "fence": {
                me = new FenceBlockModelExport(blk, def, dest);
                break;
            }
            case "wall": {
                me = new WallBlockModelExport(blk, def, dest);
                break;
            }
            case "trapdoor": {
                me = new TrapDoorBlockModelExport(blk, def, dest);
                break;
            }
            case "torch": {
                me = new TorchBlockModelExport(blk, def, dest);
                break;
            }
            case "ladder": {
                me = new LadderBlockModelExport(blk, def, dest);
                break;
            }
            case "fire": {
                me = new FireBlockModelExport(blk, def, dest);
                break;
            }
            case "bed": {
                me = new BedBlockModelExport(blk, def, dest);
                break;
            }
            case "cuboid": 
            case "beacon": {
                me = new CuboidBlockModelExport(blk, def, dest);
                break;
            }
            case "cuboid-ne": {
                me = new CuboidNEBlockModelExport(blk, def, dest);
                break;
            }
            case "cuboid-ne-stack": {
                me = new CuboidNEStackBlockModelExport(blk, def, dest);
                break;
            }
            case "cuboid-nsew": {
                me = new CuboidNSEWBlockModelExport(blk, def, dest);
                break;
            }
            case "cuboid-nsew-stack": {
                me = new CuboidNSEWStackBlockModelExport(blk, def, dest);
                break;
            }
            case "cuboid-nsewud": {
                me = new CuboidNSEWUDBlockModelExport(blk, def, dest);
                break;
            }
            case "layer": {
                me = new LayerBlockModelExport(blk, def, dest);
                break;
            }
            case "rail": {
                me = new RailBlockModelExport(blk, def, dest);
                break;
            }
            case "halfdoor": {
                me = new HalfDoorBlockModelExport(blk, def, dest);
                break;
            }
            case "cake": {
                me = new CakeBlockModelExport(blk, def, dest);
                break;
            }
            case "furnace": {
                me = new FurnaceBlockModelExport(blk, def, dest);
                break;
            }
            case "vines": {
                me = new VinesBlockModelExport(blk, def, dest);
            }
        }
        return me;
    }
}

