/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.commands;

import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.network.PWeatherCmdMsgPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class PWeatherCommand
implements ICommand {
    private final List<String> aliases = new ArrayList<String>();
    private static PWEATHER_SETTING weather_setting = PWEATHER_SETTING.RESET;
    private static World weather_world = null;
    private static boolean saved_raining = false;
    private static float saved_rain_strength = 0.0f;
    private static float saved_thunder_strength = 0.0f;

    public PWeatherCommand() {
        this.aliases.add("pweather");
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public String func_71517_b() {
        return "pweather";
    }

    public String func_71518_a(ICommandSender sender) {
        return "pweather [reset|sun|clear|storm|thunder]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        if (!world.field_72995_K) {
            if (sender instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                if (args.length != 1) {
                    throw new WrongUsageException("Requires one argument", new Object[0]);
                }
                PWEATHER_SETTING setting = PWEATHER_SETTING.RESET;
                switch (args[0]) {
                    case "reset": {
                        setting = PWEATHER_SETTING.RESET;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Resetting player weather to match server weather"));
                        break;
                    }
                    case "clear": 
                    case "sun": {
                        setting = PWEATHER_SETTING.CLEAR;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Setting player weather to CLEAR"));
                        break;
                    }
                    case "rain": 
                    case "storm": {
                        setting = PWEATHER_SETTING.RAIN;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Setting player weather to RAIN"));
                        break;
                    }
                    case "thunder": {
                        setting = PWEATHER_SETTING.THUNDER;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Setting player weather to THUNDER"));
                        break;
                    }
                    default: {
                        throw new WrongUsageException("Invalid argument - " + args[0], new Object[0]);
                    }
                }
                PWeatherCmdMsgPacket.sendCmdMessage(player, setting);
            } else {
                WesterosBlocks.log.info("Command only usable by player");
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public static void setWeatherSetting(PWEATHER_SETTING setting, World world) {
        if (weather_setting != PWEATHER_SETTING.RESET) {
            if (world != null && world == weather_world) {
                world.func_72912_H().func_76084_b(saved_raining);
                world.func_72894_k(saved_rain_strength);
                world.func_147442_i(saved_thunder_strength);
            }
            weather_world = null;
            weather_setting = PWEATHER_SETTING.RESET;
        }
        if (setting != PWEATHER_SETTING.RESET && world != null) {
            weather_world = world;
            saved_raining = world.func_72912_H().func_76059_o();
            saved_rain_strength = world.func_72867_j(0.0f);
            saved_thunder_strength = world.func_72819_i(0.0f);
            world.func_72912_H().func_76084_b(setting != PWEATHER_SETTING.CLEAR);
            world.func_72894_k(setting == PWEATHER_SETTING.CLEAR ? 0.0f : 1.0f);
            world.func_147442_i(setting == PWEATHER_SETTING.THUNDER ? 1.0f : 0.0f);
            weather_setting = setting;
        }
    }

    public static void processChangeGameState(SPacketChangeGameState pkt) {
        if (weather_world != null && weather_setting != PWEATHER_SETTING.RESET) {
            switch (pkt.field_149140_b) {
                case 1: {
                    saved_raining = true;
                    saved_rain_strength = 0.0f;
                    break;
                }
                case 2: {
                    saved_raining = false;
                    saved_rain_strength = 1.0f;
                    break;
                }
                case 7: {
                    saved_rain_strength = pkt.field_149141_c;
                    break;
                }
                case 8: {
                    saved_thunder_strength = pkt.field_149141_c;
                }
            }
            if (weather_setting == PWEATHER_SETTING.CLEAR) {
                pkt.field_149140_b = 2;
                pkt.field_149141_c = 0.0f;
            } else {
                pkt.field_149140_b = 1;
                pkt.field_149141_c = 0.0f;
            }
        }
    }

    public static enum PWEATHER_SETTING {
        RESET,
        CLEAR,
        RAIN,
        THUNDER;

    }
}

