/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.PatchBlockModel;
import org.dynmap.renderer.RenderPatchFactory;

public class WCVinesBlock
extends BlockVine
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private WesterosBlockDef def;
    private boolean allow_unsupported = false;
    private boolean no_climb = false;
    private boolean has_down = false;
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    protected WCVinesBlock(WesterosBlockDef def) {
        this.def = def;
        def.doStandardContructorSettings((Block)this);
        this.func_149675_a(false);
        String t = def.getType(0);
        if (t != null) {
            String[] toks;
            for (String tok : toks = t.split(",")) {
                if (tok.equals("allow-unsupported")) {
                    this.allow_unsupported = true;
                }
                if (tok.equals("no-climb")) {
                    this.no_climb = true;
                }
                if (!tok.equals("has-down")) continue;
                this.has_down = true;
            }
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176277_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176273_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176278_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176279_N, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176280_O, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, ItemBlock.class);
        return true;
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        String blkname = this.def.getBlockName(0);
        this.def.defaultRegisterTextures(mtd);
        this.def.registerPatchTextureBlock(mtd, 2);
        for (int meta = 0; meta < 16; ++meta) {
            PatchBlockModel mod = md.addPatchModel(blkname);
            if ((meta & 1) != 0) {
                mod.addPatch(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.BOTH);
            }
            if ((meta & 2) != 0) {
                mod.addPatch(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.BOTH);
            }
            if ((meta & 4) != 0) {
                mod.addPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, RenderPatchFactory.SideVisible.BOTH);
            }
            if ((meta & 8) != 0) {
                mod.addPatch(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.BOTH);
            }
            if (meta == 0) {
                mod.addPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH);
            }
            mod.setMetaValue(meta);
        }
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState bs = worldIn.func_180495_p(pos);
        if (bs.func_177230_c() == this && this.allow_unsupported) {
            return true;
        }
        return super.func_176198_a(worldIn, pos, facing);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState bs = worldIn.func_180495_p(pos);
        if (bs.func_177230_c() == this && this.allow_unsupported) {
            return;
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return !this.no_climb;
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176277_a, field_176273_b, field_176278_M, field_176279_N, field_176280_O, DOWN});
    }

    public int func_176201_c(IBlockState state) {
        if (this.has_down && ((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            return 0;
        }
        return super.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        if (this.has_down && meta == 0) {
            return this.func_176223_P().func_177226_a((IProperty)DOWN, (Comparable)Boolean.TRUE);
        }
        return super.func_176203_a(meta);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.has_down && ((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockPos blockpos = pos.func_177978_c();
            state = state.func_177226_a((IProperty)field_176273_b, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos).func_193401_d(worldIn, blockpos, EnumFacing.SOUTH) == BlockFaceShape.SOLID));
            blockpos = pos.func_177968_d();
            state = state.func_177226_a((IProperty)field_176279_N, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos).func_193401_d(worldIn, blockpos, EnumFacing.NORTH) == BlockFaceShape.SOLID));
            blockpos = pos.func_177974_f();
            state = state.func_177226_a((IProperty)field_176278_M, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos).func_193401_d(worldIn, blockpos, EnumFacing.WEST) == BlockFaceShape.SOLID));
            blockpos = pos.func_177976_e();
            state = state.func_177226_a((IProperty)field_176280_O, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos).func_193401_d(worldIn, blockpos, EnumFacing.EAST) == BlockFaceShape.SOLID));
            blockpos = pos.func_177984_a();
            state = state.func_177226_a((IProperty)field_176277_a, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos).func_193401_d(worldIn, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID));
            return state;
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(0);
            if (!def.validateMetaValues(new int[]{0}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCVinesBlock(def)};
        }
    }
}

