/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.WCSlabItem;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.BoxBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCSlabBlock
extends BlockSlab
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private static PropertyMeta new_variant;
    private static boolean glob_is_double;
    private static final int HALF_IDX = 0;
    private static final int FULL_IDX = 1;
    private WesterosBlockDef def;
    private WCSlabBlock otherBlock;
    private boolean is_double;
    private PropertyMeta variant;

    protected WCSlabBlock(WesterosBlockDef def, boolean is_double) {
        super(def.getMaterial());
        this.is_double = is_double;
        this.def = def;
        if (def.lightOpacity == -999) {
            def.lightOpacity = 255;
        }
        def.doStandardContructorSettings((Block)this, is_double ? 1 : 0);
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        if (is_double) {
            this.func_149647_a(null);
        } else {
            this.field_149783_u = true;
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(iblockstate.func_177226_a((IProperty)this.variant, (Comparable)this.variant.fromMeta(0)));
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        if (this.is_double) {
            WCSlabItem.setSlabs(this.otherBlock, this);
            this.def.doStandardRegisterActions((Block)this, WCSlabItem.class, 1);
        } else {
            WCSlabItem.setSlabs(this, this.otherBlock);
            this.def.doStandardRegisterActions((Block)this, WCSlabItem.class, 0);
        }
        return true;
    }

    public IProperty<?> func_176551_l() {
        return this.variant;
    }

    public IBlockState func_176203_a(int meta) {
        if (this.func_176552_j()) {
            return this.func_176223_P().func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(meta & 7));
        }
        return this.func_176223_P().func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(meta & 7)).func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    public int func_176201_c(IBlockState state) {
        Integer var = (Integer)state.func_177229_b((IProperty)this.variant);
        if (this.func_176552_j()) {
            return var;
        }
        return (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 8 : 0) + var;
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.is_double) {
            this.def.getStandardCreativeItems((Block)this, tab, list);
        }
    }

    public String func_150002_b(int meta) {
        return "tile." + this.def.getBlockName(0) + "_" + (meta & 7);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        this.def.defaultRegisterTextures(mtd);
        if (!this.is_double) {
            String blkname = this.def.getBlockName(0);
            this.def.defaultRegisterTextureBlock(mtd, 0, TransparencyMode.SEMITRANSPARENT);
            BoxBlockModel bottom = md.addBoxModel(blkname);
            bottom.setYRange(0.0, 0.5);
            BoxBlockModel top = md.addBoxModel(blkname);
            top.setYRange(0.5, 1.0);
            for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
                bottom.setMetaValue(sb.meta);
                top.setMetaValue(sb.meta | 8);
            }
        } else {
            this.def.defaultRegisterTextureBlock(mtd, 1, null);
        }
    }

    public boolean func_176552_j() {
        return this.is_double | glob_is_double;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return this.variant.fromMeta(stack.func_77960_j() & 7);
    }

    protected BlockStateContainer func_180661_e() {
        if (new_variant != null) {
            this.variant = new_variant;
            new_variant = null;
        }
        if (this.func_176552_j()) {
            return new BlockStateContainer((Block)this, new IProperty[]{this.variant});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, this.variant});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        return state.func_185914_p();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.func_176552_j()) {
            return Item.func_150898_a((Block)this.otherBlock);
        }
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)(this.func_176552_j() ? this.otherBlock : this), 1, ((Integer)state.func_177229_b((IProperty)this.variant)).intValue());
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176203_a(meta);
        if (this.func_176552_j()) {
            return iblockstate;
        }
        iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(7);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, null)) {
                return null;
            }
            PropertyMeta new_var = PropertyMeta.create("variant", def.getDefinedBaseMeta());
            def.setBlockIDCount(2);
            glob_is_double = false;
            new_variant = new_var;
            WCSlabBlock half = new WCSlabBlock(def, false);
            glob_is_double = true;
            new_variant = new_var;
            WCSlabBlock full = new WCSlabBlock(def, true);
            glob_is_double = false;
            half.otherBlock = full;
            full.otherBlock = half;
            return new Block[]{half, full};
        }
    }
}

