/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.items.WCLayerItem;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.BoxBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCLayerBlock
extends Block
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    protected static PropertyInteger new_layers = null;
    private WesterosBlockDef def;
    public int layerCount;
    public PropertyInteger layers;

    private static int getLayerCount(WesterosBlockDef def) {
        int layerCount = 8;
        int off = def.type.indexOf("cnt:");
        if (off >= 0) {
            try {
                layerCount = Integer.parseInt(def.type.substring(off + 4));
            }
            catch (NumberFormatException nfx) {
                WesterosBlocks.log.info("Error parsing 'cnt:' in " + def.blockName);
            }
        }
        if (layerCount < 2) {
            layerCount = 2;
        }
        if (layerCount > 16) {
            layerCount = 16;
        }
        return layerCount;
    }

    protected WCLayerBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.def = def;
        this.layerCount = WCLayerBlock.getLayerCount(def);
        this.func_149672_a(def.getSoundType());
        def.doStandardContructorSettings(this);
        for (int i = 0; i < this.layerCount; ++i) {
            this.setBlockBoundsForMeta(i);
        }
    }

    private void setBlockBoundsForMeta(int meta) {
        int j = meta % this.layerCount;
        float f = (float)(1 + j) / (float)this.layerCount;
        this.def.setBoundingBox(meta, 0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions(this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, WCLayerItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems(this, tab, list);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return (Integer)state.func_177229_b((IProperty)this.layers) + 1;
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)this.layers) <= this.layerCount / 2;
    }

    public boolean func_185481_k(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.layers) == this.layerCount;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        int i = (Integer)blockState.func_177229_b((IProperty)this.layers) - 1;
        float f = 1.0f / (float)this.layerCount;
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(worldIn, pos);
        return new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, (double)((float)i * f), axisalignedbb.field_72334_f);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        WesterosBlockDef.BoundingBox bb = this.def.getBoundingBox(state, source, pos);
        return new AxisAlignedBB((double)bb.xMin, (double)bb.yMin, (double)bb.zMin, (double)bb.xMax, (double)bb.yMax, (double)bb.zMax);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    protected BlockStateContainer func_180661_e() {
        if (new_layers != null) {
            this.layers = new_layers;
            new_layers = null;
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.layers});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.layers, (Comparable)Integer.valueOf(meta + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.layers) - 1;
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        String blkname = this.def.getBlockName(0);
        this.def.defaultRegisterTextures(mtd);
        this.def.defaultRegisterTextureBlock(mtd, 0, TransparencyMode.TRANSPARENT, this.layerCount);
        for (int i = 0; i < this.layerCount; ++i) {
            BoxBlockModel mod = md.addBoxModel(blkname);
            mod.setYRange(0.0, (double)(i + 1) / (double)this.layerCount);
            mod.setMetaValue(i);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(0);
            if (!def.validateMetaValues(new int[]{0}, new int[]{0})) {
                return null;
            }
            new_layers = PropertyInteger.func_177719_a((String)"layers", (int)1, (int)WCLayerBlock.getLayerCount(def));
            return new Block[]{new WCLayerBlock(def)};
        }
    }
}

