/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.CuboidBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TextureModifier;
import org.dynmap.modsupport.TransparencyMode;

public class WCHalfDoorBlock
extends Block
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    private WesterosBlockDef def;
    private boolean locked = false;

    protected WCHalfDoorBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.def = def;
        def.doStandardContructorSettings(this);
        String type = def.getType(0);
        if (type != null) {
            String[] toks;
            for (String tok : toks = type.split(",")) {
                String[] flds = tok.split(":");
                if (flds.length < 2 || !flds[0].equals("locked")) continue;
                this.locked = flds[1].equals("true");
            }
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions(this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, ItemBlock.class);
        return true;
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems(this, tab, list);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private int getIconIndex(int meta, int side) {
        boolean flag1 = false;
        if (side != 1 && side != 0) {
            boolean flag;
            int direction = meta & 3;
            boolean bl = flag = (meta & 4) != 0;
            if (flag) {
                if (direction == 0 && side == 2) {
                    flag1 = !flag1;
                } else if (direction == 1 && side == 5) {
                    flag1 = !flag1;
                } else if (direction == 2 && side == 3) {
                    flag1 = !flag1;
                } else if (direction == 3 && side == 4) {
                    flag1 = !flag1;
                }
            } else {
                if (direction == 0 && side == 5) {
                    flag1 = !flag1;
                } else if (direction == 1 && side == 3) {
                    flag1 = !flag1;
                } else if (direction == 2 && side == 4) {
                    flag1 = !flag1;
                } else if (direction == 3 && side == 2) {
                    boolean bl2 = flag1 = !flag1;
                }
                if ((meta & 8) != 0) {
                    flag1 = !flag1;
                }
            }
        }
        return flag1 ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDoor.field_176520_a, BlockDoor.field_176519_b, BlockDoor.field_176521_M});
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        String blkname = this.def.getBlockName(0);
        this.def.defaultRegisterTextures(mtd);
        WesterosBlockDef.Subblock sb = this.def.getByMeta(0);
        if (sb == null || sb.textures == null || sb.textures.size() == 0) {
            return;
        }
        String txt = sb.textures.get(0);
        BlockTextureRecord btr = mtd.addBlockTextureRecord(blkname);
        btr.setTransparencyMode(TransparencyMode.TRANSPARENT);
        btr.setPatchTexture(txt, TextureModifier.NONE, 0);
        btr.setPatchTexture(txt, TextureModifier.FLIPHORIZ, 1);
        this.def.setBlockColorMap(btr, sb);
        block6: for (int meta = 0; meta < 16; ++meta) {
            CuboidBlockModel mod = md.addCuboidModel(blkname);
            mod.setMetaValue(meta);
            int[] txtids = new int[]{this.getIconIndex(meta, 0), this.getIconIndex(meta, 1), this.getIconIndex(meta, 2), this.getIconIndex(meta, 3), this.getIconIndex(meta, 4), this.getIconIndex(meta, 5)};
            switch (meta) {
                case 0: 
                case 7: 
                case 8: 
                case 13: {
                    mod.addCuboid(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0, txtids);
                    continue block6;
                }
                case 1: 
                case 4: 
                case 9: 
                case 14: {
                    mod.addCuboid(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875, txtids);
                    continue block6;
                }
                case 3: 
                case 6: 
                case 11: 
                case 12: {
                    mod.addCuboid(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0, txtids);
                    continue block6;
                }
                case 2: 
                case 5: 
                case 10: 
                case 15: {
                    mod.addCuboid(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0, txtids);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a))).func_177231_a((IProperty)BlockDoor.field_176521_M);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState bs = this.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f());
        bs = bs.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)((meta & 8) > 0 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT));
        return bs.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT) {
            i |= 8;
        }
        i |= ((EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a)).func_176746_e().func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockDoor.field_176519_b);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.locked) {
            return false;
        }
        state = state.func_177231_a((IProperty)BlockDoor.field_176519_b);
        worldIn.func_180501_a(pos, state, 10);
        worldIn.func_175704_b(pos, pos);
        worldIn.func_180498_a(playerIn, (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        return true;
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing;
        IBlockState state = this.func_176203_a(meta & 3);
        switch (facing) {
            case DOWN: {
                enumfacing = EnumFacing.func_176733_a((double)((double)placer.field_70177_z + 180.0));
                break;
            }
            case UP: {
                enumfacing = EnumFacing.func_176733_a((double)((double)placer.field_70177_z + 180.0));
                break;
            }
            default: {
                enumfacing = facing;
            }
        }
        int i = enumfacing.func_82601_c();
        int j = enumfacing.func_82599_e();
        boolean isRightHinge = i < 0 && hitZ < 0.5f || i > 0 && hitZ > 0.5f || j < 0 && hitX > 0.5f || j > 0 && hitX < 0.5f;
        return state.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)enumfacing).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(isRightHinge ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        boolean flag = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b) == false;
        boolean flag1 = state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT;
        switch (enumfacing) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag = worldIn.func_175640_z(pos);
        if (blockIn != this && (flag || blockIn.func_176223_P().func_185897_m()) && flag != (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(flag)), 2);
            worldIn.func_175704_b(pos, pos);
            worldIn.func_180498_a((EntityPlayer)null, flag ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(0);
            if (!def.validateMetaValues(new int[]{0}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCHalfDoorBlock(def)};
        }
    }
}

