/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import com.westeroscraft.westerosblocks.network.WesterosBlocksMessageDest;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import com.westeroscraft.westerosblocks.tileentity.WCFurnaceTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.ModTextureDefinition;

public class WCFurnaceBlock
extends BlockFurnace
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport,
WesterosBlocksMessageDest {
    protected static PropertyMeta new_variant = null;
    private WesterosBlockDef def;
    private boolean[] alwaysOn = new boolean[2];
    private PropertyMeta variant;
    private static PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    protected WCFurnaceBlock(WesterosBlockDef def) {
        super(false);
        this.def = def;
        def.doStandardContructorSettings((Block)this);
        for (int i = 0; i < 2; ++i) {
            String[] toks;
            String type = def.getType(i);
            if (type == null) continue;
            for (String tok : toks = type.split(",")) {
                String[] flds = tok.split(":");
                if (flds.length < 2 || !flds[0].equals("always-on")) continue;
                this.alwaysOn[i] = flds[1].equals("true");
            }
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176447_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems((Block)this, tab, list);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean active;
        boolean bl = active = this.alwaysOn[(Integer)state.func_177229_b((IProperty)this.variant)] || (Boolean)state.func_177229_b((IProperty)LIT) != false;
        if (active) {
            return this.def.getLightValue(state, world, pos);
        }
        return 0;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        boolean active;
        this.def.randomDisplayTick(stateIn, worldIn, pos, rand);
        int var = (Integer)stateIn.func_177229_b((IProperty)this.variant);
        boolean lit = (Boolean)stateIn.func_177229_b((IProperty)LIT);
        boolean bl = active = this.alwaysOn[var] || lit;
        if (active) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)field_176447_a);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
            }
        }
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        this.def.defaultRegisterTextures(mtd);
        this.def.defaultRegisterTextureBlock(mtd);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new WCFurnaceTileEntity();
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        WCFurnaceBlock blk = (WCFurnaceBlock)iblockstate.func_177230_c();
        int var = (Integer)iblockstate.func_177229_b((IProperty)blk.variant);
        iblockstate = iblockstate.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(active || blk.alwaysOn[var]));
        worldIn.func_180501_a(pos, iblockstate, 3);
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)((meta >> 1 & 3) + 2));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        int var = meta & 1;
        return this.func_176223_P().func_177226_a((IProperty)field_176447_a, (Comparable)enumfacing).func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(var)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)field_176447_a)).func_176745_a() - 2 << 1;
        int var = (Integer)state.func_177229_b((IProperty)this.variant);
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta |= 8;
        }
        return meta += var;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int var = (Integer)state.func_177229_b((IProperty)this.variant);
        if (this.alwaysOn[var]) {
            state = state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        if (new_variant != null) {
            this.variant = new_variant;
            new_variant = null;
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.variant, field_176447_a, LIT});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof WCFurnaceTileEntity) {
            playerIn.func_71007_a((IInventory)((WCFurnaceTileEntity)tileentity));
            playerIn.func_71029_a(StatList.field_188061_aa);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public void deliverMessage(INetHandler handler, EntityPlayer player, byte[] msg) {
        System.out.println("WCFurnaceBlock.deliverMessage()");
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int var = meta & 1;
        boolean lit = this.alwaysOn[var];
        return this.func_176223_P().func_177226_a((IProperty)field_176447_a, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(var)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((Integer)state.func_177229_b((IProperty)this.variant)).intValue());
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant);
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(1);
            if (!def.validateMetaValues(new int[]{0, 1}, null)) {
                return null;
            }
            new_variant = PropertyMeta.create("variant", def.getDefinedBaseMeta());
            def.registerTileEntity(WCFurnaceTileEntity.class, "westerosblocks:WCFurnaceTileEntity");
            return new Block[]{new WCFurnaceBlock(def)};
        }
    }
}

