/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.blocks.WCCuboidBlock;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.dynmap.modsupport.CuboidBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCCuboidNSEWUDBlock
extends WCCuboidBlock
implements WesterosBlockLifecycle {
    private List<WesterosBlockDef.Cuboid>[] cuboids_by_meta = new List[16];
    private static final List<EnumFacing> VALIDFACING = new ArrayList<EnumFacing>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EnumFacing.EAST);
            this.add(EnumFacing.SOUTH);
            this.add(EnumFacing.WEST);
            this.add(EnumFacing.NORTH);
            this.add(EnumFacing.DOWN);
            this.add(EnumFacing.UP);
        }
    };
    public static final PropertyDirection FACING = PropertyDirection.func_177713_a((String)"facing", VALIDFACING);

    protected WCCuboidNSEWUDBlock(WesterosBlockDef def) {
        super(def);
        this.meta_per_sub = 6;
        for (int i = 0; i < 2; ++i) {
            List<WesterosBlockDef.Cuboid> lst = def.getCuboidList(i);
            if (lst == null) continue;
            this.cuboids_by_meta[i] = lst;
            this.cuboids_by_meta[i + 2] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 4] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 6] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 8] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 10] = new ArrayList<WesterosBlockDef.Cuboid>();
            for (WesterosBlockDef.Cuboid c : lst) {
                this.cuboids_by_meta[i + 2].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY90));
                this.cuboids_by_meta[i + 4].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY180));
                this.cuboids_by_meta[i + 6].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY270));
                this.cuboids_by_meta[i + 8].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTZ90));
                this.cuboids_by_meta[i + 10].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTZ270));
            }
            this.setBoundingBoxFromCuboidList(i);
            this.setBoundingBoxFromCuboidList(i + 2);
            this.setBoundingBoxFromCuboidList(i + 4);
            this.setBoundingBoxFromCuboidList(i + 6);
            this.setBoundingBoxFromCuboidList(i + 8);
            this.setBoundingBoxFromCuboidList(i + 10);
        }
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, MultiBlockItem.class);
        return true;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        if (new_variant != null) {
            this.variant = new_variant;
            new_variant = null;
        }
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, this.variant});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(meta & 1)).func_177226_a((IProperty)FACING, (Comparable)VALIDFACING.get(meta >> 1));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant) + (VALIDFACING.indexOf(state.func_177229_b((IProperty)FACING)) << 1);
    }

    @Override
    public List<WesterosBlockDef.Cuboid> getCuboidList(int meta) {
        return this.cuboids_by_meta[meta];
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176203_a(meta & 1);
        return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((Integer)state.func_177229_b((IProperty)this.variant)).intValue());
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant);
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        WesterosBlockDef def = this.getWBDefinition();
        String blkname = def.getBlockName(0);
        def.defaultRegisterTextures(mtd);
        def.registerPatchTextureBlock(mtd, 6, TransparencyMode.TRANSPARENT, this.meta_per_sub);
        for (int meta = 0; meta < 15; ++meta) {
            List<WesterosBlockDef.Cuboid> cl = this.cuboids_by_meta[meta];
            if (cl == null) continue;
            CuboidBlockModel mod = md.addCuboidModel(blkname);
            for (WesterosBlockDef.Cuboid c : cl) {
                if ("crossed".equals(c.shape)) {
                    mod.addCrossedPatches((double)c.xMin, (double)c.yMin, (double)c.zMin, (double)c.xMax, (double)c.yMax, (double)c.zMax, c.sideTextures[0]);
                    continue;
                }
                mod.addCuboid((double)c.xMin, (double)c.yMin, (double)c.zMin, (double)c.xMax, (double)c.yMax, (double)c.zMax, c.sideTextures);
            }
            mod.setMetaValue(meta);
        }
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(1);
            if (!def.validateMetaValues(new int[]{0, 1}, new int[]{0})) {
                return null;
            }
            WCCuboidBlock.new_variant = PropertyMeta.create("variant", def.getDefinedBaseMeta());
            return new Block[]{new WCCuboidNSEWUDBlock(def)};
        }
    }
}

