/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.blocks.WCCuboidBlock;
import com.westeroscraft.westerosblocks.blocks.WCCuboidNEBlock;
import com.westeroscraft.westerosblocks.items.WCCuboidNEStackItem;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WCCuboidNEStackBlock
extends WCCuboidNEBlock
implements WesterosBlockLifecycle {
    public static PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private boolean[] noBreakUnder = new boolean[4];

    protected WCCuboidNEStackBlock(WesterosBlockDef def) {
        super(def);
        if (def.subBlocks != null) {
            for (WesterosBlockDef.Subblock sb : def.subBlocks) {
                String[] toks;
                String type;
                if ((sb.meta & 1) != 0 || (type = def.getType(sb.meta)) == null) continue;
                for (String tok : toks = type.split(",")) {
                    if (!tok.equals("no-break-under")) continue;
                    this.noBreakUnder[sb.meta >> 1 & 3] = true;
                }
            }
        }
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, WCCuboidNEStackItem.class);
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int var = (Integer)state.func_177229_b((IProperty)this.variant);
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            BlockPos blockposbottom = pos.func_177977_b();
            IBlockState statebottom = worldIn.func_180495_p(blockposbottom);
            if (statebottom.func_177230_c() != this || state.func_177229_b((IProperty)this.variant) != statebottom.func_177229_b((IProperty)this.variant)) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                statebottom.func_189546_a(worldIn, blockposbottom, blockIn, fromPos);
            }
        } else {
            boolean didBreak = false;
            BlockPos blockpostop = pos.func_177984_a();
            IBlockState statetop = worldIn.func_180495_p(blockpostop);
            if (statetop.func_177230_c() != this || state.func_177229_b((IProperty)this.variant) != statetop.func_177229_b((IProperty)this.variant)) {
                worldIn.func_175698_g(pos);
                didBreak = true;
            }
            if (!this.noBreakUnder[var] && !worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
                worldIn.func_175698_g(pos);
                didBreak = true;
                if (statetop.func_177230_c() == this) {
                    worldIn.func_175698_g(blockpostop);
                }
            }
            if (didBreak && !worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return pos.func_177956_o() >= worldIn.func_72800_K() - 1 ? false : worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        if (new_variant != null) {
            this.variant = new_variant;
            new_variant = null;
        }
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TOP, this.variant});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf((meta & 6) >> 1)).func_177226_a((IProperty)FACING, (Comparable)((meta & 8) != 0 ? EnumFacing.NORTH : EnumFacing.EAST)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf((meta & 1) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((Integer)state.func_177229_b((IProperty)this.variant) << 1) + (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH ? 8 : 0) + ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 1 : 0);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @Override
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, (Integer)state.func_177229_b((IProperty)this.variant) << 1);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant) << 1;
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(7);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, new int[]{0, 1})) {
                return null;
            }
            if (def.subBlocks != null) {
                int matches = 0;
                for (WesterosBlockDef.Subblock sb : def.subBlocks) {
                    if ((sb.meta & 1) == 1) {
                        sb.noInventoryItem = true;
                    }
                    matches |= 1 << sb.meta;
                }
                block4: for (int i = 0; i < 4; ++i) {
                    switch (matches >> 2 * i) {
                        case 0: 
                        case 3: {
                            continue block4;
                        }
                        default: {
                            WesterosBlocks.log.error(String.format("unmatched stacked subblocks %d in block '%s'", 2 * i, def.blockType));
                            return null;
                        }
                    }
                }
            }
            List<Integer> metalist = def.getDefinedBaseMeta();
            ArrayList<Integer> variant_list = new ArrayList<Integer>();
            for (Integer id : metalist) {
                if (id % 2 != 0) continue;
                variant_list.add(id / 2);
            }
            WCCuboidBlock.new_variant = PropertyMeta.create("variant", variant_list);
            return new Block[]{new WCCuboidNEStackBlock(def)};
        }
    }
}

