/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.westeroscraft.westerosblocks.DynmapSupport;
import com.westeroscraft.westerosblocks.Proxy;
import com.westeroscraft.westerosblocks.WesterosBlockConfig;
import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocksCreativeTab;
import com.westeroscraft.westerosblocks.asm.ClassTransformer;
import com.westeroscraft.westerosblocks.commands.PTimeCommand;
import com.westeroscraft.westerosblocks.commands.PWeatherCommand;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import com.westeroscraft.westerosblocks.modelexport.ModelExportFactory;
import com.westeroscraft.westerosblocks.network.PacketHandler;
import com.westeroscraft.westerosblocks.network.WesterosBlocksChannelHandler;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.crash.CrashReport;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="westerosblocks", name="WesterosBlocks", version="4.3.4-126", acceptedMinecraftVersions="[1.12.2]")
public class WesterosBlocks {
    public static final String MOD_ID = "westerosblocks";
    public static Logger log = LogManager.getLogger((String)"westerosblocks");
    @Mod.Instance(value="westerosblocks")
    public static WesterosBlocks instance;
    @SidedProxy(clientSide="com.westeroscraft.westerosblocks.ClientProxy", serverSide="com.westeroscraft.westerosblocks.Proxy")
    public static Proxy proxy;
    public DynmapSupport dynmap = null;
    public static Block[] customBlocks;
    public static HashMap<String, Block> customBlocksByName;
    public boolean blockDevMode = false;
    public boolean snowInTaiga = false;
    public boolean publishToDynmap = false;
    public static WesterosBlockConfig customConfig;
    public static WesterosBlockDef[] customBlockDefs;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    public boolean good_init = false;
    public File modcfgdir = null;
    private static HashMap<String, SoundEvent> registered_sounds;

    public static Block findBlockByName(String blkname) {
        Block blk = customBlocksByName.get(blkname);
        if (blk != null) {
            return blk;
        }
        try {
            return Block.func_149684_b((String)blkname);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static void crash(Exception x, String msg) {
        CrashReport crashreport = CrashReport.func_85055_a((Throwable)x, (String)msg);
        throw new ReportedException(crashreport);
    }

    public static void crash(String msg) {
        WesterosBlocks.crash(new Exception(), msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        int i;
        WesterosBlockDef.initialize();
        WesterosBlocksCreativeTab.init();
        InputStream in = this.getClass().getResourceAsStream("/WesterosBlocks.json");
        if (in == null) {
            WesterosBlocks.crash("WesterosBlocks couldn't find its block definition resource");
            return;
        }
        InputStreamReader rdr = new InputStreamReader(in);
        Gson gson = new Gson();
        try {
            customConfig = (WesterosBlockConfig)gson.fromJson((Reader)rdr, WesterosBlockConfig.class);
            customBlockDefs = WesterosBlocks.customConfig.blocks;
        }
        catch (JsonSyntaxException iox) {
            WesterosBlocks.crash((Exception)((Object)iox), "WesterosBlocks couldn't parse its block definition");
            return;
        }
        catch (JsonIOException iox) {
            WesterosBlocks.crash((Exception)((Object)iox), "WesterosBlocks couldn't read its block definition");
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException iOException) {}
                rdr = null;
            }
        }
        log.info("Loaded " + customBlockDefs.length + " block definitions");
        if (!WesterosBlockDef.sanityCheck(customBlockDefs)) {
            WesterosBlocks.crash("WesterosBlocks.json failed sanity check");
            return;
        }
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            this.snowInTaiga = cfg.get("Settings", "snowInTaiga", true).getBoolean(true);
            this.blockDevMode = cfg.get("Settings", "blockDevMode", false).getBoolean(false);
            this.publishToDynmap = cfg.get("Settings", "publishToDynmap", false).getBoolean(false);
            this.good_init = true;
        }
        catch (Exception e) {
            WesterosBlocks.crash(e, "WesterosBlocks couldn't load its configuration");
        }
        finally {
            cfg.save();
        }
        if (this.snowInTaiga) {
            Biomes.field_76768_g.field_76750_F = -0.5f;
            log.info("Enabled snow in TAIGA");
        }
        this.modcfgdir = new File(event.getModConfigurationDirectory(), MOD_ID);
        this.modcfgdir.mkdirs();
        if (this.blockDevMode) {
            log.info("Block dev mode enabled : block export processing will be done to " + this.modcfgdir + "/assets/" + MOD_ID);
        }
        ArrayList<Block> blklist = new ArrayList<Block>();
        customBlocksByName = new HashMap();
        for (int i2 = 0; i2 < customBlockDefs.length; ++i2) {
            if (customBlockDefs[i2] == null) continue;
            Block[] blks = customBlockDefs[i2].createBlocks();
            if (blks != null) {
                for (int j = 0; j < blks.length; ++j) {
                    ModelExport exp;
                    Block blk = blks[j];
                    blklist.add(blk);
                    customBlocksByName.put(customBlockDefs[i2].getBlockName(j), blk);
                    if (!this.blockDevMode || (exp = ModelExportFactory.forBlock(blk, customBlockDefs[i2], this.modcfgdir)) == null) continue;
                    try {
                        exp.doBlockStateExport();
                        exp.doModelExports();
                        continue;
                    }
                    catch (IOException iox) {
                        log.warn(String.format("Error exporting block %s - %s", blk.func_149739_a(), iox));
                    }
                }
                customBlockDefs[i2].registerSoundEvents();
                continue;
            }
            WesterosBlocks.crash("Invalid block definition for " + WesterosBlocks.customBlockDefs[i2].blockName + " - aborted during load()");
            return;
        }
        customBlocks = blklist.toArray(new Block[blklist.size()]);
        if (this.blockDevMode) {
            try {
                ModelExport.writeNLSFile(this.modcfgdir);
            }
            catch (IOException iox) {
                log.warn(String.format("Error writing NLS - %s", iox));
            }
            try {
                ModelExport.writeDynmapOverridesFile(this.modcfgdir);
            }
            catch (IOException iox) {
                log.warn(String.format("Error writing Dynmap Overrides - %s", iox));
            }
        }
        WesterosBlockDef.processRegisterTileEntities();
        for (i = 0; i < customBlocks.length; ++i) {
            if (!(customBlocks[i] instanceof WesterosBlockLifecycle)) continue;
            ((WesterosBlockLifecycle)customBlocks[i]).initializeBlockDefinition();
        }
        for (i = 0; i < customBlocks.length; ++i) {
            if (!(customBlocks[i] instanceof WesterosBlockLifecycle)) continue;
            ((WesterosBlockLifecycle)customBlocks[i]).registerBlockDefinition();
        }
        proxy.registerBlockModels(customBlocks);
        proxy.initRenderRegistry();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!this.good_init) {
            WesterosBlocks.crash("preInit failed - aborting load()");
            return;
        }
        proxy.registerColoring();
        channels = NetworkRegistry.INSTANCE.newChannel("WesterosBlocks", new ChannelHandler[]{new WesterosBlocksChannelHandler(), new PacketHandler()});
        try {
            this.handleDynmap();
        }
        catch (NoClassDefFoundError x) {
            log.info("Dynmap Mod Support API not found");
            this.dynmap = null;
        }
        try {
            this.migrateRP();
        }
        catch (IOException e) {
            log.info("Migrate RP failed");
        }
        proxy.initCleanupHooks();
    }

    private void handleDynmap() {
        if (!this.publishToDynmap) {
            return;
        }
        this.dynmap = new DynmapSupport(MOD_ID, "4.3.4-126");
        if (this.dynmap.getTextureDef() == null) {
            return;
        }
        for (int i = 0; i < customBlocks.length; ++i) {
            if (customBlocks[i] instanceof WesterosBlockDynmapSupport) {
                ((WesterosBlockDynmapSupport)customBlocks[i]).registerDynmapRenderData(this.dynmap.getTextureDef());
                continue;
            }
            log.info("No Dynmap render support for blockID=" + customBlocks[i].func_149739_a());
        }
        this.dynmap.complete();
    }

    public static SoundEvent registerSound(String soundName) {
        SoundEvent event = registered_sounds.get(soundName);
        if (event == null) {
            ResourceLocation location = new ResourceLocation(MOD_ID, soundName);
            event = new SoundEvent(location);
            event.setRegistryName(location);
            ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
            registered_sounds.put(soundName, event);
        }
        return event;
    }

    private void migrateRP() throws IOException {
        File f = new File(this.modcfgdir, "westeroscraft/assets/minecraft/mcpatcher/ctm");
        if (!f.exists()) {
            return;
        }
        HashMap<Integer, String> id_to_name = new HashMap<Integer, String>();
        final HashMap name_to_id = new HashMap();
        for (int id = 0; id < 4096; ++id) {
            Block b = Block.func_149729_e((int)id);
            if (b == null || b == Blocks.field_150350_a) continue;
            id_to_name.put(id, b.getRegistryName().toString());
            name_to_id.put(id_to_name.get(id), id);
            log.info(String.format("%d=%s", id, id_to_name.get(id)));
        }
        HashMap moved_files = new HashMap();
        Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fn = file.getFileName().toString();
                if (fn.endsWith(".properties")) {
                    String line;
                    FileReader fis = new FileReader(file.toString());
                    LineNumberReader rdr = new LineNumberReader(fis);
                    ArrayList<String> lines = new ArrayList<String>();
                    int match_id = -1;
                    while ((line = rdr.readLine()) != null) {
                        String[] parts = line.split("=");
                        if (parts.length > 1 && parts[0].trim().equalsIgnoreCase("matchBlocks")) {
                            String matching = parts[1].trim();
                            if (name_to_id.containsKey(matching)) {
                                match_id = (Integer)name_to_id.get(matching);
                                log.info(String.format("%s: found matchBlocks = %s(%d)", file.toString(), matching, match_id));
                                lines.add("#" + line);
                                continue;
                            }
                            lines.add(line);
                            continue;
                        }
                        lines.add(line);
                    }
                    rdr.close();
                    fis.close();
                    int blockfileid = -1;
                    int blocknameoff = 0;
                    if (fn.startsWith("block")) {
                        int blkid = 0;
                        blocknameoff = 5;
                        while (Character.isDigit(fn.charAt(blocknameoff))) {
                            blkid = 10 * blkid + (fn.charAt(blocknameoff) - 48);
                            ++blocknameoff;
                        }
                        log.info(String.format("%s: inferred blockid = %d", file.toString(), blkid));
                        blockfileid = blkid;
                    }
                    if (match_id >= 0) {
                        FileWriter fw = new FileWriter(file.toFile());
                        for (String l : lines) {
                            fw.write(l.trim() + "\n");
                        }
                        fw.close();
                    }
                    if (match_id > 0 && blockfileid != match_id) {
                        String newfn = "block" + match_id + fn.substring(blocknameoff);
                        Files.move(file, file.resolveSibling(newfn), new CopyOption[0]);
                        log.info(String.format("%s: renamed to %s", file.toString(), newfn));
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        try {
            Class.forName("wdl.WDL");
            WesterosBlocks.crash("****** WorldDownloader not supported!!!!!! ******");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (event.getSide().isServer()) {
            event.registerServerCommand((ICommand)new PTimeCommand());
            event.registerServerCommand((ICommand)new PWeatherCommand());
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (this.blockDevMode) {
            log.info("--- Transform Status --- ");
            HashMap<String, ClassTransformer.TransformState> m = ClassTransformer.patchState;
            for (Map.Entry<String, ClassTransformer.TransformState> x : m.entrySet()) {
                log.info("Transform " + x.getKey() + "=" + x.getValue().toString());
            }
            log.info("--- Transform Status Done --- ");
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        if (this.blockDevMode) {
            log.info("--- Transform Status --- ");
            HashMap<String, ClassTransformer.TransformState> m = ClassTransformer.patchState;
            for (Map.Entry<String, ClassTransformer.TransformState> x : m.entrySet()) {
                log.info("Transform " + x.getKey() + "=" + x.getValue().toString());
            }
            log.info("--- Transform Status Done --- ");
        }
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
    }

    static {
        registered_sounds = new HashMap();
    }
}

