/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.common.block.TileAutoChisel;

@ParametersAreNonnullByDefault
public class ContainerAutoChisel
extends Container {
    public final InventoryPlayer invPlayer;
    public final TileAutoChisel te;
    private final int beginInputSlots;
    private final int endInputSlots;
    public final int chiselSlot;
    public final int targetSlot;
    private final int beginOutputSlots;
    private final int endOutputSlots;
    private final int beginPlayerSlots;
    private final int endPlayerSlots;
    private int progress;
    private int power;

    public ContainerAutoChisel(InventoryPlayer invPlayer, TileAutoChisel te) {
        int i;
        this.invPlayer = invPlayer;
        this.te = te;
        int yStart = 19;
        this.chiselSlot = 0;
        this.func_75146_a((Slot)new SlotItemHandler(te.getOtherInv(), 0, 80, yStart + 9){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                return stack != null && stack.func_77973_b() instanceof IChiselItem;
            }
        });
        this.targetSlot = 1;
        this.func_75146_a((Slot)new ChiselableSlot(te.getOtherInv(), 1, 80, 54 + yStart - 9));
        this.beginInputSlots = this.field_75151_b.size();
        IItemHandler inv = te.getInputInv();
        for (i = 0; i < inv.getSlots(); ++i) {
            this.func_75146_a((Slot)new ChiselableSlot(inv, i, 8 + 18 * (i % 3), yStart + 18 * (i / 3)));
        }
        this.endInputSlots = this.beginOutputSlots = this.field_75151_b.size();
        inv = te.getOutputInv();
        for (i = 0; i < inv.getSlots(); ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(inv, i, 116 + 18 * (i % 3), yStart + 18 * (i / 3)){

                public boolean func_75214_a(@Nullable ItemStack stack) {
                    return false;
                }
            });
        }
        this.beginPlayerSlots = this.endOutputSlots = this.field_75151_b.size();
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.func_75146_a(new Slot((IInventory)invPlayer, c + r * 9 + 9, 8 + c * 18, 118 + r * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)invPlayer, i, 8 + i * 18, 176));
        }
        this.endPlayerSlots = this.field_75151_b.size();
    }

    public void func_75142_b() {
        super.func_75142_b();
        int prog = this.te.getProgress();
        IEnergyStorage energy = (IEnergyStorage)this.te.getCapability(CapabilityEnergy.ENERGY, null);
        int pow = energy == null ? 0 : energy.getEnergyStored();
        for (IContainerListener listener : this.field_75149_d) {
            if (prog != this.progress) {
                listener.func_71112_a((Container)this, 0, prog);
            }
            if (pow == this.power) continue;
            listener.func_71112_a((Container)this, 1, pow);
        }
        this.progress = prog;
        this.power = pow;
    }

    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        if (id == 0) {
            this.te.setProgress(data);
        } else if (id == 1) {
            this.te.setEnergy(data);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.te.func_145831_w().func_175625_s(this.te.func_174877_v()) != this.te ? false : this.invPlayer.field_70458_d.func_174831_c(this.te.func_174877_v()) <= 64.0;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index >= this.beginOutputSlots && index < this.endOutputSlots) {
                if (!this.func_75135_a(itemstack1, this.beginPlayerSlots, this.endPlayerSlots, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= this.beginPlayerSlots ? (CarvingUtils.getChiselRegistry().getGroup(itemstack1) != null ? !this.func_75135_a(itemstack1, this.targetSlot, this.targetSlot + 1, false) && !this.func_75135_a(itemstack1, this.beginInputSlots, this.endInputSlots, false) : (itemstack1.func_77973_b() instanceof IChiselItem ? !this.func_75135_a(itemstack1, this.chiselSlot, this.chiselSlot + 1, false) : (index >= this.beginPlayerSlots && index < this.endPlayerSlots - 9 ? !this.func_75135_a(itemstack1, this.endPlayerSlots - 9, this.endPlayerSlots, false) : index >= this.endPlayerSlots - 9 && index < this.endPlayerSlots && !this.func_75135_a(itemstack1, 3, 30, false)))) : !this.func_75135_a(itemstack1, this.beginPlayerSlots, this.endPlayerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    private static class ChiselableSlot
    extends SlotItemHandler {
        public ChiselableSlot(IItemHandler inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nullable ItemStack stack) {
            return stack != null && CarvingUtils.getChiselRegistry().getGroup(stack) != null;
        }
    }
}

