/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.util.BookwormUtils;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.entity.core.IMultiSpeciesEntity;
import org.zawamod.entity.general.EntityZAWAEgg;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.DataItem;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;
import org.zawamod.util.status.StatusSunSeeking;

public class EntityRattleSnake
extends AbstractZawaLand
implements IMultiSpeciesEntity {
    public static final int WALK = 0;
    public static final int THREATEN = 1;

    public EntityRattleSnake(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        if (this.field_70170_p.field_72995_K) {
            Animation walk = new Animation(new BookwormModelBase[]{RenderConstants.RATTLESNAKE, RenderConstants.RATTLESNAKE_SLITHER, RenderConstants.RATTLESNAKE_DEFAULT, RenderConstants.RATTLESNAKE_SLITHER_2, RenderConstants.RATTLESNAKE_DEFAULT});
            walk.hasLoop = true;
            walk.speed = 0.2f;
            Animation threaten = new Animation(new BookwormModelBase[]{RenderConstants.RATTLESNAKE_THREATEN_3, RenderConstants.RATTLESNAKE_THREATEN_1, RenderConstants.RATTLESNAKE_THREATEN_2, RenderConstants.RATTLESNAKE_THREATEN_1, RenderConstants.RATTLESNAKE_THREATEN_3});
            threaten.speed = 0.3f;
            threaten.hasLoop = true;
            this.getAnimator().addAnimation(0, walk);
            this.getAnimator().addAnimation(1, threaten);
        }
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.RATTLE_SNAKE;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ZAWASounds.RATTLESNAKE;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Animation getSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.RATTLESNAKE, RenderConstants.RATTLESNAKE_SLEEPING});
    }

    @Override
    @Nullable
    public Animation getChildSleepAnimation() {
        return this.getSleepAnimation();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.26));
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f - 0.1f;
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StatusSunSeeking());
        return new DataItem(s);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        if (!BookwormUtils.isEntityMoving((Entity)this) && !this.isAsleep() && this.func_70638_az() == null && this.field_70170_p.func_72890_a((Entity)this, 7.0) != null) {
            if (this.getAnimator().isPlaying(0)) {
                this.getAnimator().stopAnimation();
            }
            this.getAnimator().play(1);
        } else {
            if (this.getAnimator().isPlaying(1)) {
                this.getAnimator().stopAnimation();
            }
            if (BookwormUtils.isEntityMoving((Entity)this)) {
                if (!this.getAnimator().isPlaying(0)) {
                    this.getAnimator().play(0);
                }
            } else if (this.getAnimator().isPlaying(0)) {
                this.getAnimator().stopAnimation();
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity e) {
        if (e instanceof EntityLiving) {
            ((EntityLiving)e).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 30, 1));
        }
        return super.func_70652_k(e);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityZAWAEgg((Entity)this);
    }

    @Override
    public Map<Integer, String> speciesData() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(0, "Diamondback");
        data.put(1, "Aruba Island");
        data.put(2, "Pygmy");
        data.put(3, "Timber");
        data.put(4, "Mojave");
        data.put(5, "Black Tailed");
        return data;
    }
}

