/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.configuration.spawn;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SpawnableData {
    public final Class<? extends EntityLiving> entity;
    public final String name;
    public final int chance;
    public final int min;
    public final int max;
    public String[] biomes;
    public final boolean enabled;
    public final EnumCreatureType type;

    public SpawnableData(Class<? extends EntityLiving> entity, String name, int chance, int min, int max, boolean enabled, EnumCreatureType type, String ... biomes) {
        this.entity = entity;
        this.name = name;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.biomes = biomes;
        this.enabled = enabled;
        this.type = type;
    }

    public String toString() {
        return "SpawnableData{entity=" + this.entity + ", name='" + this.name + '\'' + ", chance=" + this.chance + ", min=" + this.min + ", max=" + this.max + ", biomes=" + Arrays.toString(this.biomes) + ", enabled=" + this.enabled + ", type=" + this.type + '}';
    }

    public List<Biome> getBiomes() {
        ArrayList biomes = Lists.newArrayList();
        for (String bo : this.biomes) {
            ResourceLocation ro = new ResourceLocation(bo);
            if (!ForgeRegistries.BIOMES.containsKey(ro)) continue;
            biomes.add(ForgeRegistries.BIOMES.getValue(ro));
        }
        return biomes;
    }
}

