/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityCoati;
import org.zawamod.entity.land.EntityEchidna;
import org.zawamod.entity.land.EntityTasmanianDevil;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderTasmanianDevil
extends RenderLivingZAWA<EntityTasmanianDevil>
implements IBabyModel<EntityTasmanianDevil> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderTasmanianDevil(RenderManager m) {
        super(m, (ModelBase)RenderConstants.TASMANIAN_DEVIL, 0.3f);
        RenderConstants.TASMANIAN_DEVIL.setAnimator(TasmanianAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityTasmanianDevil entity) {
        return entity.func_70631_g_() ? CONTAINER.get("blink", 3) : CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    protected void preRenderCallback(EntityTasmanianDevil e, float partialTickTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)-0.13f, (float)0.0f);
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.13f, (float)0.0f);
        } else {
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.13f, (float)0.0f);
        }
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityTasmanianDevil entity) {
        return CONTAINER.get(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.TASMANIAN_DEVIL_BABY.setAnimator(TasmanianAnimator::new);
        return RenderConstants.TASMANIAN_DEVIL_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityTasmanianDevil e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/tasmanian_devil/tasmanian_devil.png");
        CONTAINER.addResource("textures/entity/tasmanian_devil/tasmanian_devil_2.png");
        CONTAINER.addResource("textures/entity/tasmanian_devil/tasmanian_devil_3.png");
        CONTAINER.addResource("baby", "textures/entity/tasmanian_devil/tasmanian_devil_baby.png");
        CONTAINER.addResource("blink", "textures/entity/tasmanian_devil/tdev_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/tasmanian_devil/tdev_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/tasmanian_devil/tdev_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/tasmanian_devil/tdev_blink_baby.png");
    }

    public static class TasmanianAnimator
    extends ZAWAAnimator<AbstractZawaLand> {
        protected final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        protected final BookwormModelRenderer neck = this.getModel().getPartFromRig("Neck");
        protected final BookwormModelRenderer tail2 = this.getModel().getPartFromRig("Tail2");
        protected final BookwormModelRenderer tail1 = this.getModel().getPartFromRig("Tail");
        protected final BookwormModelRenderer mouth = this.getModel().getPartFromRig("Jaw");
        protected final BookwormModelRenderer ArmBaseRight = this.getModel().getPartFromRig("ArmBaseRight");
        protected final BookwormModelRenderer ArmRight = this.getModel().getPartFromRig("ArmRight");
        protected final BookwormModelRenderer HandRight = this.getModel().getPartFromRig("HandRight");
        protected final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartFromRig("ArmBaseLeft");
        protected final BookwormModelRenderer ArmLeft = this.getModel().getPartFromRig("ArmLeft");
        protected final BookwormModelRenderer HandLeft = this.getModel().getPartFromRig("HandLeft");
        protected final BookwormModelRenderer ThighRight = this.getModel().getPartFromRig("ThighRight");
        protected final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("UpperLegRight");
        protected final BookwormModelRenderer FootRight = this.getModel().getPartFromRig("FootRight");
        protected final BookwormModelRenderer ThighLeft = this.getModel().getPartFromRig("ThighLeft");
        protected final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("UpperLegLeft");
        protected final BookwormModelRenderer FootLeft = this.getModel().getPartFromRig("FootLeft");

        public TasmanianAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            float x;
            float weight2;
            float weight;
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.degree = 0.4f;
            this.speed = 4.4f;
            this.neck.field_78795_f = f4 / 57.295776f - 0.2f;
            this.neck.field_78796_g = f3 / 57.295776f;
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.3162f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            if (!(entity instanceof EntityCoati)) {
                this.tail1.field_78808_h = MathHelper.func_76134_b((float)(10.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f;
                this.tail2.field_78808_h = MathHelper.func_76134_b((float)(21.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.9f) * f1 * 0.5f;
            }
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.2f;
            this.mouth.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.2f;
            this.ArmBaseRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.05f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 0.1f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.0f;
            this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ArmBaseLeft.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.05f;
            this.ArmBaseLeft.field_78795_f = -MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 0.1f;
            this.ArmLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.0f;
            this.HandLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            float f6 = entity.func_70631_g_() ? -0.1f : (weight = entity instanceof EntityTasmanianDevil ? 0.2f : -0.5f);
            float f7 = entity.func_70631_g_() ? -0.4f : (weight2 = entity instanceof EntityTasmanianDevil ? 0.1f : -0.1f);
            float f8 = entity.func_70631_g_() ? 0.045f : (x = entity instanceof EntityTasmanianDevil ? 0.0f : 0.15f);
            if (entity instanceof EntityEchidna) {
                x = 0.06f;
                weight = -0.1f;
            }
            this.ThighRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + x;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 3.3f) * f1 * 0.5f + weight;
            this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 1.6f) * f1 * 0.5f + weight2;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 0.6f) * f1 * 0.5f - 0.0f;
            this.ThighLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + x;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 3.3f) * f1 * 0.5f + weight;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 1.6f) * f1 * 0.5f + weight2;
            this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 0.5f - 0.0f;
        }
    }
}

