/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.RenderPolarBear;
import org.zawamod.client.render.entity.RenderSockeyeSalmon;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityGrizzlyBear;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderGrizzlyBear
extends RenderLivingZAWA<EntityGrizzlyBear>
implements IBabyModel<EntityGrizzlyBear> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderGrizzlyBear(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.BEAR.setAnimator(RenderPolarBear.PolarBearAnimator::new), 0.8f);
        this.func_177094_a(new LayerSalmon(this));
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityGrizzlyBear entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 0);
        }
        if (AbstractZawaLand.getVariant(entity) == 1 || AbstractZawaLand.getVariant(entity) == 2) {
            return CONTAINER.get("blink", 2);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    protected void preRenderCallback(EntityGrizzlyBear entitylivingbaseIn, float partialTickTime) {
        if (!entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.03f, (float)0.2f);
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)0.02f, (float)-0.1f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityGrizzlyBear animal) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.BEAR_BABY.setAnimator(BearAnimator::new);
    }

    @Override
    public ResourceLocation getBabyTexture(EntityGrizzlyBear e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/grizzly_bear/grizzly_bear_1.png");
        CONTAINER.addResource("textures/entity/grizzly_bear/grizzly_bear_2.png");
        CONTAINER.addResource("textures/entity/grizzly_bear/grizzly_bear_3.png");
        CONTAINER.addResource("textures/entity/grizzly_bear/grizzly_bear_4.png");
        CONTAINER.addResource("baby", "textures/entity/grizzly_bear/grizzly_bear_baby.png");
        CONTAINER.addResource("blink", "textures/entity/grizzly_bear/grizzly_bear_blink_baby.png");
        CONTAINER.addResource("blink", "textures/entity/grizzly_bear/grizzly_bear_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/grizzly_bear/grizzly_bear_blink_2_3.png");
        CONTAINER.addResource("blink", "textures/entity/grizzly_bear/grizzly_bear_blink_4.png");
    }

    public static class BearAnimator
    extends RenderBengalTiger.TigerAnimator {
        public BearAnimator(ModelCMF model, float extraWeight, float pressure) {
            this(model);
            this.extraWeight = extraWeight;
            this.pressure = pressure;
        }

        public BearAnimator(ModelCMF model) {
            super(model);
            this.neckWeight = 0.1f;
            this.pressure = -0.1f;
            this.extraWeight = -0.1f;
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.4f) * f1 * 0.5f - 0.2f;
            this.ArmLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.4f) * f1 * 0.5f - 0.2f;
            this.UpperLegRight.field_78795_f = MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.4f;
            this.UpperLegLeft.field_78795_f = -MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.4f;
            if (entity.isRunning()) {
                this.speed = 4.0f;
                this.degree = 0.3f;
                this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(5.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.9f) * f1 * 0.5f + -0.3f;
                this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(10.5f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.9f) * f1 * 0.5f + -0.3f;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerSalmon
    implements LayerRenderer<EntityGrizzlyBear> {
        private final RenderGrizzlyBear render;

        public LayerSalmon(RenderGrizzlyBear re) {
            this.render = re;
        }

        public void doRenderLayer(EntityGrizzlyBear bear, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (bear.getSalmon() && !bear.func_82150_aj() && !bear.func_70631_g_()) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)43.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)1.6f, (float)-1.5f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
                this.render.func_110776_a(RenderSockeyeSalmon.CONTAINER.get(0));
                RenderConstants.SOCKEYE_SALMON.func_178686_a(this.render.func_177087_b());
                RenderConstants.SOCKEYE_SALMON.func_78088_a((Entity)bear, f, f1, f3, f4, f5, f6);
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

