/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityGaur;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderGaur
extends RenderLivingZAWA<EntityGaur>
implements IBabyModel<EntityGaur> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderGaur(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.GAUR, 0.7f);
        RenderConstants.GAUR.setAnimator(GaurAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityGaur entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.65f, (float)0.0f);
            if (entitylivingbaseIn.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.35f, (float)0.0f);
            }
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityGaur entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 3);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    protected ResourceLocation getEntityTexture(EntityGaur animal) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.GAUR_BABY.setAnimator(GaurCAnimator::new);
        return RenderConstants.GAUR_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityGaur e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/gaur/gaur_1.png");
        CONTAINER.addResource("textures/entity/gaur/gaur_2.png");
        CONTAINER.addResource("textures/entity/gaur/gaur_3.png");
        CONTAINER.addResource("baby", "textures/entity/gaur/gaur_baby.png");
        CONTAINER.addResource("blink", "textures/entity/gaur/gaur_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/gaur/gaur_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/gaur/gaur_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/gaur/gaur_baby_blink.png");
    }

    public static class GaurAnimator
    extends RenderBengalTiger.TigerAnimator {
        public GaurAnimator(ModelCMF model) {
            super(model);
            this.extraWeight = 0.24f;
            this.neckWeight = -0.5f;
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            if (entity.func_70090_H()) {
                f = entity.field_70173_aa;
                f1 = 0.24f;
                this.speed = 2.0f;
                this.degree = 1.0f;
                this.tail1.field_78795_f = -1.0f;
                this.tail1.field_78796_g = MathHelper.func_76134_b((float)(f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f;
                this.tail2.field_78796_g = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.15f + (float)Math.PI)) * (this.degree * 1.0f) * f1 * 0.5f;
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + 0.3f;
                this.head.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - 0.3f;
            } else if (entity.isRunning()) {
                this.speed = 4.0f;
                this.degree = 0.3f;
                this.tail1.field_78795_f = -1.0f;
                this.tail2.field_78795_f = MathHelper.func_76134_b((float)(5.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.5f + 0.0f;
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(9.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.5f) * f1 * 0.5f + 0.3f;
                this.head.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.1f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - 0.3f;
            }
        }
    }

    public static class GaurCAnimator
    extends ZAWAAnimator<EntityGaur> {
        private final BookwormModelRenderer tight1 = this.getModel().getPartByName("tight1");
        private final BookwormModelRenderer tight2 = this.getModel().getPartByName("tight11");
        private final BookwormModelRenderer tight4 = this.getModel().getPartByName("tight31");
        private final BookwormModelRenderer tight3 = this.getModel().getPartByName("tight3");
        private final BookwormModelRenderer neck = this.getModel().getPartByName("neck");

        public GaurCAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGaur entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 1.5f;
            this.degree = 0.9f;
            this.tight1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f;
            this.tight2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * -2.1f) * f1 * 0.5f;
            this.tight4.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f;
            this.tight3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * -2.1f) * f1 * 0.5f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(12.0f + f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + 0.5f;
        }
    }
}

