/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.CMFRig;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityAfricanElephant;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderAfricanElephant
extends RenderLivingZAWA<EntityAfricanElephant>
implements IBabyModel<EntityAfricanElephant> {
    public static final ResourceLocation SADDLE = new ResourceLocation("zawa", "textures/entity/african_elephant/saddle.png");
    public static final ResourceLocation BLINK_1_3 = new ResourceLocation("zawa", "textures/entity/african_elephant/african_bush_elephant_blink_1_3.png");
    public static final ResourceLocation BLINK_2 = new ResourceLocation("zawa", "textures/entity/african_elephant/african_bush_elephant_blink_2.png");
    public static final ResourceLocation BLINK_4 = new ResourceLocation("zawa", "textures/entity/african_elephant/african_bush_elephant_blink_4.png");
    public static final ResourceLocation BLINK_BABY = new ResourceLocation("zawa", "textures/entity/african_elephant/african_bush_elephant_blink_baby.png");
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderAfricanElephant(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.AFRICAN_BUSH_ELEPHANT, 1.0f);
        this.func_177094_a(new LayerAfricanElephant(this));
        RenderConstants.AFRICAN_BUSH_ELEPHANT.setRig(new CMFRig(RenderConstants.AFRICAN_BUSH_ELEPHANT, new ResourceLocation("zawa", "models/entity/african_bush_elephant/african_bush_elephant.rig")));
        RenderConstants.AFRICAN_BUSH_ELEPHANT.setAnimator(AElephantAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityAfricanElephant entity) {
        if (entity.func_70631_g_()) {
            return BLINK_BABY;
        }
        switch (AbstractZawaLand.getVariant(entity)) {
            default: {
                return BLINK_1_3;
            }
            case 1: {
                return BLINK_2;
            }
            case 3: 
        }
        return BLINK_4;
    }

    @Override
    protected void preRenderCallback(EntityAfricanElephant elepnt, float partialTickTime) {
        if (elepnt.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            if (!elepnt.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)-0.1f);
            }
        } else {
            if (!elepnt.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.15f, (float)-0.1f);
            }
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        super.preRenderCallback(elepnt, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityAfricanElephant animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityAfricanElephant e) {
        return CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.AFRICAN_BUSH_ELEPHANT_BABY.setAnimator(BabyElephantAnimator::new);
        return RenderConstants.AFRICAN_BUSH_ELEPHANT_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityAfricanElephant e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/african_elephant/african_bush_elephant.png");
        CONTAINER.addResource("textures/entity/african_elephant/african_bush_elephant2.png");
        CONTAINER.addResource("textures/entity/african_elephant/african_bush_elephant3.png");
        CONTAINER.addResource("textures/entity/african_elephant/african_bush_elephant4.png");
        CONTAINER.addResource("baby", "textures/entity/african_elephant/african_bush_elephant_baby.png");
        CONTAINER.addResource("generic", "textures/entity/african_elephant/saddle.png");
        CONTAINER.addResource("blink", "textures/entity/african_elephant/african_bush_elephant_blink_1_3.png");
        CONTAINER.addResource("blink", "textures/entity/african_elephant/african_bush_elephant_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/african_elephant/african_bush_elephant_blink_4.png");
        CONTAINER.addResource("blink", "textures/entity/african_elephant/african_bush_elephant_blink_baby.png");
    }

    public static class AElephantAnimator
    extends ZAWAAnimator<EntityAfricanElephant> {
        private final BookwormModelRenderer ThighRight = this.getModel().getPartFromRig("Thigh Right");
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartFromRig("Thigh Left");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartFromRig("Arm Left");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartFromRig("Arm Right");
        private final BookwormModelRenderer neck = this.getModel().getPartFromRig("Neck");
        private final BookwormModelRenderer ear1 = this.getModel().getPartFromRig("Ear Right");
        private final BookwormModelRenderer ear2 = this.getModel().getPartFromRig("Ear Left");
        private final BookwormModelRenderer tromp1 = this.getModel().getPartFromRig("Trunk Base");
        private final BookwormModelRenderer tromp2 = this.getModel().getPartFromRig("Trunk");
        private final BookwormModelRenderer tromp3 = this.getModel().getPartFromRig("Trunk 2");
        private final BookwormModelRenderer Tail = this.getModel().getPartFromRig("Tail");
        private final BookwormModelRenderer TuskA = this.getModel().getPartFromRig("Tusk Base Left");
        private final BookwormModelRenderer TuskB = this.getModel().getPartFromRig("Tusk Base Right");
        private final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        private final BookwormModelRenderer FootBRight = this.getModel().getPartFromRig("Foot B Right");
        private final BookwormModelRenderer FootBLeft = this.getModel().getPartFromRig("Foot B Left");
        private final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("Leg Right");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("Leg Left");
        private final BookwormModelRenderer ForearmRight = this.getModel().getPartFromRig("Forearm Right");
        private final BookwormModelRenderer ForearmLeft = this.getModel().getPartFromRig("Forearm Left");
        private final BookwormModelRenderer FootFRight = this.getModel().getPartFromRig("Foot F Right");
        private final BookwormModelRenderer FootFLeft = this.getModel().getPartFromRig("Foot F Left");
        private final BookwormModelRenderer Hips = this.getModel().getPartFromRig("Hips");

        public AElephantAnimator(ModelCMF model) {
            super(model);
        }

        public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        @Override
        public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, EntityAfricanElephant e) {
            this.TuskA.renderPartScale = 1.0f;
            this.TuskB.renderPartScale = 1.0f;
            super.setRotationAngles(f, f1, f2, f3, f4, f5, e);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAfricanElephant e) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, e);
            this.speed = 2.8f;
            this.degree = 0.5f;
            if (e.func_184179_bs() == null) {
                this.tromp1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f - 0.5f;
                this.tromp2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f + 0.3f;
                this.tromp3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f + 0.3f;
            } else {
                this.setRotateAngle((ModelRenderer)this.tromp1, -0.5235988f, 0.0f, 0.0f);
                this.setRotateAngle((ModelRenderer)this.tromp2, -0.3642502f, -0.0f, 0.0f);
                this.setRotateAngle((ModelRenderer)this.tromp3, -1.1383038f, 0.0f, 0.0f);
            }
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(10.0f + f * this.speed * 0.5f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.1f) * f1 * 0.5f;
            this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(21.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.2f;
            this.FootBRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.8f) * f1 * 0.5f + -0.2f;
            this.ThighRight.field_82908_p = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(46.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.8f) * f1 * 0.5f + 0.15f;
            this.ForearmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.1f) * f1 * 0.5f;
            this.FootFRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.8f) * f1 * 0.5f + -0.1f;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(21.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.8f) * f1 * 0.5f + 0.2f;
            this.FootBLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + -0.2f;
            this.ThighLeft.field_82908_p = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -0.1f) * f1 * 0.5f;
            this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(46.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.15f;
            this.ForearmLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.1f) * f1 * 0.5f;
            this.FootFLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + -0.1f;
            this.Hips.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            this.Tail.field_78808_h = MathHelper.func_76134_b((float)(-0.3f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f;
            this.ear1.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * 1.0f) * f1 * 0.5f - 0.5f;
            this.ear2.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * -1.0f) * f1 * 0.5f + 0.5f;
            this.neck.field_78795_f = f4 / 57.295776f;
            this.neck.field_78796_g = f3 / 57.295776f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f;
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAfricanElephant e) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, e);
            this.speed = 0.2f;
            this.degree = 1.1f;
            this.tromp1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f - 0.5f;
            this.tromp2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f;
            this.tromp3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f;
            this.Tail.field_78808_h = MathHelper.func_76134_b((float)(32.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f * -1.0f) * f1 * 0.5f;
            this.ear2.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * 1.0f) * f1 * 0.5f + 0.1f;
            this.ear1.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * -1.0f) * f1 * 0.5f - 0.1f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(32.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f - 0.0f;
        }
    }

    public static class BabyElephantAnimator
    extends ZAWAAnimator<EntityAfricanElephant> {
        private final BookwormModelRenderer thight4 = this.getModel().getPartFromRig("Thigh Right");
        private final BookwormModelRenderer thight3 = this.getModel().getPartFromRig("Thigh Left");
        private final BookwormModelRenderer thight1 = this.getModel().getPartFromRig("Arm Right");
        private final BookwormModelRenderer thight2 = this.getModel().getPartFromRig("Arm Left");
        private final BookwormModelRenderer neck = this.getModel().getPartFromRig("Neck");
        private final BookwormModelRenderer ear1 = this.getModel().getPartFromRig("Ear Left");
        private final BookwormModelRenderer ear2 = this.getModel().getPartFromRig("Ear Right");
        private final BookwormModelRenderer tromp1 = this.getModel().getPartFromRig("Trunk Base");
        private final BookwormModelRenderer tromp2 = this.getModel().getPartFromRig("Trunk 2");
        private final BookwormModelRenderer tromp3 = this.getModel().getPartFromRig("Trunk 3");
        private final BookwormModelRenderer tail = this.getModel().getPartFromRig("Tail");

        public BabyElephantAnimator(ModelCMF model) {
            super(model);
        }

        public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAfricanElephant e) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, e);
            this.speed = 3.2f;
            this.degree = 0.8f;
            this.tromp1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f - 0.5f;
            this.tromp2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f + 0.3f;
            this.tromp3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f + 0.3f;
            this.thight1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f * -1.0f) * f1 * 0.5f;
            this.thight2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.5f;
            this.thight3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f * -1.0f) * f1 * 0.5f - 0.3f;
            this.thight4.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.5f - 0.3f;
            this.tail.field_78808_h = MathHelper.func_76134_b((float)(32.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f * -1.0f) * f1 * 0.5f;
            this.ear1.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * 1.0f) * f1 * 0.5f - 0.5f;
            this.ear2.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * -1.0f) * f1 * 0.5f + 0.5f;
            this.neck.field_78795_f = f4 / 57.295776f - 0.4f;
            this.neck.field_78796_g = f3 / 57.295776f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(12.0f + f * (0.1562f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f - 0.4f;
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAfricanElephant e) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, e);
            this.speed = 0.2f;
            this.degree = 1.1f;
            this.tromp1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f - 0.5f;
            this.tromp2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f;
            this.tromp3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f;
            this.tail.field_78808_h = MathHelper.func_76134_b((float)(32.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f * -1.0f) * f1 * 0.5f;
            this.ear2.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * 1.0f) * f1 * 0.5f + 0.1f;
            this.ear1.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * -1.0f) * f1 * 0.5f - 0.1f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(32.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f - 0.4f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerAfricanElephant
    implements LayerRenderer<EntityAfricanElephant> {
        private final RenderAfricanElephant render;

        public LayerAfricanElephant(RenderAfricanElephant re) {
            this.render = re;
        }

        public void doRenderLayer(EntityAfricanElephant e, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (!e.func_82150_aj() && ModuleManager.SADDLE.isSaddled(e)) {
                this.render.func_110776_a(SADDLE);
                RenderConstants.AFRICAN_BUSH_ELEPHANT.func_178686_a(this.render.func_177087_b());
                RenderConstants.AFRICAN_BUSH_ELEPHANT.func_78087_a(f, f1, f3, f4, f5, f6, (Entity)e);
                RenderConstants.AFRICAN_BUSH_ELEPHANT.func_78088_a((Entity)e, f, f1, f2, f3, f4, f6);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

