/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import gigaherz.graph.api.GraphObject;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.valkyrienskies.addon.control.block.BlockSpeedTelegraph;
import org.valkyrienskies.addon.control.nodenetwork.VSNode_TileEntity;
import org.valkyrienskies.addon.control.tileentity.TileEntityGearbox;
import org.valkyrienskies.addon.control.tileentity.TileEntityNodePilotableImpl;
import org.valkyrienskies.mod.common.network.VSNetwork;
import org.valkyrienskies.mod.common.piloting.ControllerInputType;
import org.valkyrienskies.mod.common.piloting.PilotControlsMessage;

public class TileEntitySpeedTelegraph
extends TileEntityNodePilotableImpl
implements ITickable {
    private ShipChadburnState telegraphState = ShipChadburnState.STOP;
    private ShipChadburnState nextTelegraphState = ShipChadburnState.STOP;
    private double handleRotation = 0.0;
    private double prevHandleRotation = 0.0;

    @Override
    public void processControlMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        EnumFacing facing;
        IBlockState blockState;
        int deltaOrdinal = 0;
        if (message.airshipLeft_KeyPressed) {
            --deltaOrdinal;
        }
        if (message.airshipRight_KeyPressed) {
            ++deltaOrdinal;
        }
        if ((blockState = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177230_c() instanceof BlockSpeedTelegraph && this.isPlayerInFront((EntityPlayer)sender, facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockSpeedTelegraph.FACING))) {
            deltaOrdinal *= -1;
        }
        int newTelegraphOrdinal = this.telegraphState.ordinal();
        newTelegraphOrdinal += deltaOrdinal;
        newTelegraphOrdinal = Math.max(0, Math.min(ShipChadburnState.values().length - 1, newTelegraphOrdinal));
        this.telegraphState = ShipChadburnState.values()[newTelegraphOrdinal];
        this.func_70296_d();
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.nextTelegraphState = ShipChadburnState.valueOf(pkt.func_148857_g().func_74779_i("TelegraphState"));
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagToSend = new NBTTagCompound();
        tagToSend.func_74778_a("TelegraphState", this.telegraphState.name());
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tagToSend);
    }

    public double getHandleRenderRotation(float partialTicks) {
        double interpolatedHandle = this.prevHandleRotation + (this.handleRotation - this.prevHandleRotation) * (double)partialTicks;
        return -interpolatedHandle + 112.5;
    }

    @Override
    public void func_73660_a() {
        if (this.getNode() == null || this.getNode().getGraph() == null) {
            this.field_145846_f = true;
        }
        if (this.func_145831_w().field_72995_K) {
            this.prevHandleRotation = this.handleRotation;
            this.handleRotation += (this.nextTelegraphState.renderRotation - this.handleRotation) * 0.5;
            this.telegraphState = this.nextTelegraphState;
        } else {
            Collection<GraphObject> connectedGraphObjects = this.getNode().getGraph().getObjects();
            if (connectedGraphObjects == null) {
                new IllegalStateException("Graph object neighbors are null! Skipping ship telegraph update.").printStackTrace();
                return;
            }
            for (GraphObject object : connectedGraphObjects) {
                VSNode_TileEntity otherNode = (VSNode_TileEntity)object;
                TileEntity tile = otherNode.getParentTile();
                if (!(tile instanceof TileEntityGearbox)) continue;
                TileEntityGearbox masterTile = (TileEntityGearbox)tile;
                if (this.telegraphState == ShipChadburnState.STOP) {
                    masterTile.setOutputRatio(Optional.empty());
                    continue;
                }
                masterTile.setOutputRatio(Optional.of(this.telegraphState.gearboxOutputRatio));
            }
            VSNetwork.sendTileToAllNearby((TileEntity)this);
        }
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound toReturn = super.func_189517_E_();
        return toReturn;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.telegraphState = ShipChadburnState.valueOf(compound.func_74779_i("TelegraphState"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound toReturn = super.func_189515_b(compound);
        toReturn.func_74778_a("TelegraphState", this.telegraphState.name());
        return toReturn;
    }

    @Override
    public ControllerInputType getControlInputType() {
        return ControllerInputType.Telegraph;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_72321_a(0.0, 1.0, 0.0);
    }

    private static enum ShipChadburnState {
        FULL_AHEAD(-120.0, 4.0),
        HALF_AHEAD(-80.0, 2.0),
        SLOW_AHEAD(-40.0, 1.0),
        STOP(0.0, 0.0),
        SLOW_ASTERN(40.0, -1.0),
        HALF_ASTERN(80.0, -2.0),
        FULL_ASTERN(120.0, -4.0);

        public final double renderRotation;
        public final double gearboxOutputRatio;

        private ShipChadburnState(double renderRotation, double gearboxOutputRatio) {
            this.renderRotation = renderRotation;
            this.gearboxOutputRatio = gearboxOutputRatio;
        }
    }
}

