/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.nodenetwork.BasicNodeTileEntity;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.network.MessageStartPiloting;
import org.valkyrienskies.mod.common.network.MessageStopPiloting;
import org.valkyrienskies.mod.common.piloting.ControllerInputType;
import org.valkyrienskies.mod.common.piloting.ITileEntityPilotable;
import org.valkyrienskies.mod.common.piloting.PilotControlsMessage;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

public abstract class TileEntityNodePilotableImpl
extends BasicNodeTileEntity
implements ITileEntityPilotable {
    @Nullable
    private UUID pilotPlayerEntity = null;

    public final void onPilotControlsMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        if (sender.func_110124_au().equals(this.pilotPlayerEntity)) {
            this.processControlMessage(message, sender);
        }
    }

    public final EntityPlayer getPilotEntity() {
        if (this.pilotPlayerEntity != null) {
            return this.func_145831_w().func_152378_a(this.pilotPlayerEntity);
        }
        return null;
    }

    public final void setPilotEntity(EntityPlayer toSet) {
        if (!this.func_145831_w().field_72995_K) {
            EntityPlayer oldPlayer = this.getPilotEntity();
            this.sendPilotUpdatePackets((EntityPlayerMP)toSet, (EntityPlayerMP)oldPlayer);
        }
        if (toSet != null) {
            this.pilotPlayerEntity = toSet.func_110124_au();
            this.onStartTileUsage();
        } else {
            this.pilotPlayerEntity = null;
            this.onStopTileUsage();
        }
    }

    public final void playerWantsToStopPiloting(EntityPlayer player) {
        if (player == this.getPilotEntity()) {
            this.setPilotEntity(null);
        }
    }

    public final PhysicsObject getParentPhysicsEntity() {
        return ValkyrienUtils.getPhysoManagingBlock((World)this.field_145850_b, (BlockPos)this.field_174879_c).orElse(null);
    }

    private void sendPilotUpdatePackets(EntityPlayerMP newPilot, EntityPlayerMP oldPilot) {
        if (oldPilot != null && oldPilot != newPilot) {
            MessageStopPiloting stopMessage = new MessageStopPiloting(this.func_174877_v());
            ValkyrienSkiesMod.controlNetwork.sendTo((IMessage)stopMessage, oldPilot);
        }
        if (newPilot != null) {
            MessageStartPiloting startMessage = new MessageStartPiloting(this.func_174877_v(), this.setClientPilotingEntireShip(), this.getControlInputType());
            ValkyrienSkiesMod.controlNetwork.sendTo((IMessage)startMessage, newPilot);
        }
    }

    public abstract ControllerInputType getControlInputType();

    @Deprecated
    public boolean setClientPilotingEntireShip() {
        return false;
    }

    public abstract void processControlMessage(PilotControlsMessage var1, EntityPlayerMP var2);

    protected boolean isPlayerInFront(EntityPlayer player, EnumFacing blockFacing) {
        double dotProduct;
        Vector3d tileRelativePos = new Vector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        if (this.getParentPhysicsEntity() != null) {
            this.getParentPhysicsEntity().getShipTransformationManager().getCurrentTickTransform().transformPosition(tileRelativePos, TransformType.SUBSPACE_TO_GLOBAL);
        }
        tileRelativePos.sub(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        Vector3d normal = new Vector3d((double)(blockFacing.func_176730_m().func_177958_n() * -1), (double)blockFacing.func_176730_m().func_177956_o(), (double)blockFacing.func_176730_m().func_177952_p());
        if (this.getParentPhysicsEntity() != null) {
            this.getParentPhysicsEntity().getShipTransformationManager().getCurrentTickTransform().transformDirection(normal, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return (dotProduct = tileRelativePos.dot((Vector3dc)normal)) > 0.0;
    }
}

