/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.config.VSControlConfig;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import valkyrienwarfare.api.TransformType;

public class TileEntityGyroscopeStabilizer
extends TileEntity {
    private static final Vector3dc GRAVITY_UP = new Vector3d(0.0, 1.0, 0.0);

    public Vector3dc getTorqueInGlobal(PhysicsCalculations physicsCalculations, BlockPos pos) {
        Vector3d shipLevelNormal = new Vector3d(GRAVITY_UP);
        physicsCalculations.getParent().getShipTransformationManager().getCurrentPhysicsTransform().transformDirection(shipLevelNormal, TransformType.SUBSPACE_TO_GLOBAL);
        Vector3d torqueDir = GRAVITY_UP.cross((Vector3dc)shipLevelNormal, new Vector3d());
        if (torqueDir.lengthSquared() < 1.0E-10) {
            return new Vector3d();
        }
        double angleBetween = Math.toDegrees(GRAVITY_UP.angle((Vector3dc)shipLevelNormal));
        torqueDir.normalize();
        double torquePowerFactor = angleBetween / 5.0;
        torquePowerFactor = Math.max(Math.min(1.0, torquePowerFactor), 0.0);
        return torqueDir.mul(VSControlConfig.stabilizerMaxTorque * torquePowerFactor * physicsCalculations.getPhysicsTimeDeltaPerPhysTick() * -1.0);
    }
}

