/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.renderer.atom_animation_parser.impl;

import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.renderer.atom_animation_parser.IModelRenderer;
import org.valkyrienskies.addon.control.renderer.atom_animation_parser.impl.BasicAnimationTransform;

public class BasicDagNodeRenderer {
    private final String modelName;
    protected final List<BasicAnimationTransform> transformations;
    private final IModelRenderer modelRenderer;
    protected Vector3dc pivot;

    public BasicDagNodeRenderer(String modelName, List<BasicAnimationTransform> transformations, IModelRenderer modelRenderer) {
        this.modelName = modelName;
        this.transformations = transformations;
        this.modelRenderer = modelRenderer;
        this.pivot = new Vector3d();
    }

    public void render(double keyframe, int brightness) {
        for (int i = 0; i < this.transformations.size(); ++i) {
            Vector3d customPivot = new Vector3d(this.pivot);
            for (int j = this.transformations.size() - 1; j > i; --j) {
                this.transformations.get(j).changePivot(customPivot, keyframe);
            }
            GlStateManager.func_179137_b((double)customPivot.x, (double)customPivot.y, (double)customPivot.z);
            this.transformations.get(i).transform(keyframe);
            GlStateManager.func_179137_b((double)(-customPivot.x), (double)(-customPivot.y), (double)(-customPivot.z));
        }
        this.modelRenderer.renderModel(this.modelName, brightness);
    }

    public void setPivot(Vector3dc pivot) {
        this.pivot = pivot;
    }

    public String getModelName() {
        return this.modelName;
    }
}

