/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.renderer.atom_animation_parser.impl;

import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import org.joml.Vector3d;
import org.valkyrienskies.addon.control.renderer.atom_animation_parser.impl.BasicKeyframeInterpolator;

public class BasicAnimationTransform {
    private final String animationTransform;
    private final BasicKeyframeInterpolator interpolator;

    public BasicAnimationTransform(String animationTransform, List<String[]> keyframes) {
        this.animationTransform = animationTransform;
        this.interpolator = new BasicKeyframeInterpolator(keyframes);
    }

    public void transform(double keyFrame) {
        float value = (float)this.interpolator.getValue(keyFrame);
        switch (this.animationTransform) {
            case "translateX": {
                GlStateManager.func_179109_b((float)value, (float)0.0f, (float)0.0f);
                break;
            }
            case "translateY": {
                GlStateManager.func_179109_b((float)0.0f, (float)value, (float)0.0f);
                break;
            }
            case "translateZ": {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)value);
                break;
            }
            case "rotateX": {
                GlStateManager.func_179114_b((float)value, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case "rotateY": {
                GlStateManager.func_179114_b((float)value, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case "rotateZ": {
                GlStateManager.func_179114_b((float)value, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case "scaleX": {
                GlStateManager.func_179152_a((float)value, (float)1.0f, (float)1.0f);
                break;
            }
            case "scaleY": {
                GlStateManager.func_179152_a((float)1.0f, (float)value, (float)1.0f);
                break;
            }
            case "scaleZ": {
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)value);
            }
        }
    }

    public void changePivot(Vector3d pivotChange, double keyframe) {
        double value = this.interpolator.getValue(keyframe);
        switch (this.animationTransform) {
            case "translateX": {
                pivotChange.x += value;
                break;
            }
            case "translateY": {
                pivotChange.y += value;
                break;
            }
            case "translateZ": {
                pivotChange.z += value;
            }
        }
    }
}

