/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.renderer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.valkyrienskies.addon.control.renderer.atom_animation_parser.IAtomAnimation;
import org.valkyrienskies.addon.control.renderer.atom_animation_parser.impl.BasicAtomAnimationBuilder;
import org.valkyrienskies.addon.control.renderer.atom_animation_parser.parsers.AtomParser;
import org.valkyrienskies.mod.client.render.GibsModelRegistry;

public class GibsAtomAnimationRegistry {
    private static final Map<String, IAtomAnimation> ANIMATION_MAP = new HashMap<String, IAtomAnimation>();

    public static void registerAnimation(String name, ResourceLocation location) {
        try {
            IResource animationResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            Scanner data = new Scanner(animationResource.func_110527_b());
            AtomParser dataParser = new AtomParser(data);
            BasicAtomAnimationBuilder animationBuilder = new BasicAtomAnimationBuilder(dataParser);
            Set<String> modelsUsed = animationBuilder.getModelObjsUsed();
            String resourceDomainName = location.func_110624_b();
            StringBuilder modelResourceFolder = new StringBuilder();
            String[] temp = location.func_110623_a().split("/");
            for (int i = 1; i < temp.length - 1; ++i) {
                modelResourceFolder.append(temp[i]).append("/");
            }
            for (String modelName2 : modelsUsed) {
                String modelFullPath = modelResourceFolder + modelName2;
                ResourceLocation modelToRegister = new ResourceLocation(resourceDomainName, modelResourceFolder + modelName2 + ".obj");
                GibsModelRegistry.registerGibsModel((String)modelFullPath, (ResourceLocation)modelToRegister);
            }
            String modelResourceFolderFinal = modelResourceFolder.toString();
            ANIMATION_MAP.put(name, animationBuilder.build((modelName, renderBrightness) -> GibsModelRegistry.renderGibsModel((String)(modelResourceFolderFinal + modelName), (int)renderBrightness)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static IAtomAnimation getAnimation(String name) {
        return ANIMATION_MAP.get(name);
    }

    public static void onResourceReload() {
    }
}

