/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.opengl.GL11;
import org.valkyrienskies.addon.control.item.ItemBaseWire;
import org.valkyrienskies.addon.control.item.ItemVSWrench;
import org.valkyrienskies.addon.control.nodenetwork.EnumWireType;
import org.valkyrienskies.addon.control.nodenetwork.VSNode_TileEntity;
import org.valkyrienskies.addon.control.tileentity.TileEntityNetworkRelay;

public class BasicNodeTileEntityRenderer
extends TileEntitySpecialRenderer<TileEntityNetworkRelay> {
    private static final float[][] colours = new float[][]{{0.6f, 0.25f, 0.02f, 1.0f}, {0.37f, 0.92f, 0.85f, 0.5f}};

    public void render(TileEntityNetworkRelay te, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        GlStateManager.func_179084_k();
        VSNode_TileEntity tileNode = te.getNode();
        if (tileNode != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.5, (double)-1.0, (double)0.5);
            int i = 0;
            for (BlockPos otherPos : tileNode.getLinkedNodesPos()) {
                TileEntity otherTile = this.func_178459_a().func_175625_s(otherPos);
                EnumWireType wireType = tileNode.getLinkedWireTypes().get(i++);
                if (otherTile instanceof TileEntityNetworkRelay && otherTile.func_174877_v().compareTo((Vec3i)te.func_174877_v()) < 0) continue;
                if (wireType == EnumWireType.VANISHING) {
                    EntityPlayerSP entity = Minecraft.func_71410_x().field_71439_g;
                    ItemStack stackR = entity.func_184586_b(EnumHand.MAIN_HAND);
                    ItemStack stackL = entity.func_184586_b(EnumHand.OFF_HAND);
                    if (!this.canUnvanish(stackR) && !this.canUnvanish(stackL)) continue;
                }
                GL11.glPushMatrix();
                double startX = te.func_174877_v().func_177958_n();
                double startY = te.func_174877_v().func_177956_o();
                double startZ = te.func_174877_v().func_177952_p();
                double endX = startX * 2.0 - (double)otherPos.func_177958_n();
                double endY = startY * 2.0 - (double)otherPos.func_177956_o() - 1.5;
                double endZ = startZ * 2.0 - (double)otherPos.func_177952_p();
                this.renderWire(x, y, z, startX, startY, startZ, endX, endY, endZ, wireType.ordinal());
                GL11.glPopMatrix();
            }
            GlStateManager.func_179117_G();
            GL11.glPopMatrix();
        }
    }

    private void renderWire(double x, double y, double z, double entity1x, double entity1y, double entity1z, double entity2x, double entity2y, double entity2z, int wireType) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        float wireR = colours[wireType][0];
        float wireG = colours[wireType][1];
        float wireB = colours[wireType][2];
        float wireAlpha = colours[wireType][3];
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = Math.cos(d0);
        double d3 = Math.sin(d0);
        double d4 = Math.sin(d1);
        d4 = -1.0;
        double fakeYaw = 0.0;
        double d6 = entity1x;
        double d7 = entity1y;
        double d8 = entity1z;
        double d9 = fakeYaw;
        d2 = 0.0;
        d3 = 0.0;
        double d10 = entity2x + d2;
        double d11 = entity2y;
        double d12 = entity2z + d3;
        x += d2;
        z += d3;
        double d13 = (float)(d6 - d10);
        double d14 = (float)(d7 - d11);
        double d15 = (float)(d8 - d12);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        int i = 24;
        double d16 = 0.025;
        bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (int j = 0; j <= 24; ++j) {
            float f3 = (float)j / 24.0f;
            bufferbuilder.func_181662_b(x + d13 * (double)f3 + 0.0, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f), z + d15 * (double)f3).func_181666_a(wireR, wireG, wireB, wireAlpha).func_181675_d();
            bufferbuilder.func_181662_b(x + d13 * (double)f3 + 0.025, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f3).func_181666_a(wireR, wireG, wireB, wireAlpha).func_181675_d();
        }
        tessellator.func_78381_a();
        bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (int k = 0; k <= 24; ++k) {
            float f4 = 0.8f;
            float f5 = 0.47843137f;
            float f6 = 0.0f;
            if (k % 2 == 0) {
                f4 *= 0.7f;
                f5 *= 0.7f;
                f6 *= 0.7f;
            }
            float f7 = (float)k / 24.0f;
            bufferbuilder.func_181662_b(x + d13 * (double)f7 + 0.0, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f7).func_181666_a(wireR, wireG, wireB, wireAlpha).func_181675_d();
            bufferbuilder.func_181662_b(x + d13 * (double)f7 + 0.025, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f), z + d15 * (double)f7 + 0.025).func_181666_a(wireR, wireG, wireB, wireAlpha).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    private boolean canUnvanish(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ItemBaseWire || item instanceof ItemVSWrench;
    }
}

