/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.nodenetwork;

import net.minecraft.nbt.NBTTagCompound;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.nodenetwork.BasicNodeTileEntity;
import org.valkyrienskies.addon.control.nodenetwork.IForceTile;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienNBTUtils;

public abstract class BasicForceNodeTileEntity
extends BasicNodeTileEntity
implements IForceTile {
    protected double maxThrust = 5000.0;
    protected double currentThrust = 0.0;
    private double thrusGoalMultiplier = 0.0;
    private Vector3dc forceOutputVector = new Vector3d();
    private Vector3dc normalVelocityUnoriented;
    private int ticksSinceLastControlSignal = 0;
    private boolean hasAlreadyCheckedForParent = false;

    public BasicForceNodeTileEntity() {
    }

    public BasicForceNodeTileEntity(Vector3dc normalVelocityUnoriented, boolean isForceOutputOriented, double maxThrust) {
        this();
        this.normalVelocityUnoriented = normalVelocityUnoriented;
        this.maxThrust = maxThrust;
    }

    public boolean isForceOutputOriented() {
        return true;
    }

    @Override
    public Vector3dc getForceOutputNormal(double secondsToApply, PhysicsObject object) {
        return this.normalVelocityUnoriented;
    }

    @Override
    public double getMaxThrust() {
        return this.maxThrust;
    }

    @Override
    public void setMaxThrust(double maxThrust) {
        this.maxThrust = maxThrust;
    }

    @Override
    public double getThrustMagnitude(PhysicsObject physicsObject) {
        return this.getMaxThrust() * this.getThrustMultiplierGoal();
    }

    @Override
    public double getThrustMultiplierGoal() {
        return this.thrusGoalMultiplier;
    }

    @Override
    public void setThrustMultiplierGoal(double multiplier) {
        this.thrusGoalMultiplier = multiplier;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.maxThrust = compound.func_74769_h("maxThrust");
        this.currentThrust = compound.func_74769_h("currentThrust");
        this.normalVelocityUnoriented = ValkyrienNBTUtils.readVectorFromNBT((String)"normalVelocityUnoriented", (NBTTagCompound)compound);
        this.ticksSinceLastControlSignal = compound.func_74762_e("ticksSinceLastControlSignal");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74780_a("maxThrust", this.maxThrust);
        compound.func_74780_a("currentThrust", this.currentThrust);
        ValkyrienNBTUtils.writeVectorToNBT((String)"normalVelocityUnoriented", (Vector3dc)this.normalVelocityUnoriented, (NBTTagCompound)compound);
        compound.func_74768_a("ticksSinceLastControlSignal", this.ticksSinceLastControlSignal);
        return super.func_189515_b(compound);
    }

    public boolean updateParentShip() {
        return true;
    }

    public void updateTicksSinceLastRecievedSignal() {
        this.ticksSinceLastControlSignal = 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ++this.ticksSinceLastControlSignal;
        if (this.ticksSinceLastControlSignal > 5 && this.getThrustMultiplierGoal() != 0.0) {
            this.setThrustMultiplierGoal(this.getThrustMultiplierGoal() * 0.9);
        }
    }
}

