/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.valkyrienskies.mod.common.command.config.ShortName;
import org.valkyrienskies.mod.common.config.VSConfigTemplate;

@Config(modid="vs_control")
public class VSControlConfig
extends VSConfigTemplate {
    @Config.Name(value="Disable Wrench Modes")
    @Config.Comment(value={"Makes wrench toggle a multiblock\u00e2\u20ac\u2122s constructed state, removes modes."})
    public static boolean wrenchModeless = false;
    @Config.Name(value="Network Relay Connections Limit")
    @Config.Comment(value={"How many components or relays can be connected to a Network Relay block.", "Default is 8."})
    public static int networkRelayLimit = 8;
    @Config.Name(value="Relay Wire Max Length")
    @Config.Comment(value={"How long a single relay wire can extend.", "Default is 8 meters."})
    public static double relayWireLength = 8.0;
    @Config.Name(value="Compacted Valkyrium Upwards Force")
    @Config.Comment(value={"How much upwards force each block applies.", "Default is 200000 Newtons."})
    public static double compactedValkyriumLift = 200000.0;
    @Config.Name(value="Gyroscope Stabilizer Max Torque")
    @Config.Comment(value={"Max torque in newton-meters"})
    public static double stabilizerMaxTorque = 1.5E7;
    @Config.Name(value="Gyroscope Dampener Max Torque")
    @Config.Comment(value={"Max torque in newton-meters"})
    public static double dampenerMaxTorque = 10000.0;
    @Config.Name(value="Valkyrium Compressor Max Height")
    @Config.Comment(value={"Valkyrium Compressor efficiency linearly decreases until it reaches 0 at this height"})
    public static double compressorMaxHeight = 500.0;
    @Config.Name(value="Engine Thrust Settings")
    @ShortName(value="engineThrust")
    @Config.Comment(value={"Set the thrust force of engine blocks.", "Engines blocks must be replaced after changes are made."})
    @Config.LangKey(value="vs_control.general.engine_thrust")
    public static final EngineThrust ENGINE_THRUST = new EngineThrust();

    public static void sync() {
        ConfigManager.sync((String)"vs_control", (Config.Type)Config.Type.INSTANCE);
        VSControlConfig.onSync();
    }

    @Mod.EventBusSubscriber(modid="vs_control")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("vs_control")) {
                VSControlConfig.sync();
            }
        }
    }

    public static class EngineThrust {
        @Config.RequiresMcRestart
        @Config.Name(value="Basic Engine Thrust")
        public double basicEngineThrust = 100000.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Advanced Engine Thrust")
        public double advancedEngineThrust = 250000.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Elite Engine Thrust")
        public double eliteEngineThrust = 500000.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Ultimate Engine Thrust")
        public double ultimateEngineThrust = 1000000.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Redstone Engine Thrust")
        public double redstoneEngineThrust = 62500.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Valkyrium Compressor Thrust")
        public double compressorMaxThrust = 2000000.0;
    }
}

