/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.torque;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.block.torque.IRotationNode;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeProvider;
import org.valkyrienskies.addon.control.block.torque.PhysicsAssert;
import org.valkyrienskies.addon.control.block.torque.PhysicsThreadOnly;
import org.valkyrienskies.addon.control.block.torque.custom_torque_functions.SimpleTorqueFunction;
import org.valkyrienskies.addon.control.block.torque.custom_torque_functions.ValkyriumEngineTorqueFunction;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class ImplRotationNode<T extends TileEntity>
implements IRotationNode {
    private final T tileEntity;
    private final Optional<Double>[] angularVelocityRatios;
    private final ConcurrentLinkedQueue<Runnable> queuedTasks;
    private double angularVelocity;
    private double angularRotation;
    private double rotationalInertia;
    private Optional<BlockPos> nodePos;
    private Optional<SimpleTorqueFunction> customTorqueFunction;
    private boolean initialized;
    private AtomicBoolean markedForDeletion;
    private AtomicBoolean hasBeenPlacedIntoNodeWorld;
    private int sortingPriority;

    public ImplRotationNode(T entity, double rotationalInertia) {
        this.tileEntity = entity;
        this.angularVelocityRatios = new Optional[]{Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()};
        this.angularVelocity = 0.0;
        this.angularRotation = 0.0;
        this.rotationalInertia = rotationalInertia;
        this.nodePos = Optional.empty();
        this.customTorqueFunction = Optional.empty();
        this.initialized = false;
        this.queuedTasks = new ConcurrentLinkedQueue();
        this.markedForDeletion = new AtomicBoolean(false);
        this.hasBeenPlacedIntoNodeWorld = new AtomicBoolean(false);
        this.sortingPriority = 0;
    }

    public ImplRotationNode(T entity, double rotationalInertia, int sortingPriority) {
        this(entity, rotationalInertia);
        this.setSortingPriority(sortingPriority);
    }

    @Override
    @PhysicsThreadOnly
    public Optional<SimpleTorqueFunction> getCustomTorqueFunction() {
        PhysicsAssert.assertPhysicsThread();
        return this.customTorqueFunction;
    }

    @Override
    @PhysicsThreadOnly
    public void setCustomTorqueFunction(SimpleTorqueFunction customTorqueFunction) {
        PhysicsAssert.assertPhysicsThread();
        this.customTorqueFunction = Optional.of(customTorqueFunction);
    }

    @Override
    @PhysicsThreadOnly
    public Optional<Double> getAngularVelocityRatioFor(EnumFacing side) {
        PhysicsAssert.assertPhysicsThread();
        this.assertInitialized();
        return this.angularVelocityRatios[side.ordinal()];
    }

    @Override
    @PhysicsThreadOnly
    public Optional<IRotationNode> getTileOnSide(EnumFacing side) {
        TileEntity sideTile;
        PhysicsAssert.assertPhysicsThread();
        this.assertInitialized();
        BlockPos sideTilePos = this.nodePos.get().func_177971_a(side.func_176730_m());
        try {
            sideTile = ValkyrienUtils.getTileEntitySafe((World)this.tileEntity.func_145831_w(), (BlockPos)sideTilePos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
        if (!(sideTile instanceof IRotationNodeProvider)) {
            return Optional.empty();
        }
        return ((IRotationNodeProvider)sideTile).getRotationNode();
    }

    @Override
    public double getAngularVelocity() {
        this.assertInitialized();
        return this.angularVelocity;
    }

    @Override
    @PhysicsThreadOnly
    public void setAngularVelocity(double angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    @Override
    public double getAngularRotation() {
        this.assertInitialized();
        return this.angularRotation;
    }

    @Override
    @PhysicsThreadOnly
    public void setAngularRotation(double angularRotation) {
        this.angularRotation = angularRotation;
    }

    @Override
    public double getRotationalInertia() {
        this.assertInitialized();
        return this.rotationalInertia;
    }

    @Override
    @PhysicsThreadOnly
    public void setRotationalInertia(double newInertia) {
        PhysicsAssert.assertPhysicsThread();
        this.rotationalInertia = newInertia;
    }

    @Override
    @PhysicsThreadOnly
    public void resetNodeData() {
        PhysicsAssert.assertPhysicsThread();
        Arrays.fill(this.angularVelocityRatios, Optional.empty());
    }

    @Override
    public void markInitialized() {
        assert (!this.initialized) : "We cannot initialize the same node TWICE!";
        this.initialized = true;
        this.nodePos = Optional.of(this.tileEntity.func_174877_v());
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    @PhysicsThreadOnly
    public void setAngularVelocityRatio(EnumFacing side, Optional<Double> newRatio) {
        PhysicsAssert.assertPhysicsThread();
        this.assertInitialized();
        this.angularVelocityRatios[side.ordinal()] = newRatio;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74776_a("a_vel", (float)this.angularVelocity);
        compound.func_74776_a("a_pos", (float)this.angularRotation);
        compound.func_74776_a("a_inert", (float)this.rotationalInertia);
        compound.func_74757_a("a_has_pos", this.getNodePos().isPresent());
        compound.func_74768_a("a_sort_prior", this.getSortingPriority());
        if (this.getNodePos().isPresent()) {
            compound.func_74768_a("a_posX", this.getNodePos().get().func_177958_n());
            compound.func_74768_a("a_posY", this.getNodePos().get().func_177956_o());
            compound.func_74768_a("a_posZ", this.getNodePos().get().func_177952_p());
        }
        for (int i = 0; i < 6; ++i) {
            if (!this.angularVelocityRatios[i].isPresent()) continue;
            compound.func_74776_a("a_vel_ratios_" + i, this.angularVelocityRatios[i].get().floatValue());
        }
        if (this.customTorqueFunction.isPresent()) {
            this.customTorqueFunction = Optional.of(new ValkyriumEngineTorqueFunction(this));
            compound.func_74778_a("custom_torque_funct", this.customTorqueFunction.get().getClass().getName());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.angularVelocity = compound.func_74760_g("a_vel");
        this.angularRotation = compound.func_74760_g("a_pos");
        this.rotationalInertia = compound.func_74760_g("a_inert");
        if (compound.func_74764_b("a_sort_prior")) {
            this.setSortingPriority(compound.func_74762_e("a_sort_prior"));
        }
        if (compound.func_74767_n("a_has_pos")) {
            this.nodePos = Optional.of(new BlockPos(compound.func_74762_e("a_posX"), compound.func_74762_e("a_posY"), compound.func_74762_e("a_posZ")));
        }
        for (int i = 0; i < 6; ++i) {
            if (!compound.func_74764_b("a_vel_ratios_" + i)) continue;
            this.angularVelocityRatios[i] = Optional.of(Double.valueOf(compound.func_74760_g("a_vel_ratios_" + i)));
        }
        if (compound.func_74764_b("custom_torque_funct")) {
            String className = compound.func_74779_i("custom_torque_funct");
            try {
                Class<?> c = Class.forName(className);
                Constructor<?> cons = c.getConstructor(IRotationNode.class);
                Object customTorqueFunction = cons.newInstance(this);
                this.customTorqueFunction = Optional.of((SimpleTorqueFunction)customTorqueFunction);
            }
            catch (Exception e) {
                System.err.println("Failed to load class: " + className);
                e.printStackTrace();
            }
        }
    }

    @Override
    public Optional<BlockPos> getNodePos() {
        return this.nodePos;
    }

    @Override
    public void queueTask(Runnable task) {
        this.queuedTasks.add(task);
    }

    @Override
    public ConcurrentLinkedQueue<Runnable> getQueuedTasks() {
        return this.queuedTasks;
    }

    @Override
    public double getAngularRotationUnsynchronized() {
        return this.angularRotation;
    }

    private void assertInitialized() {
        assert (this.isInitialized()) : "We are not yet initialized!";
        assert (this.nodePos.isPresent()) : "There is NO node pos!";
    }

    @Override
    public void queueNodeForDeletion() {
        this.markedForDeletion.set(true);
    }

    @Override
    public boolean markedForDeletion() {
        return this.markedForDeletion.get();
    }

    @Override
    public double getAngularVelocityUnsynchronized() {
        return this.angularVelocity;
    }

    @Override
    public boolean hasBeenPlacedIntoNodeWorld() {
        return this.hasBeenPlacedIntoNodeWorld.get();
    }

    @Override
    public void setPlacedIntoNodeWorld(boolean status) {
        this.hasBeenPlacedIntoNodeWorld.set(status);
    }

    @Override
    public Optional<Double>[] connectedRotationRatiosUnsychronized() {
        return (Optional[])this.angularVelocityRatios.clone();
    }

    @Override
    public Optional<IRotationNode> getTileOnSideUnsynchronized(EnumFacing side) {
        this.assertInitialized();
        if (!this.nodePos.isPresent()) {
            return Optional.empty();
        }
        BlockPos sideTilePos = this.nodePos.get().func_177971_a(side.func_176730_m());
        TileEntity sideTile = this.tileEntity.func_145831_w().func_175625_s(sideTilePos);
        if (!(sideTile instanceof IRotationNodeProvider)) {
            return Optional.empty();
        }
        return ((IRotationNodeProvider)sideTile).getRotationNode();
    }

    @Override
    public Optional<Double> getAngularVelocityRatioForUnsynchronized(EnumFacing side) {
        this.assertInitialized();
        return this.angularVelocityRatios[side.ordinal()];
    }

    @Override
    @PhysicsThreadOnly
    public int getSortingPriority() {
        return this.sortingPriority;
    }

    @Override
    @PhysicsThreadOnly
    public void setSortingPriority(int newPriority) {
        this.sortingPriority = newPriority;
    }
}

